/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.msml.CoordTransformer;
import de.grogra.imp3d.msml.MSMLWriter;
import de.grogra.imp3d.msml.X3DMSMLDatatype;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Null;
import de.grogra.math.TMatrix4d;
import de.grogra.math.TVector3d;
import de.grogra.math.Transform3D;
import de.grogra.math.UniformScale;
import de.grogra.pf.registry.Registry;
import de.grogra.vecmath.Math2;
import java.net.URL;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Transform
extends X3DMSMLDatatype {
    public static final CoordTransformer READER_COORD = new CoordTransformer(new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f), new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f));

    public void export(Object object, Document document, Element element, de.grogra.graph.impl.Node node) {
        Transform3D transform3D;
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Object object2 = graphState.getObjectDefault((Object)node, true, Attributes.TRANSFORM, null);
        if (object2 != null && (transform3D = (Transform3D)object2) != null) {
            Vector3d vector3d;
            Element element2 = document.createElementNS("http://grogra.de/msml/datatypes/groimp", "g:Transform");
            Element element3 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Transform");
            element2.appendChild(element3);
            element.appendChild(element2);
            if (transform3D instanceof TMatrix4d) {
                Vector3d vector3d2;
                Matrix4d matrix4d = (Matrix4d)transform3D;
                Matrix3d matrix3d = new Matrix3d();
                Matrix3d matrix3d2 = new Matrix3d();
                matrix4d.getRotationScale(matrix3d2);
                Math2.decomposeQR((Matrix3d)matrix3d2, (Matrix3d)matrix3d);
                AxisAngle4d axisAngle4d = Transform.convertMatrix2AxisAngle(MSMLWriter.COORD.transform(matrix3d));
                if (axisAngle4d.angle != 0.0 && new Vector3d(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z).length() != 0.0) {
                    element3.setAttribute("rotation", Transform.getStringFromAxisAngle4d(axisAngle4d));
                }
                Vector3d vector3d3 = new Vector3d();
                vector3d3.x = matrix3d2.m00;
                vector3d3.y = matrix3d2.m11;
                vector3d3.z = matrix3d2.m22;
                vector3d3 = MSMLWriter.COORD.transform(vector3d3);
                vector3d3.absolute();
                if (!vector3d3.equals((Tuple3d)new Vector3d(1.0, 1.0, 1.0))) {
                    element3.setAttribute("scale", Transform.getStringFromVector3d(vector3d3));
                }
                if ((vector3d2 = ((Null)node).getTranslation()).length() != 0.0) {
                    element3.setAttribute("translation", Transform.getStringFromVector3d(MSMLWriter.COORD.transform(vector3d2)));
                }
            } else if (transform3D instanceof UniformScale) {
                float f = ((UniformScale)transform3D).getScale();
                if (f != 1.0f) {
                    element3.setAttribute("scale", Transform.getStringFromVector3f(new Vector3f(f, f, f)));
                }
            } else if (transform3D instanceof TVector3d && (vector3d = MSMLWriter.COORD.transform((Vector3d)transform3D)).length() != 0.0) {
                element3.setAttribute("translation", Transform.getStringFromVector3d(vector3d));
            }
        }
    }

    public de.grogra.graph.impl.Node export(Registry registry, Node node, de.grogra.graph.impl.Node node2, URL uRL) {
        TMatrix4d tMatrix4d;
        Node node3 = this.getSubTransformNode(node);
        Null nullVal = null;
        if (node2 == null || !(node2 instanceof Null)) {
            nullVal = new Null();
            node2 = nullVal;
        }
        if (node3 == null) {
            nullVal = (Null)node2;
            if (nullVal.getTransform() == null) {
                tMatrix4d = new TMatrix4d();
                tMatrix4d.setIdentity();
                nullVal.setTransform(tMatrix4d);
            }
        } else {
            nullVal = (Null)this.export(registry, node3, node2, uRL);
        }
        tMatrix4d = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f = new Vector3f(1.0f, 1.0f, 1.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 0.0f);
        AxisAngle4f axisAngle4f = new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f);
        AxisAngle4f axisAngle4f2 = new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f);
        if (Transform.getAttributeContent(node, "translation") != "") {
            vector3f2 = Transform.getVector3fFromString(Transform.getAttributeContent(node, "translation"));
        }
        if (Transform.getAttributeContent(node, "rotation") != "") {
            axisAngle4f = Transform.getAxisAngle4fFromString(Transform.getAttributeContent(node, "rotation"));
        }
        if (Transform.getAttributeContent(node, "scale") != "") {
            vector3f = Transform.getVector3fFromString(Transform.getAttributeContent(node, "scale"));
        }
        if (Transform.getAttributeContent(node, "scaleOrientation") != "") {
            axisAngle4f2 = Transform.getAxisAngle4fFromString(Transform.getAttributeContent(node, "scaleOrientation"));
        }
        if (Transform.getAttributeContent(node, "center") != "") {
            tMatrix4d = Transform.getVector3fFromString(Transform.getAttributeContent(node, "center"));
        }
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.set(new Vector3d(READER_COORD.transform(vector3f2)));
        matrix4d.mul(matrix4d2);
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.set(new Vector3d(READER_COORD.transform((Vector3f)tMatrix4d)));
        matrix4d.mul(matrix4d3);
        Matrix4d matrix4d4 = new Matrix4d();
        matrix4d4.set(READER_COORD.transform(axisAngle4f));
        matrix4d.mul(matrix4d4);
        Matrix4d matrix4d5 = new Matrix4d();
        matrix4d5.set(READER_COORD.transform(axisAngle4f2));
        matrix4d.mul(matrix4d5);
        vector3f = READER_COORD.transform(vector3f);
        vector3f.absolute();
        Matrix4d matrix4d6 = new Matrix4d((double)vector3f.x, 0.0, 0.0, 0.0, 0.0, (double)vector3f.y, 0.0, 0.0, 0.0, 0.0, (double)vector3f.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        matrix4d.mul(matrix4d6);
        matrix4d5.invert();
        matrix4d.mul(matrix4d5);
        matrix4d3.invert();
        matrix4d.mul(matrix4d3);
        TMatrix4d tMatrix4d2 = (TMatrix4d)nullVal.getTransform();
        tMatrix4d2.mul(matrix4d, (Matrix4d)tMatrix4d2);
        nullVal.setTransform(tMatrix4d2);
        return nullVal;
    }

    private Node getSubTransformNode(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNamespaceURI().equals("http://www.web3d.org/specifications") || !node2.getLocalName().equals("Transform")) continue;
            return node2;
        }
        return null;
    }
}

