/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Cache;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.objects.PolygonsBase;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class PolygonMesh
extends PolygonsBase {
    private static final long serialVersionUID = -4160866965967445749L;
    protected int[] indices;
    protected float[] v;
    protected float[] n;
    protected float[] t;
    protected int stamp;

    public final float[] getVertexData() {
        return this.v;
    }

    public final float[] getNormalData() {
        return this.n;
    }

    public final float[] getTextureData() {
        return this.t;
    }

    public final int[] getIndexData() {
        return this.indices;
    }

    public float[] computeMaxMin(Matrix4d matrix4d) {
        if (matrix4d == null) {
            return this.computeMaxMin();
        }
        float[] fArray = new float[6];
        boolean bl = true;
        for (int i = 0; i <= this.indices.length - 3; i += 3) {
            Point3d point3d = new Point3d((double)this.v[this.indices[i] * 3], (double)this.v[this.indices[i] * 3 + 1], (double)this.v[this.indices[i] * 3 + 2]);
            Point3d point3d2 = new Point3d((double)this.v[this.indices[i + 1] * 3], (double)this.v[this.indices[i + 1] * 3 + 1], (double)this.v[this.indices[i + 1] * 3 + 2]);
            Point3d point3d3 = new Point3d((double)this.v[this.indices[i + 2] * 3], (double)this.v[this.indices[i + 2] * 3 + 1], (double)this.v[this.indices[i + 2] * 3 + 2]);
            PolygonMesh.multiplyMatrixWithTuple3d(matrix4d, (Tuple3d)point3d);
            PolygonMesh.multiplyMatrixWithTuple3d(matrix4d, (Tuple3d)point3d2);
            PolygonMesh.multiplyMatrixWithTuple3d(matrix4d, (Tuple3d)point3d3);
            if (bl) {
                fArray[0] = (float)point3d.x;
                fArray[1] = (float)point3d.x;
                fArray[2] = (float)point3d.y;
                fArray[3] = (float)point3d.y;
                fArray[4] = (float)point3d.z;
                fArray[5] = (float)point3d.z;
                bl = false;
            }
            Point3d[] point3dArray = new Point3d[]{point3d, point3d2, point3d3};
            for (int j = 0; j < 3; ++j) {
                Point3d point3d4 = point3dArray[j];
                if (point3d4.x > (double)fArray[0]) {
                    fArray[0] = (float)point3d4.x;
                }
                if (point3d4.x < (double)fArray[1]) {
                    fArray[1] = (float)point3d4.x;
                }
                if (point3d4.y > (double)fArray[2]) {
                    fArray[2] = (float)point3d4.y;
                }
                if (point3d4.y < (double)fArray[3]) {
                    fArray[3] = (float)point3d4.y;
                }
                if (point3d4.z > (double)fArray[4]) {
                    fArray[4] = (float)point3d4.z;
                }
                if (!(point3d4.z < (double)fArray[5])) continue;
                fArray[5] = (float)point3d4.z;
            }
        }
        return fArray;
    }

    public float[] computeMaxMin() {
        float[] fArray = new float[6];
        boolean bl = true;
        int n = 0;
        for (float f : this.v) {
            if (n == 0) {
                if (bl) {
                    fArray[0] = f;
                    fArray[1] = f;
                } else {
                    if (f > fArray[0]) {
                        fArray[0] = f;
                    }
                    if (f < fArray[1]) {
                        fArray[1] = f;
                    }
                }
            }
            if (n == 1) {
                if (bl) {
                    fArray[2] = f;
                    fArray[3] = f;
                } else {
                    if (f > fArray[2]) {
                        fArray[2] = f;
                    }
                    if (f < fArray[3]) {
                        fArray[3] = f;
                    }
                }
            }
            if (n == 2) {
                if (bl) {
                    fArray[4] = f;
                    fArray[5] = f;
                    bl = false;
                } else {
                    if (f > fArray[4]) {
                        fArray[4] = f;
                    }
                    if (f < fArray[5]) {
                        fArray[5] = f;
                    }
                }
                n = -1;
            }
            ++n;
        }
        return fArray;
    }

    public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        int n2;
        int n3 = this.v.length / 3;
        polygonArray.init(3);
        polygonArray.edgeCount = 3;
        polygonArray.planar = true;
        polygonArray.closed = false;
        polygonArray.usePolygonNormals = false;
        polygonArray.userObject = null;
        polygonArray.polygons.addAll(this.indices, 0, this.indices.length);
        polygonArray.vertices.addAll(this.v, 0, this.v.length);
        if ((n & 1) != 0) {
            polygonArray.normals.clear();
            if (this.n != null) {
                for (n2 = 0; n2 < this.n.length; ++n2) {
                    polygonArray.normals.add((byte)(this.n[n2] * 127.0f));
                }
            } else {
                polygonArray.computeNormals();
            }
        }
        if ((n & 2) != 0) {
            polygonArray.uv.clear();
            if (this.t != null) {
                polygonArray.uv.addAll(this.t, 0, this.t.length);
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    polygonArray.uv.push(0.0f, 0.0f);
                }
            }
        }
    }

    public void setIndexData(IntList intList) {
        this.indices = intList.toArray();
        this.incrementStamp();
    }

    public void setVertexData(FloatList floatList) {
        this.v = floatList.toArray();
        this.incrementStamp();
    }

    public void setNormalData(float[] fArray) {
        this.n = fArray;
        this.incrementStamp();
    }

    public void setTextureData(float[] fArray) {
        this.t = fArray;
        this.incrementStamp();
    }

    public void incrementStamp() {
        ++this.stamp;
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        entry.write(System.identityHashCode(this));
        entry.write(this.getStamp());
    }

    public int getStamp() {
        return this.stamp;
    }

    public static void multiplyMatrixWithTuple3d(Matrix4d matrix4d, Tuple3d tuple3d) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = tuple3d.z;
        double d4 = 1.0;
        tuple3d.x = matrix4d.m00 * d + matrix4d.m01 * d2 + matrix4d.m02 * d3 + matrix4d.m03;
        tuple3d.y = matrix4d.m10 * d + matrix4d.m11 * d2 + matrix4d.m12 * d3 + matrix4d.m13;
        tuple3d.z = matrix4d.m20 * d + matrix4d.m21 * d2 + matrix4d.m22 * d3 + matrix4d.m23;
        d4 = matrix4d.m30 * d + matrix4d.m31 * d2 + matrix4d.m32 * d3 + matrix4d.m33;
        tuple3d.x /= d4;
        tuple3d.y /= d4;
        tuple3d.z /= d4;
    }
}

