/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.graph.Graph;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.ray.Tree;
import de.grogra.ray.RTLight;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.RTSceneVisitor;

public class GroIMPSceneGraph
implements RTScene {
    private SceneTree.Node m_root;
    private int m_stamp;
    private Graph m_graph;
    private SceneCounterVisitor m_counterVisitor = new SceneCounterVisitor();
    private ObjectsVisitor m_objectsVisitor = new ObjectsVisitor();
    private LightsVisitor m_lightsVisitor = new LightsVisitor();

    public GroIMPSceneGraph(Tree tree) {
        this.m_root = (SceneTree.Node)tree.getRoot();
        this.m_stamp = tree.getGraphState().getGraph().getStamp();
        this.m_graph = tree.getGraphState().getGraph();
        this.m_root.accept(this.m_counterVisitor);
    }

    public void traversSceneObjects(RTSceneVisitor rTSceneVisitor) {
        this.m_objectsVisitor.setVisitor(rTSceneVisitor);
        this.m_root.accept(this.m_objectsVisitor);
    }

    public void traversSceneLights(RTSceneVisitor rTSceneVisitor) {
        this.m_lightsVisitor.setVisitor(rTSceneVisitor);
        this.m_root.accept(this.m_lightsVisitor);
    }

    public int getShadeablesCount() {
        return this.m_counterVisitor.getShadeablesCount();
    }

    public int getLightsCount() {
        return this.m_counterVisitor.getLightsCount();
    }

    public int getStamp() {
        return this.m_stamp;
    }

    public Object getGraph() {
        return this.m_graph;
    }

    private class SceneCounterVisitor
    implements SceneTree.Visitor {
        private int m_shadeables = 0;
        private int m_lights = 0;

        private SceneCounterVisitor() {
        }

        public int getShadeablesCount() {
            return this.m_shadeables;
        }

        public int getLightsCount() {
            return this.m_lights;
        }

        public void visit(SceneTree.Leaf leaf) {
            if (!(leaf instanceof RTObject)) {
                return;
            }
            if (((RTObject)leaf).isShadeable()) {
                ++this.m_shadeables;
            }
            if (leaf instanceof RTLight) {
                ++this.m_lights;
            }
        }

        public void visitEnter(SceneTree.InnerNode innerNode) {
        }

        public void visitLeave(SceneTree.InnerNode innerNode) {
        }
    }

    private class LightsVisitor
    implements SceneTree.Visitor {
        private RTSceneVisitor m_visitor;

        public LightsVisitor() {
        }

        public LightsVisitor(RTSceneVisitor rTSceneVisitor) {
            this.setVisitor(rTSceneVisitor);
        }

        public void setVisitor(RTSceneVisitor rTSceneVisitor) {
            this.m_visitor = rTSceneVisitor;
        }

        public void visit(SceneTree.Leaf leaf) {
            if (leaf instanceof RTLight) {
                this.m_visitor.visitObject((RTObject)leaf);
            }
        }

        public void visitEnter(SceneTree.InnerNode innerNode) {
        }

        public void visitLeave(SceneTree.InnerNode innerNode) {
        }
    }

    private class ObjectsVisitor
    implements SceneTree.Visitor {
        private RTSceneVisitor m_visitor;

        public ObjectsVisitor() {
        }

        public ObjectsVisitor(RTSceneVisitor rTSceneVisitor) {
            this.setVisitor(rTSceneVisitor);
        }

        public void setVisitor(RTSceneVisitor rTSceneVisitor) {
            this.m_visitor = rTSceneVisitor;
        }

        public void visit(SceneTree.Leaf leaf) {
            if (leaf instanceof RTObject) {
                this.m_visitor.visitObject((RTObject)leaf);
            }
        }

        public void visitEnter(SceneTree.InnerNode innerNode) {
        }

        public void visitLeave(SceneTree.InnerNode innerNode) {
        }
    }
}

