/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.ray.RTObject;
import de.grogra.ray.intersection.BoundingBox;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RTParallelogram
extends RaytracerLeaf
implements RTObject {
    private Intersections.ParallelogramInput m_parallelogramInput = new Intersections.ParallelogramInput();
    private Intersections.ObjectOutput m_parallelogramOutput = new Intersections.ObjectOutput();
    private Intersections.ParallelogramLocalVariables m_parallelogramLocalVariables = new Intersections.ParallelogramLocalVariables();
    private final Vector3f m_vec1 = new Vector3f();
    private final Vector3f m_vec2 = new Vector3f();
    private final Vector3f m_vec3 = new Vector3f();
    private final Matrix4f m_axisTransform = new Matrix4f();
    private boolean m_shadeable = true;
    private BoundingBox m_boundingVolume = null;

    public RTParallelogram(Object object, boolean bl, long l, Vector3f vector3f, Vector3f vector3f2) {
        super(object, bl, l);
        this.m_vec1.set((Tuple3f)vector3f);
        this.m_vec2.set((Tuple3f)vector3f2);
        this.m_vec3.cross(this.m_vec1, this.m_vec2);
        this.m_axisTransform.setIdentity();
        this.m_axisTransform.m00 = this.m_vec1.x;
        this.m_axisTransform.m10 = this.m_vec1.y;
        this.m_axisTransform.m20 = this.m_vec1.z;
        this.m_axisTransform.m01 = this.m_vec2.x;
        this.m_axisTransform.m11 = this.m_vec2.y;
        this.m_axisTransform.m21 = this.m_vec2.z;
        this.m_axisTransform.m02 = this.m_vec3.x;
        this.m_axisTransform.m12 = this.m_vec3.y;
        this.m_axisTransform.m22 = this.m_vec3.z;
        this.m_parallelogramInput.tangenteU.set((Tuple3f)this.m_vec1);
        this.m_parallelogramInput.tangenteV.set((Tuple3f)this.m_vec2);
        this.m_parallelogramInput.normal.set((Tuple3f)this.m_vec3);
    }

    public boolean isConvex() {
        return false;
    }

    public boolean isShadeable() {
        return this.m_shadeable;
    }

    public boolean isSolid() {
        return false;
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        matrix4f.transform(this.m_parallelogramInput.normal);
        matrix4f.transform(this.m_parallelogramInput.tangenteU);
        matrix4f.transform(this.m_parallelogramInput.tangenteV);
        this.m_parallelogramInput.normal.normalize();
        this.m_parallelogramInput.tangenteU.normalize();
        this.m_parallelogramInput.tangenteV.normalize();
        this.m_parallelogramInput.transformation.mul(matrix4f, this.m_axisTransform);
        this.m_parallelogramInput.invers_transformation.invert(this.m_parallelogramInput.transformation);
        this.setShader(this.shader);
        this.m_parallelogramInput.transparencyShader = (this.shader.getFlags() & 0x20) != 0 ? this.getRTShader() : null;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        this.m_parallelogramInput.ray.setRay(ray);
        Intersections.getParallelogram_T((Intersections.ParallelogramInput)this.m_parallelogramInput, (Intersections.ObjectOutput)this.m_parallelogramOutput, (Intersections.ParallelogramLocalVariables)this.m_parallelogramLocalVariables);
        if (!this.m_parallelogramOutput.hasIntersection) {
            return Float.NaN;
        }
        return this.m_parallelogramOutput.t;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
        Intersections.getParallelogram_IntersectionDescription((Intersections.ParallelogramInput)this.m_parallelogramInput, (int)this.shader.getFlags(), (IntersectionDescription)intersectionDescription, (Intersections.ParallelogramLocalVariables)this.m_parallelogramLocalVariables);
        intersectionDescription.setRTObject((RTObject)this);
    }

    public BoundingVolume getBoundingVolume() {
        if (this.m_boundingVolume == null) {
            Point3f[] point3fArray = new Point3f[4];
            Vector3f vector3f = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vector3f vector3f2 = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            point3fArray[0] = new Point3f(1.0f, 1.0f, 0.0f);
            point3fArray[1] = new Point3f(0.0f, 1.0f, 0.0f);
            point3fArray[2] = new Point3f(0.0f, -1.0f, 0.0f);
            point3fArray[3] = new Point3f(1.0f, -1.0f, 0.0f);
            for (int i = 0; i < 4; ++i) {
                this.m_parallelogramInput.transformation.transform(point3fArray[i]);
                if (point3fArray[i].x < vector3f.x) {
                    vector3f.x = point3fArray[i].x;
                }
                if (point3fArray[i].y < vector3f.y) {
                    vector3f.y = point3fArray[i].y;
                }
                if (point3fArray[i].z < vector3f.z) {
                    vector3f.z = point3fArray[i].z;
                }
                if (point3fArray[i].x > vector3f2.x) {
                    vector3f2.x = point3fArray[i].x;
                }
                if (point3fArray[i].y > vector3f2.y) {
                    vector3f2.y = point3fArray[i].y;
                }
                if (!(point3fArray[i].z > vector3f2.z)) continue;
                vector3f2.z = point3fArray[i].z;
            }
            float f = 0.01f;
            vector3f.x -= f;
            vector3f.y -= f;
            vector3f.z -= f;
            vector3f2.x += f;
            vector3f2.y += f;
            vector3f2.z += f;
            this.m_boundingVolume = new BoundingBox(vector3f, vector3f2);
        }
        return this.m_boundingVolume;
    }
}

