/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.GroIMPShader;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.ray.RTLight;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.light.NoShadows;
import de.grogra.ray.light.ShadowProcessor;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.shader.RTMedium;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import de.grogra.ray.util.RayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

public class RTPointLight
extends RaytracerLeaf
implements RTLight {
    private Light m_light = null;
    private boolean m_isShadowless = true;
    private ShadowProcessor m_noShadows = new NoShadows();
    private final Ray m_tmpRay1 = new Ray();
    private Ray m_tmpRay2 = null;
    private float m_rayLength;
    private final Point3f m_point = new Point3f();
    private ShadingEnvironment env;
    private final MTRandom rnd = new MTRandom();
    private final Spectrum3f spectrum = new Spectrum3f();

    public RTPointLight(Object object, boolean bl, long l, Light light) {
        super(object, bl, l);
        this.m_light = light;
        this.m_isShadowless = this.m_light.isShadowless();
    }

    public boolean isConvex() {
        return false;
    }

    public RTMedium getMedium() {
        return null;
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        this.m_point.set(matrix4f.m03, matrix4f.m13, matrix4f.m23);
        this.env = new ShadingEnvironment();
        this.env.localToGlobal = new Matrix4f(matrix4f);
        RayList rayList = new RayList();
        rayList.setSize(1);
        this.m_light.generateRandomOrigins((Environment)this.env, rayList, (Random)this.rnd);
        this.env.globalToLocal = new Matrix4f(matrix4f);
        this.env.globalToLocal.invert();
        Spectrum3f spectrum3f = new Spectrum3f();
        Vector3f vector3f = new Vector3f(100.0f, 100.0f, 100.0f);
        vector3f.normalize();
        float f = this.m_light.computeBSDF((Environment)this.env, null, (Spectrum)GroIMPShader.ID, vector3f, false, (Spectrum)spectrum3f);
        this.m_tmpRay1.getColor().set((Tuple3f)rayList.rays[0].color);
        this.m_tmpRay1.getColor().scale(f);
    }

    public boolean isShadowless() {
        return this.m_isShadowless;
    }

    public boolean isShadeable() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public int getLightRays(Ray ray, IntersectionDescription intersectionDescription, ShadowProcessor shadowProcessor, RayList rayList) {
        ShadowProcessor shadowProcessor2 = this.m_isShadowless ? this.m_noShadows : shadowProcessor;
        this.m_tmpRay1.getOrigin().set((Tuple3f)this.m_point);
        this.m_tmpRay1.getDirection().set(intersectionDescription.getPoint().x - this.m_point.x, intersectionDescription.getPoint().y - this.m_point.y, intersectionDescription.getPoint().z - this.m_point.z);
        this.m_tmpRay1.getDirection().normalize();
        this.m_rayLength = Raytracer.getT((Ray)this.m_tmpRay1, (Point3f)intersectionDescription.getPoint());
        if (!shadowProcessor2.shadowRay(this.m_tmpRay1, this.m_rayLength, ray, intersectionDescription)) {
            this.m_tmpRay2 = rayList.nextRay();
            this.m_tmpRay2.getDirection().set(-this.m_tmpRay1.getDirection().x, -this.m_tmpRay1.getDirection().y, -this.m_tmpRay1.getDirection().z);
            this.m_tmpRay2.getOrigin().set((Tuple3f)intersectionDescription.getPoint());
            this.m_tmpRay2.getColor().set((Tuple3f)this.m_tmpRay1.getColor());
            return 1;
        }
        return 0;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        return 0.0f;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
    }

    public BoundingVolume getBoundingVolume() {
        return null;
    }

    public void generateRandomOrigins(RayList rayList, int n) {
        this.m_light.generateRandomOrigins((Environment)this.env, rayList, (Random)this.rnd);
    }

    public void generateRandomRays(Vector3f vector3f, RayList rayList, boolean bl, int n) {
        this.m_light.generateRandomRays((Environment)this.env, vector3f, (Spectrum)GroIMPShader.ID, rayList, bl, (Random)this.rnd);
    }

    public float computeBSDF(ShadingEnvironment shadingEnvironment, Vector3f vector3f, Vector3f vector3f2, boolean bl, Color3f color3f) {
        float f = this.m_light.computeBSDF((Environment)shadingEnvironment, vector3f, (Spectrum)GroIMPShader.ID, vector3f2, bl, (Spectrum)this.spectrum);
        this.spectrum.get((Tuple3f)color3f);
        return f;
    }

    public Point3f getGlobalOrigin() {
        return this.m_point;
    }
}

