/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.ray.RTObject;
import de.grogra.ray.debug3d.ExportableToVRML;
import de.grogra.ray.intersection.BoundingBox;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.shader.RTMedium;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import java.io.BufferedWriter;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class RTSphere
extends RaytracerLeaf
implements RTObject,
ExportableToVRML {
    private Intersections.SphereInput m_sphereInput = new Intersections.SphereInput();
    private Intersections.ObjectOutput m_sphereOutput = new Intersections.ObjectOutput();
    private Intersections.SphereLocalVariables m_sphereLocalVariables = new Intersections.SphereLocalVariables();
    private BoundingVolume m_boundingVolume = null;

    public RTSphere(Object object, boolean bl, long l, float f) {
        super(object, bl, l);
        this.setRadius(f);
    }

    public RTMedium getMedium() {
        return this.getRTMedium();
    }

    public boolean isConvex() {
        return true;
    }

    public boolean isShadeable() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public float getRadius() {
        return this.m_sphereInput.radius;
    }

    public void setRadius(double d) {
        this.m_sphereInput.radius = (float)d;
        this.m_sphereInput.squareRadius = (float)(d * d);
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        this.m_sphereInput.transformation.set(matrix4f);
        this.m_sphereInput.invers_transformation.invert(matrix4f);
        this.setShader(this.shader);
        if (this.interior != null) {
            this.setMedium(this.interior);
        }
        this.m_boundingVolume = null;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        this.m_sphereInput.ray.setRay(ray);
        this.m_sphereInput.minIndex = this.getUserData().isInside ? 1 : 0;
        Intersections.getSphere_T((Intersections.SphereInput)this.m_sphereInput, (Intersections.ObjectOutput)this.m_sphereOutput, (Intersections.SphereLocalVariables)this.m_sphereLocalVariables);
        if (!this.m_sphereOutput.hasIntersection) {
            return Float.NaN;
        }
        return this.m_sphereOutput.t;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
        Intersections.getSphere_IntersectionDescription((Intersections.SphereInput)this.m_sphereInput, (int)this.shader.getFlags(), (IntersectionDescription)intersectionDescription, (Intersections.SphereLocalVariables)this.m_sphereLocalVariables);
        intersectionDescription.setRTObject((RTObject)this);
    }

    public BoundingVolume getBoundingVolume() {
        if (this.m_boundingVolume == null) {
            Point3f[] point3fArray = new Point3f[8];
            Vector3f vector3f = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vector3f vector3f2 = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            float f = this.m_sphereInput.radius + 0.001f;
            point3fArray[0] = new Point3f(f, f, f);
            point3fArray[1] = new Point3f(-f, f, f);
            point3fArray[2] = new Point3f(-f, -f, f);
            point3fArray[3] = new Point3f(f, -f, f);
            point3fArray[4] = new Point3f(f, f, -f);
            point3fArray[5] = new Point3f(-f, f, -f);
            point3fArray[6] = new Point3f(-f, -f, -f);
            point3fArray[7] = new Point3f(f, -f, -f);
            for (int i = 0; i < 8; ++i) {
                this.m_sphereInput.transformation.transform(point3fArray[i]);
                if (point3fArray[i].x < vector3f.x) {
                    vector3f.x = point3fArray[i].x;
                }
                if (point3fArray[i].y < vector3f.y) {
                    vector3f.y = point3fArray[i].y;
                }
                if (point3fArray[i].z < vector3f.z) {
                    vector3f.z = point3fArray[i].z;
                }
                if (point3fArray[i].x > vector3f2.x) {
                    vector3f2.x = point3fArray[i].x;
                }
                if (point3fArray[i].y > vector3f2.y) {
                    vector3f2.y = point3fArray[i].y;
                }
                if (!(point3fArray[i].z > vector3f2.z)) continue;
                vector3f2.z = point3fArray[i].z;
            }
            this.m_boundingVolume = new BoundingBox(vector3f, vector3f2);
        }
        return this.m_boundingVolume;
    }

    public void exportToVRML(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("  Transform {");
            bufferedWriter.newLine();
            bufferedWriter.write("    children [");
            bufferedWriter.newLine();
            bufferedWriter.write("      Shape {");
            bufferedWriter.newLine();
            bufferedWriter.write("        appearance Appearance {");
            bufferedWriter.newLine();
            bufferedWriter.write("          material Material {");
            bufferedWriter.newLine();
            bufferedWriter.write("            transparency 0.5");
            bufferedWriter.newLine();
            bufferedWriter.write("          }");
            bufferedWriter.newLine();
            bufferedWriter.write("        }");
            bufferedWriter.newLine();
            bufferedWriter.write("        geometry Sphere {");
            bufferedWriter.newLine();
            bufferedWriter.write("          radius " + this.m_sphereInput.radius);
            bufferedWriter.newLine();
            bufferedWriter.write("        }");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("    ]");
            bufferedWriter.newLine();
            bufferedWriter.write("    translation " + this.m_sphereInput.transformation.m03 + " " + this.m_sphereInput.transformation.m13 + " " + this.m_sphereInput.transformation.m23);
            bufferedWriter.newLine();
            bufferedWriter.write("  }");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

