/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.UVTransformation;
import de.grogra.math.ChannelData;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Transaction;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3f;

public class AffineUVTransformation
extends UVTransformation {
    float offsetU;
    float offsetV;
    float scaleU = 1.0f;
    float scaleV = 1.0f;
    float angle;
    float shear;
    private transient boolean transformValid = false;
    private transient Matrix3f transform = new Matrix3f();
    private transient Matrix3f invTransform = new Matrix3f();
    public static final Node.NType $TYPE = new Node.NType((Node)new AffineUVTransformation());
    public static final Node.NType.Field offsetU$FIELD = new _Field("offsetU", 0x200000, Type.FLOAT, null, 0);
    public static final Node.NType.Field offsetV$FIELD;
    public static final Node.NType.Field scaleU$FIELD;
    public static final Node.NType.Field scaleV$FIELD;
    public static final Node.NType.Field angle$FIELD;
    public static final Node.NType.Field shear$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new AffineUVTransformation();
    }

    public float getOffsetU() {
        return this.offsetU;
    }

    public void setOffsetU(float f) {
        this.offsetU = f;
    }

    public float getOffsetV() {
        return this.offsetV;
    }

    public void setOffsetV(float f) {
        this.offsetV = f;
    }

    public float getScaleU() {
        return this.scaleU;
    }

    public void setScaleU(float f) {
        this.scaleU = f;
    }

    public float getScaleV() {
        return this.scaleV;
    }

    public void setScaleV(float f) {
        this.scaleV = f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public float getShear() {
        return this.shear;
    }

    public void setShear(float f) {
        this.shear = f;
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        super.fieldModified(persistenceField, nArray, transaction);
        this.transformValid = false;
    }

    private void constructTransformMatrix() {
        Matrix3f matrix3f = this.transform;
        Matrix3f matrix3f2 = this.invTransform;
        if (!this.transformValid) {
            this.transformValid = true;
            matrix3f.setIdentity();
            matrix3f.m02 = -this.offsetU;
            matrix3f.m12 = -this.offsetV;
            matrix3f2.rotZ(-this.angle);
            matrix3f2.mul(matrix3f);
            matrix3f.m00 = this.scaleU;
            matrix3f.m11 = this.scaleV;
            matrix3f.m01 = -this.shear * this.scaleV;
            matrix3f.m02 = 0.0f;
            matrix3f.m12 = 0.0f;
            matrix3f.mul(matrix3f2);
            Math2.invertAffine((Matrix3f)matrix3f, (Matrix3f)matrix3f2);
        }
    }

    public Matrix3f getTransform() {
        this.constructTransformMatrix();
        return this.transform;
    }

    public Matrix3f getInvTransform() {
        this.constructTransformMatrix();
        return this.invTransform;
    }

    protected void transform(ChannelData channelData, ChannelData channelData2, boolean bl) {
        Matrix3f matrix3f = this.getTransform();
        Matrix3f matrix3f2 = this.getInvTransform();
        float f = channelData.getFloatValue(channelData2, 16);
        float f2 = channelData.getFloatValue(channelData2, 17);
        channelData2.setFloat(16, matrix3f.m00 * f + matrix3f.m01 * f2 + matrix3f.m02);
        channelData2.setFloat(17, matrix3f.m10 * f + matrix3f.m11 * f2 + matrix3f.m12);
        if (bl) {
            AffineUVTransformation.setDerivatives(matrix3f2.m00, matrix3f2.m01, matrix3f2.m10, matrix3f2.m11, channelData, channelData2);
        }
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)offsetU$FIELD);
        offsetV$FIELD = new _Field("offsetV", 0x200000, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)offsetV$FIELD);
        scaleU$FIELD = new _Field("scaleU", 0x200000, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)scaleU$FIELD);
        scaleV$FIELD = new _Field("scaleV", 0x200000, Type.FLOAT, null, 3);
        $TYPE.addManagedField((ManageableType.Field)scaleV$FIELD);
        angle$FIELD = new _Field("angle", 0x200000, Type.FLOAT, null, 4);
        $TYPE.addManagedField((ManageableType.Field)angle$FIELD);
        shear$FIELD = new _Field("shear", 0x200000, Type.FLOAT, null, 5);
        $TYPE.addManagedField((ManageableType.Field)shear$FIELD);
        angle$FIELD.setQuantity(Quantity.ANGLE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((AffineUVTransformation)((Object)object)).offsetU = f;
                    return;
                }
                case 1: {
                    ((AffineUVTransformation)((Object)object)).offsetV = f;
                    return;
                }
                case 2: {
                    ((AffineUVTransformation)((Object)object)).scaleU = f;
                    return;
                }
                case 3: {
                    ((AffineUVTransformation)((Object)object)).scaleV = f;
                    return;
                }
                case 4: {
                    ((AffineUVTransformation)((Object)object)).angle = f;
                    return;
                }
                case 5: {
                    ((AffineUVTransformation)((Object)object)).shear = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((AffineUVTransformation)((Object)object)).getOffsetU();
                }
                case 1: {
                    return ((AffineUVTransformation)((Object)object)).getOffsetV();
                }
                case 2: {
                    return ((AffineUVTransformation)((Object)object)).getScaleU();
                }
                case 3: {
                    return ((AffineUVTransformation)((Object)object)).getScaleV();
                }
                case 4: {
                    return ((AffineUVTransformation)((Object)object)).getAngle();
                }
                case 5: {
                    return ((AffineUVTransformation)((Object)object)).getShear();
                }
            }
            return super.getFloat(object);
        }
    }
}

