/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import de.grogra.imp3d.shading.ChannelMapNode;
import de.grogra.math.ChannelData;
import de.grogra.math.ColorMap;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.RenderedIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class ColorMapNode
extends ChannelMapNode
implements ColorMap,
IconSource,
RenderedIcon {
    private static final int DEFAULT_ICON_SIZE = 64;
    private static final Dimension DEFAULT_DIMENSION = new Dimension(64, 64);
    private final transient BufferedImage iconImage = new BufferedImage(64, 64, 2);
    private transient int imageStamp = -1;
    public static final Node.NType $TYPE = new Node.NType(ColorMapNode.class);

    public Icon getIcon(Dimension dimension, int n) {
        return this;
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return DEFAULT_DIMENSION;
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.drawImage(this.getImage(), n, n2, n3, n4, null);
    }

    protected ChannelData getInputData(ChannelData channelData) {
        return channelData.getData(channelData.getProperty("ignoreInput") == Boolean.TRUE ? null : this.input);
    }

    public void drawImage(BufferedImage bufferedImage, int n, boolean bl) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            this.renderLine(bufferedImage, n, i, bl, hashMap);
        }
    }

    protected abstract void renderLine(BufferedImage var1, int var2, int var3, boolean var4, Map var5);

    public IconSource getIconSource() {
        return this;
    }

    public boolean isMutable() {
        return true;
    }

    public void prepareIcon() {
        this.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        int n = this.getStamp();
        BufferedImage bufferedImage = this.iconImage;
        synchronized (bufferedImage) {
            if (n != this.imageStamp) {
                this.drawImage(this.iconImage, 2, true);
                this.imageStamp = n;
            }
        }
        return this.iconImage;
    }

    public float getSizeRatio() {
        return 1.0f;
    }

    public int renderImage(JobManager jobManager, BufferedImage bufferedImage, int n) {
        HashMap hashMap = new HashMap();
        long l = System.currentTimeMillis() + 500L;
        do {
            for (int i = 3; i > 0; --i) {
                if (n == bufferedImage.getHeight()) {
                    return n;
                }
                this.renderLine(bufferedImage, 2, n, true, hashMap);
                if (++n != bufferedImage.getHeight()) continue;
                return n;
            }
        } while (System.currentTimeMillis() < l && !jobManager.hasJobQueued(jobManager.getThreadContext().getPriority() + 1));
        return n;
    }

    public BufferedImage getRenderedImage() {
        return this.iconImage;
    }

    public Image getImage(int n, int n2) {
        return null;
    }

    public URL getImageSource() {
        return null;
    }

    public Rectangle getIconBounds() {
        return null;
    }

    static {
        $TYPE.validate();
    }
}

