/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.SurfaceMap;
import de.grogra.math.ChannelData;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;

public abstract class SyntheticTexture
extends SurfaceMap {
    int width = 256;
    int height = 256;
    float[] image = new float[0];
    private transient int imageStamp = -1;
    public static final Node.NType $TYPE = new Node.NType(SyntheticTexture.class);
    public static final Node.NType.Field width$FIELD = new _Field("width", 0x200000, Type.INT, null, 0);
    public static final Node.NType.Field height$FIELD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getFloatData() {
        int n = this.getStamp();
        SyntheticTexture syntheticTexture = this;
        synchronized (syntheticTexture) {
            if (n != this.imageStamp) {
                this.createImage();
                this.imageStamp = n;
            }
        }
        return this.image;
    }

    public int getAverageColor() {
        return 0;
    }

    protected void createImage() {
        if (this.image == null || this.image.length < this.width * this.height) {
            this.image = new float[this.width * this.height];
        }
        assert (this.image.length >= this.width * this.height);
        this.calculateImageData();
    }

    private int ensureRange(int n, int n2, int n3) {
        int n4 = n3 - n2;
        while (n < n2) {
            n += n4;
        }
        while (n >= n3) {
            n -= n4;
        }
        return n;
    }

    protected float getPixel(int n, int n2) {
        n = this.ensureRange(n, 0, this.width);
        n2 = this.ensureRange(n2, 0, this.height);
        return this.image[n2 * this.width + n];
    }

    protected void setPixel(int n, int n2, float f) {
        n = this.ensureRange(n, 0, this.width);
        n2 = this.ensureRange(n2, 0, this.height);
        this.image[n2 * this.width + n] = f;
    }

    protected abstract void calculateImageData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getFloatValueImpl(float f, float f2, ChannelData channelData, int n) {
        float f3 = 1.0f;
        if ((n & 3) != 3) {
            int n2 = this.getStamp();
            SyntheticTexture syntheticTexture = this;
            synchronized (syntheticTexture) {
                if (n2 != this.imageStamp) {
                    this.createImage();
                    this.imageStamp = n2;
                }
            }
            float f4 = f * (float)this.width;
            float f5 = f2 * (float)this.height;
            int n3 = (int)f4;
            int n4 = n3 + 1;
            int n5 = (int)f5;
            int n6 = n5 + 1;
            float f6 = ((float)n4 - f4) / ((float)n4 - (float)n3);
            float f7 = (f4 - (float)n3) / ((float)n4 - (float)n3);
            float f8 = ((float)n6 - f5) / ((float)n6 - (float)n5);
            float f9 = (f5 - (float)n5) / ((float)n6 - (float)n5);
            float f10 = this.getPixel(n3, n5);
            float f11 = this.getPixel(n4, n5);
            float f12 = this.getPixel(n3, n6);
            float f13 = this.getPixel(n4, n6);
            f3 = f10 * f8 * f6 + f11 * f8 * f7 + f12 * f9 * f6 + f13 * f9 * f7;
        }
        return f3;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)width$FIELD);
        height$FIELD = new _Field("height", 0x200000, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)height$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 0: {
                    ((SyntheticTexture)((Object)object)).width = n;
                    return;
                }
                case 1: {
                    ((SyntheticTexture)((Object)object)).height = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 0: {
                    return ((SyntheticTexture)((Object)object)).getWidth();
                }
                case 1: {
                    return ((SyntheticTexture)((Object)object)).getHeight();
                }
            }
            return super.getInt(object);
        }
    }
}

