/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;

public class Concat
extends AbstractTool {
    public Concat() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile1", "The first PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "srcfile2", "The second PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the concatenated PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Concatenate 2 PDF files", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Concat OPENED ===");
    }

    public void execute() {
        try {
            String[] stringArray = new String[2];
            if (this.getValue("srcfile1") == null) {
                throw new InstantiationException("You need to choose a first sourcefile");
            }
            stringArray[0] = ((File)this.getValue("srcfile1")).getAbsolutePath();
            if (this.getValue("srcfile2") == null) {
                throw new InstantiationException("You need to choose a second sourcefile");
            }
            stringArray[1] = ((File)this.getValue("srcfile2")).getAbsolutePath();
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file = (File)this.getValue("destfile");
            int n = 0;
            ArrayList arrayList = new ArrayList();
            Document document = null;
            PdfCopy pdfCopy = null;
            for (int i = 0; i < 2; ++i) {
                PdfReader pdfReader = new PdfReader(stringArray[i]);
                pdfReader.consolidateNamedDestinations();
                int n2 = pdfReader.getNumberOfPages();
                List list = SimpleBookmark.getBookmark(pdfReader);
                if (list != null) {
                    if (n != 0) {
                        SimpleBookmark.shiftPageNumbers(list, n, null);
                    }
                    arrayList.addAll(list);
                }
                n += n2;
                System.out.println("There are " + n2 + " pages in " + stringArray[i]);
                if (i == 0) {
                    document = new Document(pdfReader.getPageSizeWithRotation(1));
                    pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(file));
                    document.open();
                }
                int n3 = 0;
                while (n3 < n2) {
                    PdfImportedPage pdfImportedPage = pdfCopy.getImportedPage(pdfReader, ++n3);
                    pdfCopy.addPage(pdfImportedPage);
                    System.out.println("Processed page " + n3);
                }
            }
            if (arrayList.size() > 0) {
                pdfCopy.setOutlines(arrayList);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Concat concat = new Concat();
        if (stringArray.length < 2) {
            System.err.println(concat.getUsage());
        }
        concat.setArguments(stringArray);
        concat.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Concat.addVersion("$Id: Concat.java,v 1.7 2005/11/29 21:05:02 blowagie Exp $");
    }
}

