/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.math.DataTable;
import de.grogra.pf.data.Datacell;
import de.grogra.pf.data.Dataset;
import de.grogra.xl.lang.ObjectToDouble;
import de.grogra.xl.lang.ObjectToObject;
import de.grogra.xl.util.DoubleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Newton {
    public static void findRoot(ObjectToObject<double[], double[]> objectToObject, double[] dArray, double[] dArray2, int n, double[] dArray3, double d) {
        boolean bl;
        int n2 = dArray.length;
        double[][] dArray4 = new double[n2][n2];
        int n3 = 0;
        do {
            double d2;
            int n4;
            if (++n3 > n) {
                throw new ArithmeticException("Maximal number of steps exceeded.");
            }
            double[] dArray5 = (double[])objectToObject.evaluateObject((Object)dArray);
            for (n4 = 0; n4 < n2; ++n4) {
                d2 = dArray[n4];
                int n5 = n4;
                dArray[n5] = dArray[n5] + dArray3[n4];
                double[] dArray6 = (double[])objectToObject.evaluateObject((Object)dArray);
                for (int i = 0; i < n2; ++i) {
                    dArray4[i][n4] = (dArray6[i] - dArray5[i]) / dArray3[n4];
                }
                dArray[n4] = d2;
            }
            Newton.invMul(dArray4, dArray5);
            bl = true;
            n4 = 0;
            while (n4 < n2) {
                d2 = dArray5[n4];
                if (Math.abs(d2) > dArray2[n4]) {
                    bl = false;
                }
                int n6 = n4++;
                dArray[n6] = dArray[n6] - d * d2;
            }
        } while (!bl);
    }

    public static void findExtremum(final ObjectToDouble<double[]> objectToDouble, double[] dArray, double[] dArray2, int n, final double[] dArray3, double d) {
        final int n2 = dArray.length;
        ObjectToObject<double[], double[]> objectToObject = new ObjectToObject<double[], double[]>(){

            public double[] evaluateObject(double[] dArray) {
                double[] dArray2 = new double[n2];
                double d = objectToDouble.evaluateDouble((Object)dArray);
                for (int i = 0; i < n2; ++i) {
                    double d2 = dArray[i];
                    int n = i;
                    dArray[n] = dArray[n] + dArray3[i];
                    double d3 = objectToDouble.evaluateDouble((Object)dArray);
                    dArray2[i] = (d3 - d) / dArray3[i];
                    dArray[i] = d2;
                }
                return dArray2;
            }
        };
        Newton.findRoot(objectToObject, dArray, dArray2, n, dArray3, d);
    }

    public static void fit(final ObjectToDouble<double[][]> objectToDouble, final DataTable dataTable, double[] dArray, double[] dArray2, int n, double[] dArray3, double d) {
        ObjectToDouble<double[]> objectToDouble2 = new ObjectToDouble<double[]>(){
            final int rows;
            final int n;
            final double[] x;
            final double[][] xp;
            {
                this.rows = dataTable.getRowCount();
                this.n = dataTable.getColumnCount() - 1;
                this.x = new double[this.n];
                this.xp = new double[][]{this.x, null};
            }

            public double evaluateDouble(double[] dArray) {
                double d = 0.0;
                this.xp[1] = dArray;
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.n; ++j) {
                        this.x[j] = dataTable.getValue(i, j);
                    }
                    double d2 = objectToDouble.evaluateDouble((Object)this.xp) - dataTable.getValue(i, this.n);
                    d += d2 * d2;
                }
                return d;
            }
        };
        Newton.findExtremum(objectToDouble2, dArray, dArray2, n, dArray3, d);
    }

    public static void fit(ObjectToDouble<double[][]> objectToDouble, DataTable dataTable, double[] dArray, double[] dArray2) {
        Newton.fit(objectToDouble, dataTable, dArray, dArray2, 100, dArray2, 0.3);
    }

    public static void fitParameters(final ObjectToDouble<double[]> objectToDouble, DataTable dataTable, final double[] dArray, double[] dArray2, int n, double[] dArray3, double d) {
        ObjectToDouble<double[][]> objectToDouble2 = new ObjectToDouble<double[][]>(){

            public double evaluateDouble(double[][] dArray2) {
                if (dArray2[1] != dArray) {
                    DoubleList.arraycopy((double[])dArray2[1], (int)0, (double[])dArray, (int)0, (int)dArray2[1].length);
                }
                return objectToDouble.evaluateDouble((Object)dArray2[0]);
            }
        };
        Newton.fit(objectToDouble2, dataTable, dArray, dArray2, n, dArray3, d);
    }

    public static void fitParameters(ObjectToDouble<double[]> objectToDouble, DataTable dataTable, double[] dArray, double[] dArray2) {
        Newton.fitParameters(objectToDouble, dataTable, dArray, dArray2, 100, dArray2, 0.3);
    }

    public static DataTable toDataTable(final Dataset dataset) {
        return new DataTable(){
            final int[] colStart;
            final int rowCount;
            {
                if (this.getRowCount0() > 0 && this.getColumnCount0() > 1 && !this.getCell0(0, 0).isScalar()) {
                    int n = this.getColumnCount0() - 1;
                    this.colStart = new int[n + 1];
                    for (int i = 0; i < n; ++i) {
                        this.colStart[i + 1] = this.colStart[i] + this.getRowCount0(i);
                    }
                    this.rowCount = this.colStart[n] + this.getRowCount0(n);
                } else {
                    this.colStart = null;
                    this.rowCount = 0;
                }
            }

            private int getColumnCount0() {
                return dataset.hasSeriesInRows() ? dataset.getRowCount() : dataset.getColumnCount();
            }

            private int getRowCount0() {
                return dataset.hasSeriesInRows() ? dataset.getColumnCount() : dataset.getRowCount();
            }

            private int getRowCount0(int n) {
                return dataset.hasSeriesInRows() ? dataset.getColumnCount(n) : dataset.getRowCount(n);
            }

            private Datacell getCell0(int n, int n2) {
                return dataset.hasSeriesInRows() ? dataset.getCell(n2, n) : dataset.getCell(n, n2);
            }

            public int getColumnCount() {
                if (this.colStart != null) {
                    return 2;
                }
                int n = this.getColumnCount0();
                return n == 1 ? 2 : n;
            }

            public int getRowCount() {
                return this.colStart != null ? this.rowCount : this.getRowCount0();
            }

            public double getValue(int n, int n2) {
                Datacell datacell;
                if (this.colStart != null) {
                    datacell = null;
                    for (int i = this.colStart.length - 1; i >= 0; --i) {
                        if (n < this.colStart[i]) continue;
                        datacell = this.getCell0(n - this.colStart[i], i);
                        break;
                    }
                } else {
                    if (this.getColumnCount0() > 1) {
                        return this.getCell0(n, n2).getY();
                    }
                    datacell = this.getCell0(n, 0);
                }
                return n2 == 0 ? datacell.getX() : datacell.getY();
            }
        };
    }

    private static void invMul(double[][] dArray, double[] dArray2) {
        double d;
        int n;
        int n2;
        int n3 = dArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = -1;
            double d2 = 0.0;
            for (n = n2; n < n3; ++n) {
                d = Math.abs(dArray[n][n2]);
                if (!(d > d2)) continue;
                n4 = n;
                d2 = d;
            }
            if (n4 < 0) {
                throw new ArithmeticException();
            }
            if (n4 != n2) {
                d = dArray2[n2];
                dArray2[n2] = dArray2[n4];
                dArray2[n4] = d;
                for (n = n2; n < n3; ++n) {
                    d = dArray[n2][n];
                    dArray[n2][n] = dArray[n4][n];
                    dArray[n4][n] = d;
                }
            }
            d = 1.0 / dArray[n2][n2];
            n = n2 + 1;
            while (n < n3) {
                double d3 = dArray[n][n2] * d;
                dArray[n][n2] = 0.0;
                for (n4 = n2 + 1; n4 < n3; ++n4) {
                    double[] dArray3 = dArray[n];
                    int n5 = n4;
                    dArray3[n5] = dArray3[n5] - d3 * dArray[n2][n4];
                }
                int n6 = n++;
                dArray2[n6] = dArray2[n6] - d3 * dArray2[n2];
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray2[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= dArray[n2][n] * dArray2[n];
            }
            dArray2[n2] = d / dArray[n2][n2];
        }
    }
}

