/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.math.BSpline;
import de.grogra.math.KnotVector;
import de.grogra.math.Tuple2fType;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.reflect.ClassAdapter;
import de.grogra.xl.lang.FloatToFloat;
import de.grogra.xl.util.FloatList;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;

public class SplineFunction
extends ShareableBase
implements KnotVector,
FloatToFloat {
    public static final int B_SPLINE = 0;
    public static final int CUBIC = 1;
    public static final int HERMITE = 2;
    Point2f[] data;
    int type;
    private transient float[] coeffC;
    private transient int coeffCStamp = -1;
    private final transient float[] bf = new float[16];
    private final transient float[] left = new float[4];
    private final transient float[] right = new float[4];
    private final transient float[] ndu = new float[16];
    public static final Type $TYPE = new Type(SplineFunction.class);
    public static final SCOType.Field data$FIELD = Type._addManagedField($TYPE, "data", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Point2f[].class), (de.grogra.reflect.Type)Tuple2fType.POINT, 0);
    public static final SCOType.Field type$FIELD = Type._addManagedField($TYPE, "type", 0x200000, de.grogra.reflect.Type.INT, null, 1);

    SplineFunction() {
        this(null, 0);
    }

    public SplineFunction(Point2f[] point2fArray, int n) {
        this.data = point2fArray;
        this.type = n;
    }

    public SplineFunction(float[] fArray, float[] fArray2, int n) {
        this.data = new Point2f[fArray.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new Point2f(fArray[i], fArray2[i]);
        }
        this.type = n;
    }

    private void computeCoefficients() {
        int n;
        int n2 = this.data.length;
        if (n2 <= 2) {
            this.coeffC = new float[n2];
            return;
        }
        int n3 = n2 - 3;
        float[] fArray = new float[n2];
        for (int i = 0; i < n2 - 1; ++i) {
            fArray[i] = this.data[i + 1].x - this.data[i].x;
        }
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n3 + 1];
        float[] fArray4 = new float[n3];
        float[] fArray5 = new float[n3 + 1];
        for (n = 0; n <= n3; ++n) {
            fArray3[n] = 2.0f * (fArray[n] + fArray[n + 1]) - (n == 0 ? 0.0f : fArray2[n - 1] * fArray4[n - 1]);
            if (n < n3) {
                fArray2[n] = fArray[n + 1];
                fArray4[n] = fArray[n + 1] / fArray3[n];
            }
            fArray5[n] = 3.0f * ((this.data[n + 2].y - this.data[n + 1].y) / fArray[n + 1] - (this.data[n + 1].y - this.data[n].y) / fArray[n]);
        }
        for (n = 1; n <= n3; ++n) {
            int n4 = n;
            fArray5[n4] = fArray5[n4] - fArray5[n - 1] * fArray4[n - 1];
        }
        float[] fArray6 = new float[n2];
        int n5 = n3;
        fArray5[n5] = fArray5[n5] / fArray3[n3];
        fArray6[n3 + 1] = fArray5[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            fArray5[i] = (fArray5[i] - fArray2[i] * fArray5[i + 1]) / fArray3[i];
            fArray6[i + 1] = fArray5[i];
        }
        this.coeffC = fArray6;
    }

    private int getDegree() {
        return this.data.length < 4 ? this.data.length - 1 : 3;
    }

    private int findSpan(float f) {
        int n;
        int n2 = this.data.length;
        if (f <= this.data[0].x) {
            return 0;
        }
        if (f >= this.data[n2 - 1].x) {
            return n2 - 2;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (true) {
            n = n3 + n4 >> 1;
            if (f < this.data[n].x) {
                n4 = n;
                continue;
            }
            if (!(f >= this.data[n + 1].x)) break;
            n3 = n;
        }
        return n;
    }

    public float evaluateCubic(float f) {
        if (this.getStamp() != this.coeffCStamp) {
            this.computeCoefficients();
            this.coeffCStamp = this.getStamp();
        }
        float[] fArray = this.coeffC;
        int n = this.findSpan(f);
        float f2 = this.data[n + 1].x - this.data[n].x;
        float f3 = (fArray[n + 1] - fArray[n]) / (3.0f * f2);
        f3 = (f -= this.data[n].x) * f3 + fArray[n];
        f3 = f * f3 + (this.data[n + 1].y - this.data[n].y) / f2 + (2.0f * fArray[n] + fArray[n + 1]) * f2 * -0.33333334f;
        f3 = f * f3 + this.data[n].y;
        return f3;
    }

    private float computeSlope(int n) {
        Point2f point2f = this.data[n];
        if (n == 0) {
            Point2f point2f2 = this.data[n + 1];
            return (point2f2.y - point2f.y) / (point2f2.x - point2f.x);
        }
        Point2f point2f3 = this.data[n - 1];
        if (n == this.data.length - 1) {
            return (point2f.y - point2f3.y) / (point2f.x - point2f3.x);
        }
        Point2f point2f4 = this.data[n + 1];
        return 0.5f * ((point2f.y - point2f3.y) / (point2f.x - point2f3.x) + (point2f4.y - point2f.y) / (point2f4.x - point2f.x));
    }

    public float evaluateHermite(float f) {
        int n = this.findSpan(f);
        float f2 = this.data[n + 1].x - this.data[n].x;
        f = (f - this.data[n].x) / f2;
        float f3 = 1.0f - f;
        return (this.data[n].y * (3.0f - 2.0f * f3) + f2 * this.computeSlope(n) * f) * f3 * f3 + (this.data[n + 1].y * (3.0f - 2.0f * f) - f2 * this.computeSlope(n + 1) * f3) * f * f;
    }

    public float evaluateFloat(float f) {
        switch (this.type) {
            case 1: {
                return this.evaluateCubic(f);
            }
            case 2: {
                return this.evaluateHermite(f);
            }
        }
        return this.evaluateBSpline(f);
    }

    public float evaluateBSpline(float f) {
        int n;
        int n2 = this.data.length - 1;
        if (f <= this.data[0].x) {
            return this.data[0].y;
        }
        if (f >= this.data[n2].x) {
            return this.data[n2].y;
        }
        int n3 = n = this.getDegree();
        int n4 = n2 + 1;
        float[] fArray = this.bf;
        float f2 = 1.0f / (float)(n2 - n + 1);
        float[] fArray2 = fArray;
        synchronized (fArray) {
            float f3;
            float f4;
            float f5;
            float f6;
            int n5;
            FloatList.clear((float[])fArray, (int)0, (int)16);
            while (true) {
                n5 = n3 + n4 >> 1;
                n2 = n5 - n;
                BSpline.calculateBasisFunctions(fArray, n, this, 0, n5, (float)n2 * f2, null, this.left, this.right);
                f6 = this.data[n2].x;
                f5 = this.data[n2 + 1].x;
                f4 = n > 1 ? this.data[n2 + 2].x : 0.0f;
                float f7 = f3 = n > 2 ? this.data[n2 + 3].x : 0.0f;
                if (f < f6 * fArray[0] + f5 * fArray[1] + f4 * fArray[2] + f3 * fArray[3]) {
                    n4 = n5;
                    continue;
                }
                BSpline.calculateBasisFunctions(fArray, n, this, 0, n5, (float)(n2 + 1) * f2, null, this.left, this.right);
                if (!(f >= f6 * fArray[0] + f5 * fArray[1] + f4 * fArray[2] + f3 * fArray[3])) break;
                n3 = n5;
            }
            BSpline.calculateDerivatives(fArray, n, this, 0, n5, (float)(2 * n2 + 1) * (f2 *= 0.5f), n, null, this.left, this.right, this.ndu);
            float f8 = f6 * fArray[0] + f5 * fArray[1] + f4 * fArray[2] + f3 * fArray[3];
            n3 = n + 1;
            float f9 = f6 * fArray[n3] + f5 * fArray[n3 + 1] + f4 * fArray[n3 + 2] + f3 * fArray[n3 + 3];
            n3 = 2 * (n + 1);
            float f10 = (f6 * fArray[n3] + f5 * fArray[n3 + 1] + f4 * fArray[n3 + 2] + f3 * fArray[n3 + 3]) * 0.5f;
            n3 = 3 * (n + 1);
            float f11 = (f6 * fArray[n3] + f5 * fArray[n3 + 1] + f4 * fArray[n3 + 2] + f3 * fArray[n3 + 3]) * 0.16666667f;
            f4 = f2 * 1.0E-4f;
            f3 = -f4;
            float f12 = 0.0f;
            while (true) {
                f6 = (3.0f * f11 * f12 + 2.0f * f10) * f12 + f9;
                f5 = (f - (((f11 * f12 + f10) * f12 + f9) * f12 + f8)) / f6;
                f12 += f5;
                if (f5 > f3 && f5 < f4) {
                    f6 = this.data[n2].y;
                    f5 = this.data[n2 + 1].y;
                    f4 = n > 1 ? this.data[n2 + 2].y : 0.0f;
                    f3 = n > 2 ? this.data[n2 + 3].y : 0.0f;
                    float f13 = 0.0f;
                    for (int i = n; i >= 0; --i) {
                        n3 = i * (n + 1);
                        f13 = f12 * f13 + (f6 * fArray[n3] + f5 * fArray[n3 + 1] + f4 * fArray[n3 + 2] + f3 * fArray[n3 + 3]);
                        if (i <= 1) continue;
                        f13 /= (float)i;
                    }
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return f13;
                }
                if (f12 > f2) {
                    f12 = f2;
                    continue;
                }
                if (!(f12 < -f2)) continue;
                f12 = -f2;
            }
        }
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        int n3 = this.data.length;
        int n4 = this.getDegree();
        return n2 <= n4 ? 0.0f : (n2 >= n3 ? 1.0f : (float)(n2 - n4) / (float)(n3 - n4));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SplineFunction)) {
            return false;
        }
        SplineFunction splineFunction = (SplineFunction)object;
        if (splineFunction.data.length != this.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].equals((Tuple2f)splineFunction.data[i])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        SplineFunction splineFunction = new SplineFunction(new Point2f[]{new Point2f(2.0f, 5.0f), new Point2f(4.0f, 7.0f)}, 1);
        for (int i = 0; i < splineFunction.data.length; ++i) {
            System.out.println(splineFunction.data[i].x + " " + splineFunction.data[i].y);
        }
        System.out.println("4 0");
        for (float f = splineFunction.data[0].x; f < splineFunction.data[splineFunction.data.length - 1].x; f += 0.02f * (splineFunction.data[splineFunction.data.length - 1].x - splineFunction.data[0].x)) {
            System.out.println(f + " " + splineFunction.evaluateFloat(f));
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Point2f[] getData() {
        return this.data;
    }

    public void setData(Point2f[] point2fArray) {
        data$FIELD.setObject((Object)this, (Object)point2fArray);
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SplineFunction splineFunction, SCOType sCOType) {
            super((Object)splineFunction, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((SplineFunction)object).type = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((SplineFunction)object).getType();
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((SplineFunction)object).data = (Point2f[])object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((SplineFunction)object).getData();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new SplineFunction();
        }
    }
}

