/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb;

import de.grogra.ext.pdb.ProteinFactory;
import de.grogra.ext.pdb.model.AminoAcid;
import de.grogra.ext.pdb.model.AminoSequence;
import de.grogra.ext.pdb.model.Atom;
import de.grogra.ext.pdb.model.IProtein;
import de.grogra.ext.pdb.model.Protein;

public class HierarchicalStructureFactory
implements ProteinFactory {
    private static final String SEQUENCE_TERMINATION = "OXT";
    private boolean aminoOpen = false;
    private boolean sequenceOpen = false;
    private AminoAcid currentAmino;
    private AminoSequence currentSequence;
    private Protein protein;

    public HierarchicalStructureFactory() {
        new HierarchicalStructureFactory("unknown protein");
    }

    public HierarchicalStructureFactory(String string) {
        System.out.println("start processing protein data model...");
        this.protein = new Protein(string);
    }

    public void processAtomEntry(String string, String string2, int n, float f, float f2, float f3) {
        if (!this.sequenceOpen) {
            this.openAminoSequence();
        }
        if (!this.aminoOpen && !string.equals(SEQUENCE_TERMINATION)) {
            this.openAminoAcid(string2, n);
        }
        if (n != this.currentAmino.getResSeqNr()) {
            this.closeAminoAcid();
            this.openAminoAcid(string2, n);
        }
        this.openAtom(string, f, f2, f3);
    }

    private void openAtom(String string, float f, float f2, float f3) {
        if (this.aminoOpen && this.sequenceOpen) {
            Atom atom = new Atom(string, f, f2, f3);
            this.currentAmino.addAtom(atom);
        }
        if (string.equals(SEQUENCE_TERMINATION)) {
            this.closeAminoAcid();
            this.closeAminoSequence();
        }
    }

    private void openAminoAcid(String string, int n) {
        if (!this.sequenceOpen) {
            this.openAminoSequence();
        }
        this.aminoOpen = true;
        this.currentAmino = new AminoAcid(string, n);
    }

    private void closeAminoAcid() {
        if (this.aminoOpen) {
            this.currentSequence.addAminoAcid(this.currentAmino);
            this.aminoOpen = false;
        } else {
            System.out.println("Error while closing amino acid");
        }
    }

    private void openAminoSequence() {
        this.sequenceOpen = true;
        this.currentSequence = new AminoSequence();
    }

    private void closeAminoSequence() {
        this.sequenceOpen = false;
        this.protein.addAminoSequence(this.currentSequence);
    }

    public void closeProtein() {
        if (this.aminoOpen) {
            this.closeAminoAcid();
        }
        if (this.sequenceOpen) {
            this.closeAminoSequence();
        }
        System.out.println("processed " + AminoSequence.numberOfSequences + " sequences, " + AminoAcid.numberOfAcids + " amino acids and " + Atom.numberOfAtoms + " atoms.");
        System.out.println();
        System.out.println();
        this.sequenceOpen = true;
    }

    public IProtein getProtein() {
        return this.protein;
    }
}

