/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb.view;

import de.grogra.ext.pdb.model.IProtein;
import de.grogra.ext.pdb.view.Visualizer;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import java.util.HashMap;

public class SpaceFilledVisualizer
implements Visualizer,
Command {
    private static HashMap atomColorMapping = new HashMap();
    private static HashMap atomSizeMapping = new HashMap();
    private IProtein protein;

    public SpaceFilledVisualizer(IProtein iProtein) {
        this.protein = iProtein;
        atomColorMapping.put("O", RGBAShader.RED);
        atomColorMapping.put("N", RGBAShader.BLUE);
        atomColorMapping.put("C", RGBAShader.DARK_GRAY);
        atomColorMapping.put("S", RGBAShader.YELLOW);
        atomSizeMapping.put("O", new Float(1.52));
        atomSizeMapping.put("N", new Float(1.55));
        atomSizeMapping.put("C", new Float(1.7));
        atomSizeMapping.put("S", new Float(1.8));
    }

    private Object getAtomSizeMapping(Object object) {
        Object object2 = atomSizeMapping.get(object);
        if (object2 == null) {
            object2 = new Float(1.0f);
        }
        return object2;
    }

    private Object getAtomColorMapping(Object object) {
        Object object2 = atomColorMapping.get(object);
        if (object2 == null) {
            object2 = RGBAShader.PINK;
        }
        return object2;
    }

    public Node createGraph() {
        Node node = new Node();
        for (int i = 0; i < this.protein.getNumberOfSequences(); ++i) {
            Node node2 = new Node();
            for (int j = 0; j < this.protein.getNumberOfAcids(i); ++j) {
                Node node3 = new Node();
                for (int k = 0; k < this.protein.getNumberOfAtoms(i, j); ++k) {
                    float f = ((Float)this.getAtomSizeMapping(this.protein.getElement(i, j, k))).floatValue();
                    Sphere sphere = new Sphere(f);
                    sphere.setTransform((double)this.protein.getXCoord(i, j, k), (double)this.protein.getYCoord(i, j, k), (double)this.protein.getZCoord(i, j, k));
                    Shader shader = (Shader)this.getAtomColorMapping(this.protein.getElement(i, j, k));
                    sphere.setShader(shader);
                    if (shader == null) {
                        shader = RGBAShader.BLACK;
                    }
                    node3.addEdgeBitsTo((Node)sphere, 512, null);
                }
                node2.addEdgeBitsTo(node3, 512, null);
            }
            node.addEdgeBitsTo(node2, 512, null);
        }
        return node;
    }

    public String getCommandName() {
        return null;
    }

    public void run(Object object, Context context) {
        System.out.println("running command space filled model...");
    }
}

