/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks;

import de.grogra.blocks.Attributes;
import de.grogra.blocks.BlockTools;
import de.grogra.blocks.CustomFunction;
import de.grogra.blocks.HydraLOD;
import de.grogra.blocks.LocationParameterBase;
import de.grogra.blocks.ModeList;
import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.Circle;
import de.grogra.math.Cos;
import de.grogra.math.Ellipse;
import de.grogra.math.Id;
import de.grogra.math.SplineFunction;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Transaction;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.Instantiation;
import de.grogra.turtle.RL;
import de.grogra.turtle.Rotate;
import de.grogra.turtle.Scale;
import de.grogra.vecmath.Matrix34d;
import de.grogra.xl.lang.FloatToFloat;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hydra
extends Sphere
implements de.grogra.xl.modules.Instantiator<Instantiation> {
    private static final long serialVersionUID = 1L;
    CustomFunction number = new CustomFunction(10.0, 1.0, 100.0);
    BSplineCurve trajectory = new Circle(3.0f);
    CustomFunction twist2 = new CustomFunction(0.0, -Math.PI, Math.PI);
    CustomFunction twist1 = new CustomFunction(0.0, -Math.PI, Math.PI);
    FloatToFloat twistMode = new Id();
    CustomFunction spin2 = new CustomFunction(0.0, -Math.PI, Math.PI);
    CustomFunction spin1 = new CustomFunction(0.0, -Math.PI, Math.PI);
    FloatToFloat spinMode = new Id();
    CustomFunction scale2 = new CustomFunction(0.0, -1.5707963267948966, 1.5707963267948966);
    CustomFunction scale1 = new CustomFunction(0.0, -1.5707963267948966, 1.5707963267948966);
    FloatToFloat scaleMode = new Cos();
    FloatToFloat slopeFunction = (FloatToFloat)BlockTools.getObject("/objects/math/functions/HydraFunctions/slopeHydra", new Id());
    HydraLOD lod = new HydraLOD();
    LocationParameterBase locationParameter = new LocationParameterBase();
    boolean initAll = false;
    private Point2f ids = new Point2f(0.0f, 0.0f);
    private Float densityValue = new Float(0.0f);
    private Tuple2f height = new Point2f(0.0f, 0.0f);
    private Tuple3f nutrientsValues = new Point3f(0.0f, 0.0f, 0.0f);
    private int childId = 0;
    private static final RL RL90 = new RL(90.0f);
    private static final RL RL_90 = new RL(-90.0f);
    public static final Node.NType $TYPE = new Node.NType((Node)new Hydra());
    public static final Node.NType.Field number$FIELD = new _Field("number", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 0);
    public static final Node.NType.Field trajectory$FIELD;
    public static final Node.NType.Field twist2$FIELD;
    public static final Node.NType.Field twist1$FIELD;
    public static final Node.NType.Field twistMode$FIELD;
    public static final Node.NType.Field spin2$FIELD;
    public static final Node.NType.Field spin1$FIELD;
    public static final Node.NType.Field spinMode$FIELD;
    public static final Node.NType.Field scale2$FIELD;
    public static final Node.NType.Field scale1$FIELD;
    public static final Node.NType.Field scaleMode$FIELD;
    public static final Node.NType.Field slopeFunction$FIELD;
    public static final Node.NType.Field lod$FIELD;
    public static final Node.NType.Field locationParameter$FIELD;
    public static final Node.NType.Field initAll$FIELD;

    public Hydra() {
        super(0.15f);
        super.setLayer(1);
        this.initFunctionsToHermit();
    }

    public Hydra(float f) {
        super(0.15f);
        super.setLayer(1);
        this.number.setFunction(f);
        this.initFunctionsToHermit();
    }

    public Hydra(boolean bl) {
        super(0.15f);
        super.setLayer(1);
        if (!bl) {
            this.slopeFunction = (FloatToFloat)BlockTools.getObject("/objects/math/functions/HydraFunctions/slopeWreath", new Id());
        }
        this.initFunctionsToHermit();
    }

    public Hydra(float f, boolean bl) {
        super(0.15f);
        super.setLayer(1);
        this.number.setFunction(f);
        if (!bl) {
            this.slopeFunction = (FloatToFloat)BlockTools.getObject("/objects/math/functions/HydraFunctions/slopeWreath", new Id());
        }
        this.initFunctionsToHermit();
    }

    private void initAttributes() {
        this.number = new CustomFunction(10.0, 1.0, 100.0);
        this.trajectory = new Circle(3.0f);
        this.twist2 = new CustomFunction(0.0, -Math.PI, Math.PI);
        this.twist1 = new CustomFunction(0.0, -Math.PI, Math.PI);
        this.twistMode = new Id();
        this.spin1 = new CustomFunction(0.0, -Math.PI, Math.PI);
        this.spin2 = new CustomFunction(0.0, -Math.PI, Math.PI);
        this.spinMode = new Id();
        this.scale2 = new CustomFunction(0.0, -1.5707963267948966, 1.5707963267948966);
        this.scale1 = new CustomFunction(0.0, -1.5707963267948966, 1.5707963267948966);
        this.scaleMode = new Cos();
        this.slopeFunction = (FloatToFloat)BlockTools.getObject("/objects/math/functions/HydraFunctions/slopeHydra", new Id());
        this.lod = new HydraLOD();
        this.locationParameter = new LocationParameterBase();
        this.initFunctionsToHermit();
    }

    private void initFunctionsToHermit() {
        ((SplineFunction)this.slopeFunction).setType(2);
    }

    public Instantiator getInstantiator() {
        return Instantiation.INSTANTIATOR;
    }

    public void instantiate(Instantiation instantiation) {
        Instantiation instantiation2 = instantiation;
        Library.setSeed((long)((Object)((Object)this)).hashCode());
        this.ids = (Point2f)instantiation2.getGraphState().getObjectDefault((Object)this, true, Attributes.ID, null);
        this.densityValue = (Float)instantiation2.getGraphState().getObjectDefault((Object)this, true, Attributes.DENSITY, (Object)Float.valueOf(1.0f));
        Matrix34d matrix34d = GlobalTransformation.get((Object)((Object)this), (boolean)true, (GraphState)instantiation2.getGraphState(), (boolean)false);
        Vector3d vector3d = new Vector3d();
        matrix34d.get(vector3d);
        this.height = new Point2f((float)vector3d.z, ((Float)instantiation2.getGraphState().getObjectDefault((Object)this, true, Attributes.HEIGHT, (Object)Float.valueOf(1.0f))).floatValue());
        this.lod.set(View.get((GraphState)instantiation2.getGraphState()), vector3d, 1.0f);
        this.nutrientsValues = (Tuple3f)instantiation2.getGraphState().getObjectDefault((Object)this, true, Attributes.LOCATIONPARAMETER, null);
        Tuple3f tuple3f = this.locationParameter.setLocationParameter(this.nutrientsValues);
        int n = this.lod.numberToLod(this.number.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()));
        float f = 2.0f * this.twist1.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f2 = 2.0f * this.twist2.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f3 = this.spin1.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f4 = this.spin2.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f5 = this.scale1.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f6 = this.scale2.evaluateFloat((Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()) / (float)n;
        float f7 = 0.0f;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)i / (float)n;
        }
        float[] fArray2 = new float[4];
        Vector3d vector3d2 = new Vector3d(0.0, 0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            this.childId = i;
            instantiation2.getGraphState().setInstanceAttribute((Attribute)Attributes.NUTRIENTS_TUPLE3F, (Object)tuple3f);
            instantiation2.getGraphState().setInstanceAttribute((Attribute)Attributes.NUMBER_INT, (Object)new Integer(n));
            int n2 = this.trajectory.getDimension(instantiation2.getGraphState()) - 1;
            BSpline.evaluate((float[])fArray2, (BSplineCurve)this.trajectory, (float)fArray[i], (GraphState)instantiation2.getGraphState());
            if (this.trajectory.isRational(instantiation2.getGraphState())) {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    int n4 = n3--;
                    fArray2[n4] = fArray2[n4] / fArray2[n2];
                }
                fArray2[n2] = 0.0f;
                vector3d2 = this.kartesisch2kugel(fArray2);
            } else {
                vector3d2 = this.kartesisch2kugel(fArray2);
            }
            float f8 = ModeList.function(i, n, f, f2, this.twistMode, (Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue());
            f7 = f7 + (float)(i * n) * f4 + ModeList.function(i, n, f3, f4, this.spinMode, (Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue());
            float f9 = this.lod.scaleToLod(ModeList.function(i, n, f5, f6, this.scaleMode, (Tuple2f)this.ids, this.nutrientsValues, this.height, this.densityValue.floatValue()));
            float f10 = (float)((double)(this.slopeFunction.evaluateFloat(fArray[i]) * 2.0f) * Math.PI - 4.71238898038469);
            instantiation2.producer$push();
            instantiation2.instantiate((Node)new Null((double)fArray2[0], (double)fArray2[1], (double)fArray2[2]));
            instantiation2.instantiate((Node)RL90);
            instantiation2.instantiate((Node)new Rotate(0.0f, (float)(vector3d2.y + ((double)f10 + 7.853981633974483)) * 57.29578f, f10 * 57.29578f));
            instantiation2.instantiate((Node)RL_90);
            instantiation2.instantiate((Node)new Rotate(0.0f, f8 * 57.29578f, f7 * 57.29578f));
            Scale scale = new Scale(f9);
            instantiation2.instantiate((Node)scale);
            this.setHeightLocal(instantiation2, (Node)scale, this.height.x);
            for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext((Node)this)) {
                Node node = edge.getTarget();
                if (node == this || !edge.testEdgeBits(131072) && !edge.testEdgeBits(262144)) continue;
                instantiation2.producer$push();
                instantiation2.getGraphState().setInstanceAttribute((Attribute)Attributes.ID_TUPLE2F, (Object)new Point2f((float)i, this.ids.x));
                instantiation2.instantiate(node);
                instantiation2.producer$pop(null);
            }
            instantiation2.producer$pop(null);
        }
    }

    private Vector3d kartesisch2kugel(float[] fArray) {
        double d = Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        double d2 = 0.0;
        d2 = fArray[1] >= 0.0f ? Math.acos((double)fArray[0] / Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1])) : Math.PI * 2 - Math.acos((double)fArray[0] / Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1]));
        double d3 = 1.5707963267948966 - Math.atan((double)fArray[2] / Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1]));
        return new Vector3d(d, d2, d3);
    }

    private void setHeightLocal(Instantiation instantiation, Node node, float f) {
        Matrix34d matrix34d = GlobalTransformation.get((Object)node, (boolean)true, (GraphState)instantiation.getGraphState(), (boolean)false);
        Vector3d vector3d = new Vector3d();
        matrix34d.get(vector3d);
        this.height.y = (float)Math.abs(vector3d.z - (double)f);
        instantiation.getGraphState().setInstanceAttribute((Attribute)Attributes.HEIGHT_FLOAT, (Object)new Float(this.height.y));
    }

    public void setRadius(float f, float f2) {
        this.trajectory = new Ellipse(f, f2);
    }

    public void setRadius(float f) {
        if (this.trajectory instanceof Circle) {
            ((Circle)this.trajectory).setRadius(f);
        }
    }

    public float getRadius() {
        if (this.trajectory instanceof Circle) {
            return ((Circle)this.trajectory).getRadius();
        }
        return 0.0f;
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        super.fieldModified(persistenceField, nArray, transaction);
        if (!Transaction.isApplying((Transaction)transaction) && persistenceField.overlaps(nArray, (FieldChain)initAll$FIELD, null) && this.isInitAll()) {
            this.initAttributes();
            this.setInitAll(false);
        }
    }

    public float getNumber() {
        return this.number.evaluateZerro();
    }

    public void setNumber(double d) {
        this.number.setFunction(d);
    }

    public float getTwist2() {
        return this.twist2.evaluateZerro();
    }

    public void setTwist2(double d) {
        this.twist2.setFunction(d);
    }

    public float getTwist1() {
        return this.twist1.evaluateZerro();
    }

    public void setTwist1(double d) {
        this.twist1.setFunction(d);
    }

    public void setTwist(double d, double d2) {
        this.twist1.setFunction(d);
        this.twist2.setFunction(d2);
    }

    public float getSpin1() {
        return this.spin1.evaluateZerro();
    }

    public void setSpin1(double d) {
        this.spin1.setFunction(d);
    }

    public float getSpin2() {
        return this.spin2.evaluateZerro();
    }

    public void setSpin2(double d) {
        this.spin2.setFunction(d);
    }

    public void setSpin(double d, double d2) {
        this.spin1.setFunction(d);
        this.spin2.setFunction(d2);
    }

    public float getScale2() {
        return this.scale2.evaluateZerro();
    }

    public void setScale2(double d) {
        this.scale2.setFunction(d);
    }

    public float getScale1() {
        return this.scale1.evaluateZerro();
    }

    public void setScale1(double d) {
        this.scale1.setFunction(d);
    }

    public void setScale(double d, double d2) {
        this.scale1.setFunction(d);
        this.scale2.setFunction(d2);
    }

    public void setNumber(String string) {
        this.number.setFunction(string);
    }

    public void setTwist2(String string) {
        this.twist2.setFunction(string);
    }

    public void setTwist1(String string) {
        this.twist1.setFunction(string);
    }

    public void setTwist(String string, String string2) {
        this.twist1.setFunction(string);
        this.twist2.setFunction(string2);
    }

    public void setSpin1(String string) {
        this.spin1.setFunction(string);
    }

    public void setSpin2(String string) {
        this.spin2.setFunction(string);
    }

    public void setSpin(String string, String string2) {
        this.spin1.setFunction(string);
        this.spin2.setFunction(string2);
    }

    public void setScale2(String string) {
        this.scale2.setFunction(string);
    }

    public void setScale1(String string) {
        this.scale1.setFunction(string);
    }

    public void setScale(String string, String string2) {
        this.scale1.setFunction(string);
        this.scale2.setFunction(string2);
    }

    public void useLod(boolean bl) {
        this.lod.setUseLOD(bl);
    }

    public int getChildId() {
        return this.childId;
    }

    public int getParentId() {
        return (int)this.ids.x;
    }

    public int getThisId() {
        return (int)this.ids.y;
    }

    public float getDensity() {
        return this.densityValue.floatValue();
    }

    public float getAbsoluteHeight() {
        return this.height.x;
    }

    public float getLocalHeight() {
        return this.height.y;
    }

    public float getN1() {
        return this.nutrientsValues.x;
    }

    public float getN2() {
        return this.nutrientsValues.y;
    }

    public float getN3() {
        return this.nutrientsValues.z;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Hydra();
    }

    public boolean isInitAll() {
        return this.initAll;
    }

    public void setInitAll(boolean bl) {
        this.initAll = bl;
    }

    public void setNumber(CustomFunction customFunction) {
        number$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public BSplineCurve getTrajectory() {
        return this.trajectory;
    }

    public void setTrajectory(BSplineCurve bSplineCurve) {
        trajectory$FIELD.setObject((Object)this, (Object)bSplineCurve);
    }

    public void setTwist2(CustomFunction customFunction) {
        twist2$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public void setTwist1(CustomFunction customFunction) {
        twist1$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public FloatToFloat getTwistMode() {
        return this.twistMode;
    }

    public void setTwistMode(FloatToFloat floatToFloat) {
        twistMode$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    public void setSpin2(CustomFunction customFunction) {
        spin2$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public void setSpin1(CustomFunction customFunction) {
        spin1$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public FloatToFloat getSpinMode() {
        return this.spinMode;
    }

    public void setSpinMode(FloatToFloat floatToFloat) {
        spinMode$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    public void setScale2(CustomFunction customFunction) {
        scale2$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public void setScale1(CustomFunction customFunction) {
        scale1$FIELD.setObject((Object)this, (Object)customFunction);
    }

    public FloatToFloat getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleMode(FloatToFloat floatToFloat) {
        scaleMode$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    public FloatToFloat getSlopeFunction() {
        return this.slopeFunction;
    }

    public void setSlopeFunction(FloatToFloat floatToFloat) {
        slopeFunction$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    public HydraLOD getLod() {
        return this.lod;
    }

    public void setLod(HydraLOD hydraLOD) {
        lod$FIELD.setObject((Object)this, (Object)hydraLOD);
    }

    public LocationParameterBase getLocationParameter() {
        return this.locationParameter;
    }

    public void setLocationParameter(LocationParameterBase locationParameterBase) {
        locationParameter$FIELD.setObject((Object)this, (Object)locationParameterBase);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)number$FIELD);
        trajectory$FIELD = new _Field("trajectory", 0x200000, (Type)ClassAdapter.wrap(BSplineCurve.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)trajectory$FIELD);
        twist2$FIELD = new _Field("twist2", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 2);
        $TYPE.addManagedField((ManageableType.Field)twist2$FIELD);
        twist1$FIELD = new _Field("twist1", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 3);
        $TYPE.addManagedField((ManageableType.Field)twist1$FIELD);
        twistMode$FIELD = new _Field("twistMode", 0x200000, (Type)ClassAdapter.wrap(FloatToFloat.class), null, 4);
        $TYPE.addManagedField((ManageableType.Field)twistMode$FIELD);
        spin2$FIELD = new _Field("spin2", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 5);
        $TYPE.addManagedField((ManageableType.Field)spin2$FIELD);
        spin1$FIELD = new _Field("spin1", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 6);
        $TYPE.addManagedField((ManageableType.Field)spin1$FIELD);
        spinMode$FIELD = new _Field("spinMode", 0x200000, (Type)ClassAdapter.wrap(FloatToFloat.class), null, 7);
        $TYPE.addManagedField((ManageableType.Field)spinMode$FIELD);
        scale2$FIELD = new _Field("scale2", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 8);
        $TYPE.addManagedField((ManageableType.Field)scale2$FIELD);
        scale1$FIELD = new _Field("scale1", 0x200000, (Type)ClassAdapter.wrap(CustomFunction.class), null, 9);
        $TYPE.addManagedField((ManageableType.Field)scale1$FIELD);
        scaleMode$FIELD = new _Field("scaleMode", 0x200000, (Type)ClassAdapter.wrap(FloatToFloat.class), null, 10);
        $TYPE.addManagedField((ManageableType.Field)scaleMode$FIELD);
        slopeFunction$FIELD = new _Field("slopeFunction", 0x200000, (Type)ClassAdapter.wrap(FloatToFloat.class), null, 11);
        $TYPE.addManagedField((ManageableType.Field)slopeFunction$FIELD);
        lod$FIELD = new _Field("lod", 0x200000, (Type)ClassAdapter.wrap(HydraLOD.class), null, 12);
        $TYPE.addManagedField((ManageableType.Field)lod$FIELD);
        locationParameter$FIELD = new _Field("locationParameter", 0x200000, (Type)ClassAdapter.wrap(LocationParameterBase.class), null, 13);
        $TYPE.addManagedField((ManageableType.Field)locationParameter$FIELD);
        initAll$FIELD = new _Field("initAll", 0x200000, Type.BOOLEAN, null, 14);
        $TYPE.addManagedField((ManageableType.Field)initAll$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 14: {
                    ((Hydra)((Object)object)).initAll = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 14: {
                    return ((Hydra)((Object)object)).isInitAll();
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Hydra)((Object)object)).number = (CustomFunction)((Object)object2);
                    return;
                }
                case 1: {
                    ((Hydra)((Object)object)).trajectory = (BSplineCurve)object2;
                    return;
                }
                case 2: {
                    ((Hydra)((Object)object)).twist2 = (CustomFunction)((Object)object2);
                    return;
                }
                case 3: {
                    ((Hydra)((Object)object)).twist1 = (CustomFunction)((Object)object2);
                    return;
                }
                case 4: {
                    ((Hydra)((Object)object)).twistMode = (FloatToFloat)object2;
                    return;
                }
                case 5: {
                    ((Hydra)((Object)object)).spin2 = (CustomFunction)((Object)object2);
                    return;
                }
                case 6: {
                    ((Hydra)((Object)object)).spin1 = (CustomFunction)((Object)object2);
                    return;
                }
                case 7: {
                    ((Hydra)((Object)object)).spinMode = (FloatToFloat)object2;
                    return;
                }
                case 8: {
                    ((Hydra)((Object)object)).scale2 = (CustomFunction)((Object)object2);
                    return;
                }
                case 9: {
                    ((Hydra)((Object)object)).scale1 = (CustomFunction)((Object)object2);
                    return;
                }
                case 10: {
                    ((Hydra)((Object)object)).scaleMode = (FloatToFloat)object2;
                    return;
                }
                case 11: {
                    ((Hydra)((Object)object)).slopeFunction = (FloatToFloat)object2;
                    return;
                }
                case 12: {
                    ((Hydra)((Object)object)).lod = (HydraLOD)((Object)object2);
                    return;
                }
                case 13: {
                    ((Hydra)((Object)object)).locationParameter = (LocationParameterBase)((Object)object2);
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Hydra)((Object)object)).number;
                }
                case 1: {
                    return ((Hydra)((Object)object)).getTrajectory();
                }
                case 2: {
                    return ((Hydra)((Object)object)).twist2;
                }
                case 3: {
                    return ((Hydra)((Object)object)).twist1;
                }
                case 4: {
                    return ((Hydra)((Object)object)).getTwistMode();
                }
                case 5: {
                    return ((Hydra)((Object)object)).spin2;
                }
                case 6: {
                    return ((Hydra)((Object)object)).spin1;
                }
                case 7: {
                    return ((Hydra)((Object)object)).getSpinMode();
                }
                case 8: {
                    return ((Hydra)((Object)object)).scale2;
                }
                case 9: {
                    return ((Hydra)((Object)object)).scale1;
                }
                case 10: {
                    return ((Hydra)((Object)object)).getScaleMode();
                }
                case 11: {
                    return ((Hydra)((Object)object)).getSlopeFunction();
                }
                case 12: {
                    return ((Hydra)((Object)object)).getLod();
                }
                case 13: {
                    return ((Hydra)((Object)object)).getLocationParameter();
                }
            }
            return super.getObject(object);
        }
    }
}

