/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.exportation;

import de.grogra.ext.x3d.X3DExport;
import de.grogra.ext.x3d.exportation.BaseExport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.BackgroundDocument;
import de.grogra.ext.x3d.xmlbeans.SceneDocument;
import de.grogra.ext.x3d.xmlbeans.ShapeDocument;
import de.grogra.ext.x3d.xmlbeans.TransformDocument;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SideSwitchShader;
import de.grogra.imp3d.shading.SurfaceMap;
import de.grogra.math.ChannelMap;
import de.grogra.math.RGBColor;
import de.grogra.pf.registry.Item;
import de.grogra.xl.util.ObjectList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class BackgroundExport
extends BaseExport {
    protected void exportImpl(SceneTree.Leaf leaf, X3DExport x3DExport, ShapeDocument.Shape shape, TransformDocument.Transform transform) throws IOException {
        SceneDocument.Scene scene = x3DExport.getScene();
        BackgroundDocument.Background background = null;
        background = scene.getBackgroundArray().length == 0 ? scene.addNewBackground() : scene.getBackgroundArray(0);
        Shader shader = ((Sky)x3DExport.getGraphState().getObjectDefault(leaf.object, true, Attributes.SHAPE, null)).getShader();
        Object object = shader instanceof SideSwitchShader ? ((SideSwitchShader)shader).getFrontShader() : (shader instanceof Phong ? shader : null);
        if (object instanceof Phong) {
            Phong phong = (Phong)object;
            if (phong.getDiffuse() instanceof SurfaceMap) {
                this.exportBGImages(background, (SurfaceMap)phong.getDiffuse(), x3DExport);
            } else {
                int n = phong.getAverageColor();
                RGBColor rGBColor = Util.intToRGB(n);
                background.setSkyColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
            }
        } else {
            int n = shader != null ? shader.getAverageColor() : -8355585;
            RGBColor rGBColor = Util.intToRGB(n);
            background.setSkyColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
        }
    }

    private void exportBGImages(BackgroundDocument.Background background, SurfaceMap surfaceMap, X3DExport x3DExport) {
        Object object;
        Object object2;
        Object object3;
        BufferedImage bufferedImage;
        String string = "png";
        String string2 = "backgroundmap." + string;
        ChannelMap channelMap = surfaceMap.getInput();
        int n = 1024;
        boolean bl = channelMap instanceof AffineUVTransformation ? true : channelMap != null;
        if (bl) {
            bufferedImage = new BufferedImage(n, n, 2);
            x3DExport.increaseProgress();
            surfaceMap.drawImage(bufferedImage, 1, true);
            x3DExport.increaseProgress();
        } else if (surfaceMap instanceof ImageMap) {
            object3 = ((ImageMap)surfaceMap).getImageAdapter();
            bufferedImage = object3.getBufferedImage();
            object2 = object3.getProvider();
            object = ((Item)object2).getAbsoluteName();
            object = ((String)object).substring(((String)object).lastIndexOf("/") + 1, ((String)object).length());
            string2 = (String)object + "." + string;
        } else {
            bufferedImage = new BufferedImage(n, n, 2);
            surfaceMap.drawImage(bufferedImage, 1, false);
        }
        if (bufferedImage != null) {
            int n2 = 512;
            BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
            BufferedImage bufferedImage3 = new BufferedImage(n2, n2, 2);
            BufferedImage bufferedImage4 = new BufferedImage(n2, n2, 2);
            BufferedImage bufferedImage5 = new BufferedImage(n2, n2, 2);
            BufferedImage bufferedImage6 = new BufferedImage(n2, n2, 2);
            BufferedImage bufferedImage7 = new BufferedImage(n2, n2, 2);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage3, 0.0, 0.0);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage4, 1.5707963267948966, 0.0);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage5, Math.PI, 0.0);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage6, 4.71238898038469, 0.0);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage2, 4.71238898038469, -1.5707963267948966);
            x3DExport.increaseProgress();
            this.calcGnomonic(bufferedImage, bufferedImage7, 1.5707963267948966, 1.5707963267948966);
            x3DExport.increaseProgress();
            try {
                object3 = (File)x3DExport.getFile(string2);
                object2 = (File)x3DExport.getFile(string2);
                object = (File)x3DExport.getFile(string2);
                File file = (File)x3DExport.getFile(string2);
                File file2 = (File)x3DExport.getFile(string2);
                File file3 = (File)x3DExport.getFile(string2);
                ImageIO.write((RenderedImage)bufferedImage2, string, (File)object3);
                ImageIO.write((RenderedImage)bufferedImage3, string, (File)object2);
                ImageIO.write((RenderedImage)bufferedImage4, string, (File)object);
                ImageIO.write((RenderedImage)bufferedImage5, string, file);
                ImageIO.write((RenderedImage)bufferedImage6, string, file2);
                ImageIO.write((RenderedImage)bufferedImage7, string, file3);
                background.setTopUrl((List)new ObjectList((Object[])new String[]{((File)object3).getName()}));
                background.setRightUrl((List)new ObjectList((Object[])new String[]{((File)object2).getName()}));
                background.setBackUrl((List)new ObjectList((Object[])new String[]{((File)object).getName()}));
                background.setLeftUrl((List)new ObjectList((Object[])new String[]{file.getName()}));
                background.setFrontUrl((List)new ObjectList((Object[])new String[]{file2.getName()}));
                background.setBottomUrl((List)new ObjectList((Object[])new String[]{file3.getName()}));
            }
            catch (IOException iOException) {
                System.err.println("Couldn't write background image files for x3d export.");
            }
        }
    }

    private void calcGnomonic(BufferedImage bufferedImage, BufferedImage bufferedImage2, double d, double d2) {
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d3 = (double)i / (double)(n - 1);
                d3 = 2.0 * d3 - 1.0;
                double d4 = (double)j / (double)(n2 - 1);
                d4 = 2.0 * d4 - 1.0;
                double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                double d6 = Math.atan(d5);
                double d7 = 0.0;
                double d8 = 0.0;
                if (d5 != 0.0) {
                    d8 = Math.asin(Math.cos(d6) * Math.sin(d2) + d4 * Math.sin(d6) * Math.cos(d2) / d5);
                    d7 = d + Math.atan(d3 * Math.sin(d6) / (d5 * Math.cos(d2) * Math.cos(d6) - d4 * Math.sin(d2) * Math.sin(d6)));
                }
                if (d2 == 1.5707963267948966 && d4 <= 0.0) {
                    d7 += Math.PI;
                }
                if (d2 == -1.5707963267948966 && d4 <= 0.0) {
                    d7 += Math.PI;
                }
                if (d7 < 0.0) {
                    d7 += Math.PI * 2;
                }
                if (d7 > Math.PI * 2) {
                    d7 -= Math.PI * 2;
                }
                double d9 = d7 / (Math.PI * 2);
                double d10 = (d8 + 1.5707963267948966) / Math.PI;
                int n3 = bufferedImage.getRGB((int)Math.round(d9 * (double)(bufferedImage.getWidth() - 1)), (int)Math.round(d10 * (double)(bufferedImage.getHeight() - 1)));
                bufferedImage2.setRGB(i, j, n3);
            }
        }
    }
}

