/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.importation.ImageTextureImport;
import de.grogra.ext.x3d.importation.MaterialImport;
import de.grogra.ext.x3d.importation.TextureTransformImport;
import de.grogra.ext.x3d.xmlbeans.AppearanceDocument;
import de.grogra.ext.x3d.xmlbeans.ImageTextureDocument;
import de.grogra.ext.x3d.xmlbeans.MaterialDocument;
import de.grogra.ext.x3d.xmlbeans.TextureTransformDocument;
import de.grogra.graph.impl.Node;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Phong;
import de.grogra.math.ChannelMap;
import java.util.HashMap;

public class AppearanceImport {
    public static Phong createInstance(AppearanceDocument.Appearance appearance) {
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        Phong phong = null;
        if (appearance.isSetUSE()) {
            try {
                phong = (Phong)((Node)hashMap.get(appearance.getUSE())).clone(true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            phong = new Phong();
            AppearanceImport.setValues(phong, appearance);
            if (appearance.isSetDEF()) {
                hashMap.put(appearance.getDEF(), phong);
            }
        }
        return phong;
    }

    private static void setValues(Phong phong, AppearanceDocument.Appearance appearance) {
        ImageMap imageMap;
        Phong phong2;
        if (appearance.getMaterialArray().length > 0) {
            phong2 = AppearanceImport.handleMaterial(appearance.getMaterialArray(0));
            phong.setAmbient(phong2.getAmbient());
            phong.setDiffuse(phong2.getDiffuse());
            phong.setEmissive(phong2.getEmissive());
            phong.setShininess(phong2.getShininess());
            phong.setSpecular(phong2.getSpecular());
            phong.setTransparency(phong2.getTransparency());
        }
        if (appearance.getImageTextureArray().length > 0) {
            phong2 = AppearanceImport.handleImageTexture(appearance.getImageTextureArray(0));
            imageMap = new ImageMap();
            imageMap.setImageAdapter((ImageAdapter)phong2);
            phong.setDiffuse((ChannelMap)imageMap);
        }
        if (appearance.getTextureTransformArray().length > 0) {
            phong2 = AppearanceImport.handleTextureTransform(appearance.getTextureTransformArray(0));
            if (phong.getDiffuse() instanceof ImageMap) {
                imageMap = (ImageMap)phong.getDiffuse();
                imageMap.setInput((ChannelMap)phong2);
            }
        }
    }

    private static Phong handleMaterial(MaterialDocument.Material material) {
        Phong phong = MaterialImport.createInstance(material);
        return phong;
    }

    private static ImageAdapter handleImageTexture(ImageTextureDocument.ImageTexture imageTexture) {
        ImageAdapter imageAdapter = ImageTextureImport.createInstance(imageTexture);
        return imageAdapter;
    }

    private static AffineUVTransformation handleTextureTransform(TextureTransformDocument.TextureTransform textureTransform) {
        AffineUVTransformation affineUVTransformation = TextureTransformImport.createInstance(textureTransform);
        return affineUVTransformation;
    }
}

