/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.util;

import de.grogra.ext.x3d.util.Util;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.util.ArrayList;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtrusionComputation {
    private final IntList coordIndexList;
    private final FloatList vertexList;
    private final FloatList normalList;
    private final FloatList uvList;
    private final float[] crossSection;
    private final boolean ccw;
    private final boolean isCrossSectionClosed;
    private final boolean isSpineClosed;
    private final int spineLength;
    private final int crossSectionLength;
    private final int spineCount;

    public ExtrusionComputation(IntList intList, FloatList floatList, FloatList floatList2, FloatList floatList3, float[] fArray, float[] fArray2, boolean bl) {
        this.coordIndexList = intList;
        this.vertexList = floatList;
        this.normalList = floatList2;
        this.uvList = floatList3;
        this.crossSection = fArray;
        this.ccw = bl;
        this.crossSectionLength = fArray.length;
        this.spineLength = fArray2.length;
        this.spineCount = this.spineLength / 3;
        this.isCrossSectionClosed = fArray[0] == fArray[this.crossSectionLength - 2] && fArray[1] == fArray[this.crossSectionLength - 1];
        this.isSpineClosed = fArray2[0] == fArray2[this.spineLength - 3] && fArray2[1] == fArray2[this.spineLength - 2] && fArray2[2] == fArray2[this.spineLength - 1];
    }

    public void createCrossSections(float[] fArray, float[] fArray2, float[] fArray3, ArrayList<CrossSection> arrayList, boolean bl) {
        Vector3d vector3d = null;
        for (int i = 0; i < this.spineCount; ++i) {
            CrossSection crossSection = new CrossSection();
            ArrayList<Point3f> arrayList2 = new ArrayList<Point3f>();
            for (int j = 0; j < this.crossSectionLength; j += 2) {
                Matrix4d matrix4d;
                Matrix4d matrix4d2;
                AxisAngle4d axisAngle4d;
                Point3f point3f = new Point3f(this.crossSection[j], this.crossSection[j + 1], 0.0f);
                point3f.x *= fArray[i * 2 + 0];
                point3f.y *= fArray[i * 2 + 1];
                Vector3d vector3d2 = null;
                Vector3d vector3d3 = null;
                if (bl) {
                    axisAngle4d = new AxisAngle4d((double)fArray2[i * 4 + 0], (double)fArray2[i * 4 + 1], (double)fArray2[i * 4 + 2], (double)fArray2[i * 4 + 3]);
                    matrix4d2 = new Matrix4d();
                    matrix4d2.setIdentity();
                    matrix4d2.set(axisAngle4d);
                    matrix4d2.transform(point3f);
                    vector3d2 = new Vector3d((double)(fArray3[this.spineLength - 3] - fArray3[0]), (double)(fArray3[this.spineLength - 2] - fArray3[1]), (double)(fArray3[this.spineLength - 1] - fArray3[2]));
                    matrix4d = Util.vectorsToTransMatrix(new Vector3d(0.0, 0.0, 1.0), vector3d2);
                    matrix4d.transform(point3f);
                } else {
                    Vector3d vector3d4;
                    axisAngle4d = new AxisAngle4d((double)fArray2[i * 4 + 0], (double)fArray2[i * 4 + 1], (double)fArray2[i * 4 + 2], (double)(-fArray2[i * 4 + 3]));
                    matrix4d2 = new Matrix4d();
                    matrix4d2.setIdentity();
                    matrix4d2.set(axisAngle4d);
                    matrix4d2.transform(point3f);
                    if (i == 0) {
                        if (this.isSpineClosed) {
                            vector3d2 = new Vector3d((double)(fArray3[3] - fArray3[this.spineLength - 6]), (double)(fArray3[4] - fArray3[this.spineLength - 5]), (double)(fArray3[5] - fArray3[this.spineLength - 4]));
                            vector3d3 = new Vector3d();
                            matrix4d = new Vector3d((double)(fArray3[3] - fArray3[0]), (double)(fArray3[4] - fArray3[1]), (double)(fArray3[5] - fArray3[2]));
                            vector3d4 = new Vector3d((double)(fArray3[this.spineLength - 6] - fArray3[0]), (double)(fArray3[this.spineLength - 5] - fArray3[1]), (double)(fArray3[this.spineLength - 4] - fArray3[2]));
                            vector3d3.cross((Vector3d)matrix4d, vector3d4);
                        } else {
                            vector3d2 = new Vector3d((double)(fArray3[3] - fArray3[0]), (double)(fArray3[4] - fArray3[1]), (double)(fArray3[5] - fArray3[2]));
                            vector3d3 = new Vector3d();
                            matrix4d = new Vector3d((double)(fArray3[0] - fArray3[3]), (double)(fArray3[1] - fArray3[4]), (double)(fArray3[2] - fArray3[5]));
                            vector3d4 = new Vector3d((double)(fArray3[6] - fArray3[3]), (double)(fArray3[7] - fArray3[4]), (double)(fArray3[8] - fArray3[5]));
                            vector3d3.cross(vector3d4, (Vector3d)matrix4d);
                        }
                        int n = 0;
                        while (vector3d3.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0))) {
                            vector3d4 = new Vector3d((double)(fArray3[++n * 3 + 3] - fArray3[n * 3 + 0]), (double)(fArray3[n * 3 + 4] - fArray3[n * 3 + 1]), (double)(fArray3[n * 3 + 5] - fArray3[n * 3 + 2]));
                            Vector3d vector3d5 = new Vector3d((double)(fArray3[n * 3 - 3] - fArray3[n * 3 + 0]), (double)(fArray3[n * 3 - 2] - fArray3[n * 3 + 1]), (double)(fArray3[n * 3 - 1] - fArray3[n * 3 + 2]));
                            vector3d3.cross(vector3d4, vector3d5);
                        }
                    } else if (i == this.spineCount - 1) {
                        if (this.isSpineClosed) {
                            vector3d2 = new Vector3d((double)(fArray3[3] - fArray3[this.spineLength - 6]), (double)(fArray3[4] - fArray3[this.spineLength - 5]), (double)(fArray3[5] - fArray3[this.spineLength - 4]));
                            vector3d3 = new Vector3d();
                            matrix4d = new Vector3d((double)(fArray3[3] - fArray3[0]), (double)(fArray3[4] - fArray3[1]), (double)(fArray3[5] - fArray3[2]));
                            vector3d4 = new Vector3d((double)(fArray3[this.spineLength - 6] - fArray3[0]), (double)(fArray3[this.spineLength - 5] - fArray3[1]), (double)(fArray3[this.spineLength - 4] - fArray3[2]));
                            vector3d3.cross((Vector3d)matrix4d, vector3d4);
                        } else {
                            vector3d2 = new Vector3d((double)(fArray3[this.spineLength - 3] - fArray3[this.spineLength - 6]), (double)(fArray3[this.spineLength - 2] - fArray3[this.spineLength - 5]), (double)(fArray3[this.spineLength - 1] - fArray3[this.spineLength - 4]));
                            vector3d3 = new Vector3d();
                            matrix4d = new Vector3d((double)(fArray3[this.spineLength - 3] - fArray3[this.spineLength - 6]), (double)(fArray3[this.spineLength - 2] - fArray3[this.spineLength - 5]), (double)(fArray3[this.spineLength - 1] - fArray3[this.spineLength - 4]));
                            vector3d4 = new Vector3d((double)(fArray3[this.spineLength - 9] - fArray3[this.spineLength - 6]), (double)(fArray3[this.spineLength - 8] - fArray3[this.spineLength - 5]), (double)(fArray3[this.spineLength - 7] - fArray3[this.spineLength - 4]));
                            vector3d3.cross((Vector3d)matrix4d, vector3d4);
                        }
                    } else {
                        vector3d2 = new Vector3d((double)(fArray3[i * 3 + 3] - fArray3[i * 3 - 3]), (double)(fArray3[i * 3 + 4] - fArray3[i * 3 - 2]), (double)(fArray3[i * 3 + 5] - fArray3[i * 3 - 1]));
                        vector3d3 = new Vector3d();
                        matrix4d = new Vector3d((double)(fArray3[i * 3 + 3] - fArray3[i * 3 + 0]), (double)(fArray3[i * 3 + 4] - fArray3[i * 3 + 1]), (double)(fArray3[i * 3 + 5] - fArray3[i * 3 + 2]));
                        vector3d4 = new Vector3d((double)(fArray3[i * 3 - 3] - fArray3[i * 3 + 0]), (double)(fArray3[i * 3 - 2] - fArray3[i * 3 + 1]), (double)(fArray3[i * 3 - 1] - fArray3[i * 3 + 2]));
                        vector3d3.cross((Vector3d)matrix4d, vector3d4);
                    }
                    vector3d2.normalize();
                    if (vector3d3.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0))) {
                        vector3d3 = vector3d;
                    } else {
                        vector3d3.normalize();
                    }
                    if (vector3d == null) {
                        vector3d = new Vector3d();
                    } else {
                        double d = vector3d3.dot(vector3d);
                        if (d < 0.0) {
                            vector3d3.negate();
                        }
                    }
                    vector3d = vector3d3;
                    matrix4d = new Vector3d();
                    matrix4d.cross(vector3d2, vector3d3);
                    matrix4d.normalize();
                    vector3d4 = new Matrix4d();
                    vector3d4.setIdentity();
                    vector3d4.setColumn(0, matrix4d.x, matrix4d.y, matrix4d.z, 0.0);
                    vector3d4.setColumn(1, vector3d3.x, vector3d3.y, vector3d3.z, 0.0);
                    vector3d4.setColumn(2, vector3d2.x, vector3d2.y, vector3d2.z, 0.0);
                    vector3d4.transform(point3f);
                }
                point3f.x += fArray3[i * 3 + 0];
                point3f.y += fArray3[i * 3 + 1];
                point3f.z += fArray3[i * 3 + 2];
                arrayList2.add(point3f);
            }
            crossSection.setVertices(arrayList2);
            arrayList.add(crossSection);
        }
    }

    public int createCap(int n, ArrayList<Point3f> arrayList, boolean bl) {
        int n2;
        int n3 = arrayList.size() - (this.isCrossSectionClosed ? 2 : 1);
        Vector3f vector3f = new Vector3f(arrayList.get((int)0).x - arrayList.get((int)1).x, arrayList.get((int)0).y - arrayList.get((int)1).y, arrayList.get((int)0).z - arrayList.get((int)1).z);
        Vector3f vector3f2 = new Vector3f(arrayList.get((int)2).x - arrayList.get((int)1).x, arrayList.get((int)2).y - arrayList.get((int)1).y, arrayList.get((int)2).z - arrayList.get((int)1).z);
        Vector3f vector3f3 = new Vector3f();
        if (bl ^ !this.ccw) {
            vector3f3.cross(vector3f, vector3f2);
        } else {
            vector3f3.cross(vector3f2, vector3f);
        }
        vector3f3.normalize();
        float f = this.crossSection[0];
        float f2 = this.crossSection[1];
        float f3 = this.crossSection[0];
        float f4 = this.crossSection[1];
        for (n2 = 1; n2 < n3; ++n2) {
            float f5 = this.crossSection[2 * n2];
            float f6 = this.crossSection[2 * n2 + 1];
            f = Math.min(f, f5);
            f2 = Math.min(f2, f6);
            f3 = Math.max(f3, f5);
            f4 = Math.max(f4, f6);
        }
        for (n2 = 1; n2 < n3; ++n2) {
            this.coordIndexList.add(n + 0);
            this.coordIndexList.add(n + (this.ccw ? 1 : 2));
            this.coordIndexList.add(n + (this.ccw ? 2 : 1));
            n += 3;
            this.vertexList.add(arrayList.get((int)0).x);
            this.vertexList.add(arrayList.get((int)0).y);
            this.vertexList.add(arrayList.get((int)0).z);
            this.normalList.add(vector3f3.x);
            this.normalList.add(vector3f3.y);
            this.normalList.add(vector3f3.z);
            this.uvList.add((this.crossSection[0] - f) / (f3 - f));
            this.uvList.add((this.crossSection[1] - f2) / (f4 - f2));
            int n4 = n2 + (bl ? 1 : 0);
            this.vertexList.add(arrayList.get((int)n4).x);
            this.vertexList.add(arrayList.get((int)n4).y);
            this.vertexList.add(arrayList.get((int)n4).z);
            this.normalList.add(vector3f3.x);
            this.normalList.add(vector3f3.y);
            this.normalList.add(vector3f3.z);
            this.uvList.add((this.crossSection[2 * n4 + 0] - f) / (f3 - f));
            this.uvList.add((this.crossSection[2 * n4 + 1] - f2) / (f4 - f2));
            n4 = n2 + (bl ? 0 : 1);
            this.vertexList.add(arrayList.get((int)n4).x);
            this.vertexList.add(arrayList.get((int)n4).y);
            this.vertexList.add(arrayList.get((int)n4).z);
            this.normalList.add(vector3f3.x);
            this.normalList.add(vector3f3.y);
            this.normalList.add(vector3f3.z);
            this.uvList.add((this.crossSection[2 * n4 + 0] - f) / (f3 - f));
            this.uvList.add((this.crossSection[2 * n4 + 1] - f2) / (f4 - f2));
        }
        return n;
    }

    public int createSides(ArrayList<CrossSection> arrayList, int n) {
        for (int i = 0; i < this.spineCount - 1; ++i) {
            ArrayList<Point3f> arrayList2 = arrayList.get(i + 0).getVertices();
            ArrayList<Point3f> arrayList3 = arrayList.get(i + 1).getVertices();
            int n2 = arrayList2.size() - 1;
            for (int j = 0; j < n2; ++j) {
                Vector3f vector3f = new Vector3f(arrayList2.get((int)(j + 1)).x - arrayList2.get((int)j).x, arrayList2.get((int)(j + 1)).y - arrayList2.get((int)j).y, arrayList2.get((int)(j + 1)).z - arrayList2.get((int)j).z);
                Vector3f vector3f2 = new Vector3f(arrayList3.get((int)j).x - arrayList2.get((int)j).x, arrayList3.get((int)j).y - arrayList2.get((int)j).y, arrayList3.get((int)j).z - arrayList2.get((int)j).z);
                Vector3f vector3f3 = new Vector3f();
                if (this.ccw) {
                    vector3f3.cross(vector3f, vector3f2);
                } else {
                    vector3f3.cross(vector3f2, vector3f);
                }
                vector3f3.normalize();
                float f = n2;
                float f2 = this.spineCount - 1;
                this.coordIndexList.add(n + 0);
                this.coordIndexList.add(n + (this.ccw ? 1 : 2));
                this.coordIndexList.add(n + (this.ccw ? 2 : 1));
                this.coordIndexList.add(n + 3);
                this.coordIndexList.add(n + (this.ccw ? 4 : 5));
                this.coordIndexList.add(n + (this.ccw ? 5 : 4));
                n += 6;
                this.vertexList.add(arrayList2.get((int)j).x);
                this.vertexList.add(arrayList2.get((int)j).y);
                this.vertexList.add(arrayList2.get((int)j).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 0) / f);
                this.uvList.add((float)(i + 0) / f2);
                this.vertexList.add(arrayList2.get((int)(j + 1)).x);
                this.vertexList.add(arrayList2.get((int)(j + 1)).y);
                this.vertexList.add(arrayList2.get((int)(j + 1)).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 1) / f);
                this.uvList.add((float)(i + 0) / f2);
                this.vertexList.add(arrayList3.get((int)j).x);
                this.vertexList.add(arrayList3.get((int)j).y);
                this.vertexList.add(arrayList3.get((int)j).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 0) / f);
                this.uvList.add((float)(i + 1) / f2);
                this.vertexList.add(arrayList2.get((int)(j + 1)).x);
                this.vertexList.add(arrayList2.get((int)(j + 1)).y);
                this.vertexList.add(arrayList2.get((int)(j + 1)).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 1) / f);
                this.uvList.add((float)(i + 0) / f2);
                this.vertexList.add(arrayList3.get((int)(j + 1)).x);
                this.vertexList.add(arrayList3.get((int)(j + 1)).y);
                this.vertexList.add(arrayList3.get((int)(j + 1)).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 1) / f);
                this.uvList.add((float)(i + 1) / f2);
                this.vertexList.add(arrayList3.get((int)j).x);
                this.vertexList.add(arrayList3.get((int)j).y);
                this.vertexList.add(arrayList3.get((int)j).z);
                this.normalList.add(vector3f3.x);
                this.normalList.add(vector3f3.y);
                this.normalList.add(vector3f3.z);
                this.uvList.add((float)(j + 0) / f);
                this.uvList.add((float)(i + 1) / f2);
            }
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CrossSection {
        protected ArrayList<Point3f> vertices = new ArrayList();

        public ArrayList<Point3f> getVertices() {
            return this.vertices;
        }

        public void setVertices(ArrayList<Point3f> arrayList) {
            this.vertices = arrayList;
        }
    }
}

