/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.imp3d.View3D;
import de.grogra.math.TMatrix4d;
import de.grogra.math.TVector3d;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class RotationCamera {
    private Camera camera;
    private View3D view3d;
    private TVector3d rotationPoint = new TVector3d(0.0, 0.0, 0.0);
    private TMatrix4d initMatrix4d;

    public RotationCamera() {
        this.view3d = View3D.getDefaultView((Context)Workbench.current());
        this.camera = this.view3d.getCamera();
        this.initMatrix4d = new TMatrix4d();
        this.initMatrix4d.m00 = 1.0;
        this.initMatrix4d.m12 = 1.0;
        this.initMatrix4d.m11 = 0.0;
        this.initMatrix4d.m22 = 0.0;
        this.initMatrix4d.m21 = -1.0;
        this.initMatrix4d.m03 = 0.0;
        this.initMatrix4d.m13 = 0.0;
        this.initMatrix4d.m23 = 0.0;
        this.initMatrix4d.m33 = 1.0;
        this.camera.setTransformation((Matrix4d)new TMatrix4d((Matrix4d)this.initMatrix4d));
    }

    public void setDistance(double d, double d2) {
        this.initMatrix4d.m13 = -d2;
        this.initMatrix4d.m23 = -d;
        this.camera.setTransformation((Matrix4d)this.initMatrix4d);
    }

    public TMatrix4d calculateMatrix(double d) {
        if (d == 0.0) {
            return this.initMatrix4d;
        }
        Quat4d quat4d = new Quat4d();
        TMatrix4d tMatrix4d = new TMatrix4d();
        TMatrix4d tMatrix4d2 = new TMatrix4d((Matrix4d)this.initMatrix4d);
        quat4d.set(new AxisAngle4d(0.0, 0.0, 1.0, Math.toRadians(d)));
        tMatrix4d.set(quat4d, (Vector3d)this.rotationPoint, 1.0);
        tMatrix4d2.mul((Matrix4d)tMatrix4d2, (Matrix4d)tMatrix4d);
        return tMatrix4d2;
    }

    public void moveAroundZ(double d) {
        this.camera.setTransformation((Matrix4d)this.calculateMatrix(d));
    }

    public void makeParallel() {
        this.camera.setProjection((Projection)new ParallelProjection());
    }

    public void makePerspective() {
        this.camera.setProjection((Projection)new PerspectiveProjection());
    }

    public View3D getView3D() {
        return this.view3d;
    }

    public void lookUpAndDown(double d) {
        TMatrix4d tMatrix4d = new TMatrix4d(this.camera.getTransformation());
        TMatrix4d tMatrix4d2 = new TMatrix4d();
        tMatrix4d2.rotX(Math.toRadians(d));
        tMatrix4d.mul((Matrix4d)tMatrix4d, (Matrix4d)tMatrix4d2);
        this.camera.setTransformation((Matrix4d)tMatrix4d);
    }
}

