/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard.vrml;

import de.grogra.billboard.BBResources;
import de.grogra.billboard.GridBillboarder;
import de.grogra.billboard.vrml.VRMLBuilder;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.MimeType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class VRMLGridBuilder
extends GridBillboarder
implements VRMLBuilder {
    protected String vrmlFileName = "bb";
    private String vrmlTempl = "";
    protected File vrmlDest;

    public VRMLGridBuilder(File file, MimeType mimeType) {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        this.imageFolder = "";
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmlgridtempl.txt");
    }

    public VRMLGridBuilder(File file, MimeType mimeType, String string) throws IOException {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        file = new File(file.getPath() + File.separator + string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.imageFolder = string;
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmlgridtempl.txt");
    }

    public void writeVRML(int n, int n2) {
        int n3;
        if (this.currentSide == 0) {
            this.makeAllNames();
        }
        String string = this.vrmlTempl;
        String string2 = "";
        String string3 = "";
        String string4 = System.getProperty("line.separator");
        double d = (double)n2 / (double)n;
        String string5 = "\t\t\tShape { " + string4 + "\t\t\t\tappearance Appearance {" + string4 + "\t\t\t\t\ttexture ImageTexture { url IS url }" + string4 + "\t\t\t\t}" + string4 + "\t\t\t\tgeometry IndexedFaceSet {" + string4 + "\t\t\t\t\tcoord Coordinate { point [ ::START_X:: ::REL_HEIGHT:: 0, ::END_X:: ::REL_HEIGHT:: 0, ::END_X:: 0 0, ::START_X:: 0 0 ] }" + string4 + "\t\t\t\t\tcoordIndex [ 0 1 2 3 -1 ]" + string4 + "\t\t\t\t\ttexCoord TextureCoordinate { point [ ::TEXT_START_X:: 1, ::TEXT_END_X:: 1 , ::TEXT_END_X:: 0, ::TEXT_START_X:: 0 ] }" + string4 + "\t\t\t\t}" + string4 + "\t\t\t}";
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n4 = n3 = this.steps % 2 == 0 ? this.steps : this.steps - 1;
        for (int i = 0; i < this.steps * this.sides; ++i) {
            d6 = 1.0 / (double)n3 * (double)(i % this.steps) - 0.5;
            d6 = (double)Math.round(d6 * 100.0) / 100.0;
            if (i < n3) {
                d2 = d6;
                d3 = d2 + 1.0 / (double)n3;
                d4 = 1.0 / (double)n3 * (double)i;
                d5 = 1.0 / (double)n3 * (double)(i + 1);
                string3 = string3 + string5.replaceAll("::START_X::", Double.toString(d2)) + string4;
                string3 = string3.replaceAll("::END_X::", Double.toString(d3));
                string3 = string3.replaceAll("::TEXT_START_X::", Double.toString(d4));
                string3 = string3.replaceAll("::TEXT_END_X::", Double.toString(d5));
                string3 = string3.replaceAll("::REL_HEIGHT::", Double.toString(d));
            }
            if (i % this.steps == 0) {
                string2 = string2 + "Transform { " + string4 + "\trotation 0 1 0 " + d7 + string4 + "\tchildren [" + string4;
                d7 -= 1.5707963267948966;
            }
            string2 = string2 + "\t\tPngFrame { url \"" + this.getBBName(i) + "\" trans 0 0 " + -(d6 / 2.0) + "}" + string4;
            if ((i + 1) % this.steps != 0) continue;
            string2 = string2 + "\t]" + string4 + "}" + string4;
        }
        string = string.replaceAll("::PROTO_DEFINE::", string3);
        string = string.replaceAll("::PNG_PROTO_CALL::", string2);
        string = string.replaceAll("::BILL_NUM::", Integer.toString(this.sides));
        try {
            FileWriter fileWriter = new FileWriter(this.vrmlDest);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Workbench.current().logGUIInfo("Error: " + iOException.getMessage());
        }
    }

    protected void finalAction() {
        this.writeVRML(this.imgWidth, this.imgHeight);
    }
}

