/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidCheckBoxIcon;
import com.birosoft.liquid.LiquidComboBoxButton;
import com.birosoft.liquid.LiquidComboBoxEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class LiquidComboBoxUI
extends BasicComboBoxUI {
    static int comboBoxButtonSize = 18;
    private int prevSelectedItem;

    public static ComponentUI createUI(final JComponent jComponent) {
        jComponent.setOpaque(false);
        jComponent.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jComponent.setOpaque(false);
            }
        });
        return new LiquidComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.addKeyboardActions((JComboBox)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ComboBoxEditor createEditor() {
        return new LiquidComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new LiquidComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        LiquidComboBoxButton liquidComboBoxButton = new LiquidComboBoxButton(this.comboBox, new LiquidCheckBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        liquidComboBoxButton.setMargin(new Insets(0, 0, 0, 0));
        liquidComboBoxButton.setFocusable(false);
        return liquidComboBoxButton;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new LiquidPropertyChangeListener();
    }

    private void addKeyboardActions(final JComboBox jComboBox) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiquidComboBoxUI.this.prevSelectedItem = jComboBox.getSelectedIndex();
                if (jComboBox.isPopupVisible()) {
                    jComboBox.hidePopup();
                } else {
                    jComboBox.showPopup();
                }
            }
        }, keyStroke, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jComboBox.hidePopup();
                jComboBox.setSelectedIndex(LiquidComboBoxUI.this.prevSelectedItem);
            }
        }, keyStroke2, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(40, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jComboBox.isPopupVisible()) {
                    jComboBox.showPopup();
                    return;
                }
                if (jComboBox.getSelectedIndex() <= jComboBox.getItemCount() - 2) {
                    jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() + 1);
                } else if (jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                    jComboBox.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, keyStroke3, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getSelectedIndex() <= jComboBox.getItemCount() - 2) {
                    jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() + 1);
                } else if (jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                    jComboBox.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, keyStroke4, 0);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(38, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getSelectedIndex() > 0) {
                    jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() - 1);
                } else if (jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                    jComboBox.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, keyStroke5, 0);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(37, 0);
        jComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getSelectedIndex() > 0) {
                    jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() - 1);
                } else if (jComboBox.getSelectedIndex() == -1 && jComboBox.getItemCount() > 0) {
                    jComboBox.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, keyStroke6, 0);
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected LayoutManager createLayoutManager() {
        return new MetouiaComboBoxLayoutManager();
    }

    protected Rectangle rectangleForCurrentValue2() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = comboBoxButtonSize;
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left + 8, insets.top, n - (insets.left + insets.right + n3) - 7, n2 - (insets.top + insets.bottom) - 2);
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (jComponent == null) {
            return new Dimension();
        }
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof LiquidComboBoxButton) {
            LiquidComboBoxButton liquidComboBoxButton = (LiquidComboBoxButton)this.arrowButton;
            Insets insets = new Insets(0, 0, 0, 0);
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += comboBoxButtonSize + insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + liquidComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
            dimension.height = Math.max(21, dimension.height);
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            if (this.editor instanceof JComponent) {
                Insets insets4 = ((JComponent)this.editor).getInsets();
            }
            dimension.height += insets.top + insets.bottom;
            dimension.height += insets3.top + insets3.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class LiquidComboPopup
    extends BasicComboPopup {
        public LiquidComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            super.delegateFocus(mouseEvent);
        }
    }

    public class MetouiaComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            if (LiquidComboBoxUI.this.comboBox.isEditable()) {
                if (LiquidComboBoxUI.this.arrowButton != null) {
                    LiquidComboBoxUI.this.arrowButton.setBounds(0, 0, n, n2);
                }
                if (LiquidComboBoxUI.this.editor != null) {
                    Rectangle rectangle = LiquidComboBoxUI.this.rectangleForCurrentValue2();
                    LiquidComboBoxUI.this.editor.setBounds(rectangle);
                }
            } else {
                LiquidComboBoxUI.this.arrowButton.setBounds(0, 0, n, n2);
            }
        }
    }

    public class LiquidPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public LiquidPropertyChangeListener() {
            super(LiquidComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                LiquidComboBoxButton liquidComboBoxButton = (LiquidComboBoxButton)LiquidComboBoxUI.this.arrowButton;
                liquidComboBoxButton.setIconOnly(LiquidComboBoxUI.this.comboBox.isEditable());
                LiquidComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                LiquidComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                LiquidComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

