/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.LiquidWindowButtonUI;
import com.birosoft.liquid.SpecialUIButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class LiquidInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager {
    static LiquidWindowButtonUI iconButtonUI;
    static LiquidWindowButtonUI maxButtonUI;
    static LiquidWindowButtonUI closeButtonUI;
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    Color normalTitleColor = Color.white;
    Color shadowColor = new Color(10, 24, 131);
    Color disabledTitleColor = new Color(64, 63, 63);
    protected int frameTitleHeight;
    private int buttonsWidth;

    public LiquidInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.frameTitleHeight = UIManager.getInt("InternalFrame.frameTitleHeight");
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void paintTitleBackground(Graphics graphics) {
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.frame.isSelected();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = LiquidLookAndFeel.getWindowTitleInactiveForeground();
        if (LiquidLookAndFeel.winDecoPanther) {
            this.drawPantherCaption(graphics, bl2, n, n2);
        } else {
            this.drawLiquidCaption(graphics, bl2, n, n2);
        }
        int n3 = 0;
        int n4 = bl ? 2 : n - 2;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n4 -= icon.getIconWidth();
            }
            int n5 = n2 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n4, n5);
            n4 += bl ? icon.getIconWidth() + 2 : -2;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.stringWidth(string);
            if (this.isPalette) {
                if (bl2) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
                int n6 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
                if (!bl) {
                    n4 -= n3;
                }
                graphics.drawString(string, n4, n6);
                n4 += bl ? n3 + 2 : -2;
            } else {
                int n7 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
                if (!bl) {
                    n4 -= n3;
                }
                n4 = n / 2 - n3 / 2;
                if (bl2) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (!LiquidLookAndFeel.winDecoPanther) {
                        GradientPaint gradientPaint = new GradientPaint(n4 + n3 / 2, n7 - 15, new Color(60, 144, 233), n4 + n3 / 2, fontMetrics.getHeight() + 6, new Color(102, 186, 255));
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.fillRoundRect(n4 - 8, n7 - 15, n3 + 15, n2 - 6, 18, 18);
                        graphics.setColor(new Color(0, 78, 167));
                        graphics2D.drawRoundRect(n4 - 8, n7 - 15, n3 + 15, n2 - 6, 18, 18);
                    }
                    graphics.setColor(Color.black);
                    if (!LiquidLookAndFeel.winDecoPanther) {
                        graphics.drawString(string, n4 + 1, n7);
                        graphics.setColor(this.normalTitleColor);
                    }
                    graphics.drawString(string, n4, n7 - 1);
                    n4 += bl ? n3 + 2 : -2;
                } else {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    GradientPaint gradientPaint = new GradientPaint(n4 + n3 / 2, n7 - 15, new Color(191, 211, 233), n4 + n3 / 2, fontMetrics.getHeight() + 6, new Color(233, 253, 255));
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRoundRect(n4 - 8, n7 - 15, n3 + 15, n2 - 6, 18, 18);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.setColor(new Color(125, 145, 167));
                    graphics2D.drawRoundRect(n4 - 8, n7 - 15, n3 + 15, n2 - 6, 18, 18);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, n4, n7 - 1);
                    n4 += bl ? n3 + 2 : -2;
                }
            }
        }
    }

    private void drawLiquidCaption(Graphics graphics, boolean bl, int n, int n2) {
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2 - 1);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n, 0);
        color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
        graphics.setColor(color);
        graphics.drawLine(0, 1, n, 1);
        for (int i = 4; i < n2 - 1; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(0, i, n, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(0, i + 1, n, i + 1);
        }
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private void drawPantherCaption(Graphics graphics, boolean bl, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = bl ? new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, n2 - 1, new Color(192, 192, 192)) : new GradientPaint(0.0f, 0.0f, new Color(230, 230, 230), 0.0f, n2 - 1, new Color(202, 202, 202));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2 - 1);
        graphics2D.setColor(new Color(198, 198, 198));
        graphics2D.drawLine(0, 0, n - 1, 0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(0, 1, n - 1, 1);
        graphics2D.setColor(new Color(147, 147, 147));
        graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        if (this.menuBar != null) {
            // empty if block
        }
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = LiquidWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = LiquidWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = LiquidWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton((ButtonUI)iconButtonUI, this.frame);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton, this.iconifyAction));
        this.maxButton = new SpecialUIButton((ButtonUI)maxButtonUI, this.frame);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton, this.maximizeAction));
        this.closeButton = new SpecialUIButton((ButtonUI)closeButtonUI, this.frame);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton, this.closeAction));
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics graphics) {
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container);
    }

    public Dimension getPreferredSize(Container container) {
        return new Dimension(container.getSize().width, this.isPalette ? this.paletteTitleHeight : this.frameTitleHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(70, 25);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        int n2 = this.closeButton.getPreferredSize().height;
        int n3 = this.getWidth();
        int n4 = bl ? n3 : 0;
        int n5 = (this.getHeight() - n2) / 2 + 1;
        int n6 = 18;
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                n = 0;
                this.closeButton.setBounds(n4 += bl ? -n - n6 : n, n5, n6, n2);
                if (!bl) {
                    n4 += n6;
                }
            } else {
                n = 0;
                this.closeButton.setBounds(n4 += bl ? -n - n6 : n, n5, n6, n2);
                if (!bl) {
                    n4 += n6;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            n = 0;
            this.maxButton.setBounds(n4 += bl ? -n - n6 : n, n5, n6, n2);
            if (!bl) {
                n4 += n6;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            n = 0;
            this.iconButton.setBounds(n4 += bl ? -n - n6 : n, n5, n6, n2);
            if (!bl) {
                n4 += n6;
            }
        }
        this.buttonsWidth = bl ? n3 - n4 : n4;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        return this.isPalette ? super.getFont() : UIManager.getFont("InternalFrame.normalTitleFont");
    }

    class RolloverListener
    implements MouseListener {
        JButton button;
        Action action;

        public RolloverListener(JButton jButton, Action action) {
            this.button = jButton;
            this.action = action;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.action.actionPerformed(new ActionEvent(this, 1001, this.button.getText()));
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.button.getModel().setRollover(false);
            if (!LiquidInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }
    }
}

