/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidDesktopManager;
import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.LiquidInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class LiquidInternalFrameUI
extends BasicInternalFrameUI {
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";
    private static final PropertyChangeListener liquidPropertyChangeListener = new LiquidPropertyChangeHandler();
    static boolean allowRoundedWindows = false;
    private static DesktopManager sharedDesktopManager;
    LiquidInternalFrameBorder frameBorder = new LiquidInternalFrameBorder();
    private LiquidInternalFrameTitlePane titlePane;

    public LiquidInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidInternalFrameUI((JInternalFrame)jComponent);
    }

    JDesktopPane getDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }

    protected DesktopManager getDesktopManager() {
        if (!allowRoundedWindows) {
            return super.getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected DesktopManager createDesktopManager() {
        if (!allowRoundedWindows) {
            return super.createDesktopManager();
        }
        return new LiquidDesktopManager();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (allowRoundedWindows) {
            this.frame.setOpaque(false);
        }
        this.frame.setBorder(this.frameBorder);
        this.frame.addPropertyChangeListener(liquidPropertyChangeListener);
        Object object = jComponent.getClientProperty(IS_PALETTE);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.frame.removePropertyChangeListener(liquidPropertyChangeListener);
        super.uninstallUI(jComponent);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        super.createNorthPane(jInternalFrame);
        this.titlePane = new LiquidInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        this.frameBorder.setActive(true);
        this.titlePane.activate();
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        super.deactivateFrame(jInternalFrame);
        this.frameBorder.setActive(false);
        this.titlePane.deactivate();
    }

    public void setPalette(boolean bl) {
        if (bl) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(bl);
        this.frameBorder.isPalette = bl;
        this.frame.setBorder(this.frameBorder);
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    private void setFrameType(String string) {
        if (string.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            this.titlePane.setPalette(false);
        } else if (string.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            this.titlePane.setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            this.titlePane.setPalette(false);
        }
    }

    private static class LiquidPropertyChangeHandler
    implements PropertyChangeListener {
        private LiquidPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            if (!(jInternalFrame.getUI() instanceof LiquidInternalFrameUI)) {
                return;
            }
            LiquidInternalFrameUI liquidInternalFrameUI = (LiquidInternalFrameUI)jInternalFrame.getUI();
            if (string.equals(FRAME_TYPE)) {
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    liquidInternalFrameUI.setFrameType((String)propertyChangeEvent.getNewValue());
                }
            } else if (string.equals(IS_PALETTE)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    liquidInternalFrameUI.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    liquidInternalFrameUI.setPalette(false);
                }
            } else if (string.equals("contentPane")) {
                liquidInternalFrameUI.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }
}

