/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class XTraScrollBarUI
extends BasicScrollBarUI {
    protected boolean useAlternateLayout = Boolean.TRUE.equals(UIManager.get("ScrollBar.alternateLayout"));

    public static ComponentUI createUI(JComponent jComponent) {
        return new XTraScrollBarUI();
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        if (this.useAlternateLayout) {
            this.alternateLayoutVScrollbar(jScrollBar);
        } else {
            super.layoutVScrollbar(jScrollBar);
        }
    }

    protected void alternateLayoutVScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = this.incrButton.getPreferredSize().height;
        int n5 = dimension.height - (insets.bottom + n4);
        int n6 = this.decrButton.getPreferredSize().height;
        int n7 = n5 - n6;
        int n8 = insets.top + insets.bottom;
        int n9 = n6 + n4;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
        }
        if ((n = dimension.height - n8) < n9) {
            n4 = n6 = n / 2;
            n5 = dimension.height - (insets.bottom + n4);
        }
        this.decrButton.setBounds(n3, n7, n2, n6);
        this.incrButton.setBounds(n3, n5, n2, n4);
        int n12 = insets.top;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        if (this.useAlternateLayout) {
            this.alternateLayoutHScrollbar(jScrollBar);
        } else {
            super.layoutHScrollbar(jScrollBar);
        }
    }

    protected void alternateLayoutHScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.height - (insets.top + insets.bottom);
        int n3 = insets.top;
        int n4 = this.incrButton.getPreferredSize().width;
        int n5 = dimension.width - (insets.right + n4);
        int n6 = this.decrButton.getPreferredSize().width;
        int n7 = n5 - n6;
        int n8 = insets.left + insets.right;
        int n9 = n6 + n4;
        float f = dimension.width - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().width);
        n10 = Math.min(n10, this.getMaximumThumbSize().width);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
        }
        if ((n = dimension.width - n8) < n9) {
            n4 = n6 = n / 2;
            n5 = dimension.width - (insets.right + n4);
        }
        this.decrButton.setBounds(n7, n3, n6, n2);
        this.incrButton.setBounds(n5, n3, n4, n2);
        int n12 = insets.left;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n12, n3, n13, n2);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n5) {
                n11 = n5 - n10;
            }
            this.setThumbBounds(n11, n3, n10, n2);
        }
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        if (this.useAlternateLayout) {
            return new MyTrackListener();
        }
        return super.createTrackListener();
    }

    public JButton decrButton() {
        return this.decrButton;
    }

    public JButton incrButton() {
        return this.incrButton;
    }

    public JScrollBar scrollbar() {
        return this.scrollbar;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    public Rectangle getTrackBounds() {
        return super.getTrackBounds();
    }

    public void setThumbBounds(int n, int n2, int n3, int n4) {
        super.setThumbBounds(n, n2, n3, n4);
    }

    public class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        public MyTrackListener() {
            super(XTraScrollBarUI.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            if (!XTraScrollBarUI.this.scrollbar().isEnabled() || !XTraScrollBarUI.this.isDragging()) {
                return;
            }
            Insets insets = XTraScrollBarUI.this.scrollbar().getInsets();
            BoundedRangeModel boundedRangeModel = XTraScrollBarUI.this.scrollbar().getModel();
            Rectangle rectangle = XTraScrollBarUI.this.getThumbBounds();
            if (XTraScrollBarUI.this.scrollbar().getOrientation() == 1) {
                n3 = insets.top;
                n2 = XTraScrollBarUI.this.decrButton().getY() - XTraScrollBarUI.this.getThumbBounds().height;
                n = Math.min(n2, Math.max(n3, mouseEvent.getY() - this.offset));
                XTraScrollBarUI.this.setThumbBounds(rectangle.x, n, rectangle.width, rectangle.height);
                float f = XTraScrollBarUI.this.getTrackBounds().height;
            } else {
                n3 = insets.left;
                n2 = XTraScrollBarUI.this.decrButton().getX() - XTraScrollBarUI.this.getThumbBounds().width;
                n = Math.min(n2, Math.max(n3, mouseEvent.getX() - this.offset));
                XTraScrollBarUI.this.setThumbBounds(n, rectangle.y, rectangle.width, rectangle.height);
                float f = XTraScrollBarUI.this.getTrackBounds().width;
            }
            if (n == n2) {
                XTraScrollBarUI.this.scrollbar().setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
            } else {
                float f = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
                float f2 = f - (float)boundedRangeModel.getMinimum();
                float f3 = n - n3;
                float f4 = n2 - n3;
                int n4 = (int)(0.5 + (double)(f3 / f4 * f2));
                XTraScrollBarUI.this.scrollbar().setValue(n4 + boundedRangeModel.getMinimum());
            }
        }
    }
}

