/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.SkinElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;

public class Skin
extends SkinElement {
    private int nrImages;
    private int hsize;
    private int vsize;
    private int ulX;
    private int ulY;
    private int lrX;
    private int lrY;
    private boolean noBorder = false;

    public Skin(String string, int n, int n2, int n3, int n4, int n5) {
        super(string, true);
        this.nrImages = n;
        this.ulX = n2;
        this.ulY = n3;
        this.lrX = n4;
        this.lrY = n5;
        this.calculateSizes();
    }

    public Skin(String string, int n, int n2) {
        this(string, n, n2, n2, n2, n2);
        if (n2 == 0) {
            this.noBorder = true;
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = n * this.getHsize();
        if (!this.noBorder) {
            graphics2D.drawImage(this.getImage(), 0, 0, this.ulX, this.ulY, n4 + 0, 0, n4 + this.ulX, this.ulY, null);
            graphics2D.drawImage(this.getImage(), this.ulX, 0, n2 - this.lrX, this.ulY, n4 + this.ulX, 0, n4 + this.hsize - this.lrX, this.ulY, null);
            graphics2D.drawImage(this.getImage(), n2 - this.lrX, 0, n2, this.ulY, n4 + this.hsize - this.lrX, 0, n4 + this.hsize, this.ulY, null);
            graphics2D.drawImage(this.getImage(), 0, this.ulY, this.ulX, n3 - this.lrY, n4 + 0, this.ulY, n4 + this.ulX, this.vsize - this.lrY, null);
            graphics2D.drawImage(this.getImage(), n2 - this.lrX, this.ulY, n2, n3 - this.lrY, n4 + this.hsize - this.lrX, this.ulY, n4 + this.hsize, this.vsize - this.lrY, null);
            graphics2D.drawImage(this.getImage(), 0, n3 - this.lrY, this.ulX, n3, n4 + 0, this.vsize - this.lrY, n4 + this.ulX, this.vsize, null);
            graphics2D.drawImage(this.getImage(), this.ulX, n3 - this.lrY, n2 - this.lrX, n3, n4 + this.ulX, this.vsize - this.lrY, n4 + this.hsize - this.lrX, this.vsize, null);
            graphics2D.drawImage(this.getImage(), n2 - this.lrX, n3 - this.lrY, n2, n3, n4 + this.hsize - this.lrX, this.vsize - this.lrY, n4 + this.hsize, this.vsize, null);
            graphics2D.drawImage(this.getImage(), this.ulX, this.ulY, n2 - this.lrX, n3 - this.lrY, n4 + this.ulX, this.ulY, n4 + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            graphics.drawImage(this.getImage(), 0, 0, n2, n3, n4, 0, n4 + this.hsize, this.vsize, null);
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n * this.getHsize();
        if (!this.noBorder) {
            graphics.drawImage(this.getImage(), n2 + 0, n3 + 0, n2 + this.ulX, n3 + this.ulY, n6 + 0, 0, n6 + this.ulX, this.ulY, null);
            graphics.drawImage(this.getImage(), n2 + this.ulX, n3 + 0, n2 + n4 - this.lrX, n3 + this.ulY, n6 + this.ulX, 0, n6 + this.hsize - this.lrX, this.ulY, null);
            graphics.drawImage(this.getImage(), n2 + n4 - this.lrX, n3 + 0, n2 + n4, n3 + this.ulY, n6 + this.hsize - this.lrX, 0, n6 + this.hsize, this.ulY, null);
            graphics.drawImage(this.getImage(), n2 + 0, n3 + this.ulY, n2 + this.ulX, n3 + n5 - this.lrY, n6 + 0, this.ulY, n6 + this.ulX, this.vsize - this.lrY, null);
            graphics.drawImage(this.getImage(), n2 + n4 - this.lrX, n3 + this.ulY, n2 + n4, n3 + n5 - this.lrY, n6 + this.hsize - this.lrX, this.ulY, n6 + this.hsize, this.vsize - this.lrY, null);
            graphics.drawImage(this.getImage(), n2 + 0, n3 + n5 - this.lrY, n2 + this.ulX, n3 + n5, n6 + 0, this.vsize - this.lrY, n6 + this.ulX, this.vsize, null);
            graphics.drawImage(this.getImage(), n2 + this.ulX, n3 + n5 - this.lrY, n2 + n4 - this.lrX, n3 + n5, n6 + this.ulX, this.vsize - this.lrY, n6 + this.hsize - this.lrX, this.vsize, null);
            graphics.drawImage(this.getImage(), n2 + n4 - this.lrX, n3 + n5 - this.lrY, n2 + n4, n3 + n5, n6 + this.hsize - this.lrX, this.vsize - this.lrY, n6 + this.hsize, this.vsize, null);
            graphics.drawImage(this.getImage(), n2 + this.ulX, n3 + this.ulY, n2 + n4 - this.lrX, n3 + n5 - this.lrY, n6 + this.ulX, this.ulY, n6 + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            graphics.drawImage(this.getImage(), n2, n3, n2 + n4, n3 + n5, n6, 0, n6 + this.hsize, this.vsize, null);
        }
    }

    public void drawCentered(Graphics graphics, int n, int n2, int n3) {
        int n4 = n * this.getHsize();
        int n5 = this.getHsize();
        int n6 = this.getVsize();
        int n7 = (n2 - n5) / 2;
        int n8 = (n3 - n6) / 2;
        graphics.drawImage(this.getImage(), n7, n8, n7 + n5, n8 + n6, n4, 0, n4 + n5, n6, null);
    }

    public void drawCentered(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n * this.getHsize();
        int n7 = this.getHsize();
        int n8 = this.getVsize();
        int n9 = (n4 - n7) / 2;
        int n10 = (n5 - n8) / 2;
        graphics.drawImage(this.getImage(), n2 + n9, n3 + n10, n2 + n9 + n7, n3 + n10 + n8, n6, 0, n6 + n7, n8, null);
    }

    public int getHsize() {
        return this.hsize;
    }

    public int getVsize() {
        return this.vsize;
    }

    public Dimension getSize() {
        return new Dimension(this.hsize, this.vsize);
    }

    protected void calculateSizes() {
        this.hsize = this.getImage().getWidth(null) / this.nrImages;
        this.vsize = this.getImage().getHeight(null);
    }

    Color dark(Color color, int n) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (n <= 0 || color.getAlpha() < 255) {
            return color;
        }
        if (n < 100) {
            return this.light(color, 10000 / n);
        }
        int n2 = (int)(fArray[2] * 255.0f);
        n2 = 100 * n2 / n;
        float f = (float)n2 / 255.0f;
        return Color.getHSBColor(fArray[0], fArray[1], f);
    }

    Color light(Color color, int n) {
        if (n <= 0) {
            return color;
        }
        if (n < 100) {
            return this.dark(color, 10000 / n);
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f = fArray[1];
        float f2 = fArray[2];
        System.out.print("LIGHT V : " + f2);
        f2 = (float)n * f2 / 100.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 > 255.0f) {
            if ((f -= f2 - 255.0f) < 0.0f) {
                f = 0.0f;
            }
            f2 = 255.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], f2);
    }

    Color colour(Color color, Color color2) {
        boolean bl = false;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getAlpha();
        int n5 = 255 - color2.getRed();
        int n6 = (n += 20) - n5;
        int n7 = (n2 += 20) - n5;
        int n8 = (n3 += 20) - n5;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n7 > 255) {
            n7 = 255;
        }
        if (n8 > 255) {
            n8 = 255;
        }
        if (bl && n4 != 255 && n4 != 0) {
            float f = (float)n4 / 255.0f;
            float f2 = 1.0f - f;
            n6 = (int)(f * (float)n6 + f2 * (float)color2.getRed());
            n7 = (int)(f * (float)n7 + f2 * (float)color2.getGreen());
            n8 = (int)(f * (float)n8 + f2 * (float)color2.getBlue());
            n4 = 255;
        }
        return new Color(n6, n7, n8, n4);
    }

    private Color colourSinglePixel(int n, int n2, int n3, Color color) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        return this.colour(color, new Color(n5, n6, n7, n4));
    }

    public void colourImage() {
        int n = 0;
        int n2 = 0;
        int n3 = this.hsize * this.nrImages;
        int n4 = this.vsize;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 6);
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(this.getImage(), n, n2, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        Graphics graphics = bufferedImage.getGraphics();
        Color color = null;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j == 0 || j == 117) {
                    color = LiquidLookAndFeel.getBackgroundColor();
                } else if (j == 39 || j == 156) {
                    color = LiquidLookAndFeel.getButtonBackground();
                } else if (j == 78) {
                    color = this.dark(LiquidLookAndFeel.getButtonBackground(), 115);
                }
                graphics.setColor(this.colourSinglePixel(n + j, n2 + i, nArray[i * n3 + j], color));
                graphics.drawLine(n + j, n2 + i, n + j, n2 + i);
            }
        }
        this.setImage(bufferedImage);
    }
}

