/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import de.grogra.grammar.LexicalException;
import de.grogra.util.Int2IntMap;
import de.grogra.util.Utils;
import de.grogra.xl.util.IntList;
import java.io.IOException;
import java.io.Reader;

public final class Input
implements CharSequence {
    public static final int EOF = -1;
    public static final char EOL = '\n';
    private String sourceName;
    private IntList buffer = new IntList(5000);
    private int position;
    private int lineCount;
    private final boolean ignoreUnicodeEscapes;
    private Int2IntMap unicodeEscapes = new Int2IntMap();
    private IntList lineStart = new IntList();
    private Reader source;
    private final StringBuffer tmpBuffer = new StringBuffer();
    private int unget = -2;
    private int bsCount = 0;
    private static final int CS_LENGTH = 256;
    private static final String[] CHAR_STRINGS = new String[256];
    private char[] tmpChar = null;

    public Input(boolean bl) {
        this.ignoreUnicodeEscapes = bl;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSource(Reader reader, String string) {
        this.source = reader;
        this.sourceName = string;
        this.buffer.setSize(0);
        this.unicodeEscapes.clear();
        this.unicodeEscapes.put(Integer.MAX_VALUE, 0);
        this.lineCount = 0;
        this.position = 0;
        this.lineStart.set(0, 0);
    }

    public boolean isClosed() {
        return this.source == null;
    }

    public void close() throws IOException {
        try {
            while (this.source != null && this.getChar() != 10) {
            }
        }
        catch (LexicalException lexicalException) {
            // empty catch block
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void reset(int n) {
        this.position = n;
    }

    public void ungetChar() {
        --this.position;
    }

    private int getc() throws IOException, LexicalException {
        int n = this.unget;
        if (n != -2) {
            this.unget = -2;
        } else {
            n = this.source.read();
        }
        if (n == 92) {
            if ((++this.bsCount & 1) != 0) {
                n = this.source.read();
                if (this.ignoreUnicodeEscapes || n != 117) {
                    this.unget = n;
                    n = 92;
                } else {
                    n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 1;
                    while (n3 < 4) {
                        int n5 = this.source.read();
                        if (n5 == 117 && n3 == 0) {
                            ++n4;
                            continue;
                        }
                        n2 = (n2 << 1) + (n5 < 97 ? 1 : 0);
                        if ((n5 = Utils.fromHexDigit((int)n5)) < 0) {
                            throw new LexicalException("Illegal Unicode");
                        }
                        ++n3;
                        n = (n << 4) + n5;
                    }
                    n |= (n4 + 5 << 20) + (n2 << 16);
                    this.bsCount = 0;
                }
            }
        } else {
            this.bsCount = 0;
        }
        return n;
    }

    public int getChar() throws IOException, LexicalException {
        if (this.position == this.buffer.size()) {
            int n = this.getc();
            if (n < 0) {
                n = -1;
                this.source.close();
                this.source = null;
                this.buffer.push(10).push(-1);
            } else if ((char)n == '\r' && (n = this.getc()) != 10) {
                this.unget = n;
                this.bsCount = 0;
                n = 10;
            }
            if (n >= 0) {
                this.buffer.push((int)((char)n));
                if ((char)n == '\n') {
                    this.lineStart.set(++this.lineCount, this.position + 1);
                }
                if (n != (char)n) {
                    this.unicodeEscapes.put(this.position, n >> 16);
                }
            }
            this.lineStart.set(this.lineCount + 1, this.position + 2);
        }
        return this.buffer.get(this.position++);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n) {
        return this.substring(n, this.position);
    }

    public String substring(int n, int n2) {
        switch (n2 - n) {
            case 0: {
                return "";
            }
            case 1: {
                int n3 = this.buffer.get(n);
                if (n3 < 0 || n3 >= 256) break;
                return CHAR_STRINGS[n3];
            }
        }
        char[] cArray = this.tmpChar;
        if (this.tmpChar == null || cArray.length < (n2 -= n)) {
            this.tmpChar = cArray = new char[n2];
        }
        for (int i = n2 - 1; i >= 0; --i) {
            cArray[i] = this.charAt(n + i);
        }
        return new String(cArray, 0, n2);
    }

    public String toString() {
        return this.substring(0, this.position);
    }

    public int length() {
        return this.position;
    }

    public char charAt(int n) {
        return (char)((n = this.buffer.get(n)) < 0 ? 26 : (char)n);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineAt(int n) {
        return (n = this.lineStart.binarySearch(n)) >= 0 ? n : ~n - 1;
    }

    public int getColumnAt(int n, int n2) {
        int n3 = this.getLineAt(n);
        int n4 = 0;
        int n5 = this.lineStart.elements[n3];
        int n6 = this.unicodeEscapes.findIndex(n5);
        if (n6 < 0) {
            n6 ^= 0xFFFFFFFF;
        }
        int n7 = this.unicodeEscapes.getKeyAt(n6);
        while (n5 < n) {
            char c = this.charAt(n5);
            if (n5++ == n7) {
                n4 += this.unicodeEscapes.getValueAt(n6) >> 4;
                n7 = this.unicodeEscapes.getKeyAt(++n6);
                continue;
            }
            if (c == '\t') {
                n4 = (n4 / n2 + 1) * n2;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public int getLineLength(int n, int n2) {
        return this.getColumnAt(this.lineStart.elements[n + 1] - 1, n2);
    }

    public String getTextForLine(int n) {
        this.tmpBuffer.setLength(0);
        int n2 = this.lineStart.elements[n];
        int n3 = this.lineStart.elements[n + 1] - 1;
        int n4 = this.unicodeEscapes.findIndex(n2);
        if (n4 < 0) {
            n4 ^= 0xFFFFFFFF;
        }
        int n5 = this.unicodeEscapes.getKeyAt(n4);
        while (n2 < n3) {
            char c = this.charAt(n2);
            if (n2++ == n5) {
                int n6;
                int n7 = this.unicodeEscapes.getValueAt(n4);
                n5 = this.unicodeEscapes.getKeyAt(++n4);
                this.tmpBuffer.append('\\');
                for (n6 = n7 >> 4; n6 > 5; --n6) {
                    this.tmpBuffer.append('u');
                }
                for (n6 = 4; n6 > 0; --n6) {
                    this.tmpBuffer.append(Utils.toHexDigit((int)(c >> 12), ((n7 & 8) != 0 ? 1 : 0) != 0));
                    c = (char)(c << 4);
                    n7 <<= 1;
                }
                continue;
            }
            this.tmpBuffer.append(c);
        }
        return this.tmpBuffer.toString();
    }

    public int getPositionOfLine(int n) {
        return this.lineStart.elements[n];
    }

    public StringBuffer getTmpBuffer() {
        this.tmpBuffer.setLength(0);
        return this.tmpBuffer;
    }

    static {
        char[] cArray = new char[256];
        for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
            cArray[n] = n;
        }
        String string = new String(cArray);
        for (int i = 0; i < 256; ++i) {
            Input.CHAR_STRINGS[i] = string.substring(i, i + 1);
        }
    }
}

