/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import antlr.Token;
import antlr.collections.AST;
import de.grogra.grammar.LexicalException;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.SemanticException;
import de.grogra.grammar.SyntacticException;
import de.grogra.grammar.Tokenizer;
import de.grogra.util.I18NBundle;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;

public class RecognitionExceptionList
extends RecognitionException {
    private final long warningMask;
    private final long errorMask;
    private long nextWarningBits;
    private boolean nextWarningBitsSet = false;
    private ObjectList<RecognitionException> list = new ObjectList();
    private int errorCount = 0;
    private int warningCount = 0;
    private ObjectList<RecognitionException> suppressedErrors = new ObjectList();
    private static final RecognitionException[] EXCEPTION_0 = new RecognitionException[0];

    public RecognitionExceptionList(long l, long l2) {
        super("RecognitionExceptionList");
        this.warningMask = l | l2 | 1L;
        this.errorMask = l2 | 1L;
    }

    public RecognitionExceptionList() {
        this(-1L, 0L);
    }

    public void check() throws RecognitionExceptionList {
        if (this.errorCount > 0) {
            throw this;
        }
    }

    public void reset() {
        this.nextWarningBitsSet = false;
        this.errorCount = 0;
        this.warningCount = 0;
        this.list.clear();
    }

    public RecognitionExceptionList enableAdd() {
        int n = this.suppressedErrors.size();
        while (this.suppressedErrors.get(n - 1) != null) {
            --n;
        }
        RecognitionExceptionList recognitionExceptionList = new RecognitionExceptionList(this.warningMask, this.errorMask);
        for (int i = n; i < this.suppressedErrors.size(); ++i) {
            recognitionExceptionList.add((RecognitionException)this.suppressedErrors.get(i));
        }
        this.suppressedErrors.setSize(n - 1);
        return recognitionExceptionList;
    }

    public void disableAdd() {
        this.suppressedErrors.push(null);
    }

    public boolean isAddEnabled() {
        return this.suppressedErrors.isEmpty();
    }

    public boolean containsErrors() {
        return this.errorCount > 0;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public boolean containsWarnings() {
        return this.warningCount > 0;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean isWarning(long l) {
        if ((l & this.warningMask) == 0L) {
            return false;
        }
        this.nextWarningBits = l;
        this.nextWarningBitsSet = true;
        return true;
    }

    public void add(RecognitionException recognitionException) {
        this.nextWarningBitsSet = false;
        boolean bl = recognitionException.isError = (recognitionException.warningBits & this.errorMask) != 0L;
        if (this.suppressedErrors.isEmpty()) {
            recognitionException.stamp = this.list.size();
            this.list.addInOrder((Comparable)recognitionException);
            if (recognitionException.isError) {
                ++this.errorCount;
            } else {
                ++this.warningCount;
            }
        } else {
            this.suppressedErrors.push((Object)recognitionException);
        }
    }

    public void addAll(RecognitionExceptionList recognitionExceptionList) {
        for (int i = 0; i < recognitionExceptionList.list.size(); ++i) {
            this.add((RecognitionException)recognitionExceptionList.list.get(i));
        }
    }

    public void addAll(RecognitionException[] recognitionExceptionArray) {
        for (int i = 0; i < recognitionExceptionArray.length; ++i) {
            this.add(recognitionExceptionArray[i]);
        }
    }

    public void addWarning(RecognitionException recognitionException, long l) {
        recognitionException.warningBits = l;
        this.add(recognitionException);
    }

    public void addWarning(RecognitionException recognitionException) {
        assert (this.nextWarningBitsSet);
        recognitionException.warningBits = this.nextWarningBits;
        this.add(recognitionException);
    }

    public void addLexicalWarning(String string, Token token) {
        this.addWarning(new LexicalException(string).set(token));
    }

    public void addLexicalWarning(String string, AST aST) {
        this.addWarning(new LexicalException(string).set(aST));
    }

    public void addLexicalWarning(I18NBundle i18NBundle, String string, Token token) {
        this.addWarning(new LexicalException(i18NBundle.msg(string)).set(token));
    }

    public void addLexicalWarning(I18NBundle i18NBundle, String string, AST aST) {
        this.addWarning(new LexicalException(i18NBundle.msg(string)).set(aST));
    }

    public void addLexicalError(String string, Token token) {
        this.add(new LexicalException(string).set(token));
    }

    public void addLexicalError(String string, AST aST) {
        this.add(new LexicalException(string).set(aST));
    }

    public void addLexicalError(I18NBundle i18NBundle, String string, Token token) {
        this.add(new LexicalException(i18NBundle.msg(string)).set(token));
    }

    public void addLexicalError(I18NBundle i18NBundle, String string, AST aST) {
        this.add(new LexicalException(i18NBundle.msg(string)).set(aST));
    }

    public void addSyntacticWarning(String string, Token token) {
        this.addWarning(new SyntacticException(string).set(token));
    }

    public void addSyntacticWarning(String string, AST aST) {
        this.addWarning(new SyntacticException(string).set(aST));
    }

    public void addSyntacticWarning(I18NBundle i18NBundle, String string, Token token) {
        this.addWarning(new SyntacticException(i18NBundle.msg(string)).set(token));
    }

    public void addSyntacticWarning(I18NBundle i18NBundle, String string, AST aST) {
        this.addWarning(new SyntacticException(i18NBundle.msg(string)).set(aST));
    }

    public void addSyntacticError(String string, Token token) {
        this.add(new SyntacticException(string).set(token));
    }

    public void addSyntacticError(String string, AST aST) {
        this.add(new SyntacticException(string).set(aST));
    }

    public void addSyntacticError(I18NBundle i18NBundle, String string, Token token) {
        this.add(new SyntacticException(i18NBundle.msg(string)).set(token));
    }

    public void addSyntacticError(I18NBundle i18NBundle, String string, AST aST) {
        this.add(new SyntacticException(i18NBundle.msg(string)).set(aST));
    }

    public void addSemanticWarning(String string, Token token) {
        this.addWarning(new SemanticException(string).set(token));
    }

    public void addSemanticWarning(String string, AST aST) {
        this.addWarning(new SemanticException(string).set(aST));
    }

    public void addSemanticWarning(I18NBundle i18NBundle, String string, Token token) {
        this.addWarning(new SemanticException(i18NBundle.msg(string)).set(token));
    }

    public void addSemanticWarning(I18NBundle i18NBundle, String string, AST aST) {
        this.addWarning(new SemanticException(i18NBundle.msg(string)).set(aST));
    }

    public void addSemanticError(String string, Token token) {
        this.add(new SemanticException(string).set(token));
    }

    public void addSemanticError(String string, AST aST) {
        this.add(new SemanticException(string).set(aST));
    }

    public void addSemanticError(I18NBundle i18NBundle, String string, Token token) {
        this.add(new SemanticException(i18NBundle.msg(string)).set(token));
    }

    public void addSemanticError(I18NBundle i18NBundle, String string, AST aST) {
        this.add(new SemanticException(i18NBundle.msg(string)).set(aST));
    }

    public String getMessage() {
        return this.errorCount == 0 ? Tokenizer.I18N.msg("grammar.error-list-no-errors", (Object)this.warningCount) : Tokenizer.I18N.msg("grammar.error-list-errors", (Object)this.errorCount, (Object)this.warningCount);
    }

    public String getDetailedMessage(int n, int n2, int n3, boolean bl) {
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(this.getMessage());
        if (bl) {
            Utils.escapeForXML((StringBuffer)stringBuffer, (int)0);
        }
        int n4 = this.list.size();
        if (bl && n4 > 60) {
            n4 = 50;
            bl2 = true;
        } else {
            bl2 = false;
        }
        for (int i = 0; i < n4; ++i) {
            stringBuffer.append(bl ? "<br>\n" : "\n");
            stringBuffer.append(((RecognitionException)this.list.get(i)).getDetailedMessage(n, n2, n3, bl));
        }
        if (bl2) {
            stringBuffer.append("<br>\n").append(Tokenizer.I18N.msg("grammar.further-errors", (Object)(this.list.size() - n4)));
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        super.dispose();
        for (int i = this.list.size() - 1; i >= 0; --i) {
            ((RecognitionException)this.list.get(i)).dispose();
        }
    }
}

