/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.base.Graph;
import de.grogra.xl.impl.base.Neighbors;
import de.grogra.xl.query.EdgeDirection;
import java.util.HashMap;

public abstract class RuntimeModel
implements de.grogra.xl.query.RuntimeModel {
    public static final int SUCCESSOR_EDGE = 256;
    public static final int BRANCH_EDGE = 512;
    public static final int CONTAINMENT_EDGE = 1024;
    public static final int CONTAINMENT_END_EDGE = 2048;
    public static final int REFINEMENT_EDGE = 4096;
    public static final int MARK_EDGE = 8192;
    public static final int MIN_USER_EDGE = 16384;
    public static final int SPECIAL_MASK = 255;
    public static final int MIN_NORMAL_BIT_INDEX = 8;
    private static final ThreadLocal<HashMap<Class, Graph>> EXTENTS = new ThreadLocal();
    protected Neighbors copyOut = new Neighbors(this, -1, -1, 0, 512, true);
    protected Neighbors copyIn = new Neighbors(this, -1, -1, 0, 0, false);
    protected Neighbors branchIn = new Neighbors(this, 768, 0, 512, 0, false);

    public abstract Class getNodeType();

    public abstract void addEdgeBits(Object var1, Object var2, int var3);

    public abstract int getEdgeBits(Object var1, Object var2);

    public abstract EdgeIterator createEdgeIterator(Object var1, EdgeDirection var2);

    public void initialize(String string) {
    }

    public int getStandardEdgeFor(int n) {
        switch (n) {
            case 0: {
                return -1;
            }
            case 2: {
                return 512;
            }
            case 1: {
                return 256;
            }
            case 3: {
                return 4096;
            }
        }
        throw new AssertionError(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentGraph(Graph graph) {
        ThreadLocal<HashMap<Class, Graph>> threadLocal = EXTENTS;
        synchronized (threadLocal) {
            HashMap<Class<Object>, Graph> hashMap = EXTENTS.get();
            if (hashMap == null) {
                hashMap = new HashMap();
                EXTENTS.set(hashMap);
            }
            hashMap.put(this.getClass(), graph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph currentGraph() {
        ThreadLocal<HashMap<Class, Graph>> threadLocal = EXTENTS;
        synchronized (threadLocal) {
            HashMap<Class, Graph> hashMap = EXTENTS.get();
            if (hashMap == null) {
                return null;
            }
            return hashMap.get(this.getClass());
        }
    }

    public boolean isNode(Object object) {
        return object != null && this.getNodeType().isInstance(object);
    }

    public static final boolean testEdgeBits(int n, int n2) {
        if (n2 == -1) {
            return n != 0;
        }
        if ((n2 & n & 0xFFFFFF00) != 0) {
            return true;
        }
        switch (n2 & 0xFF) {
            case 0: {
                return false;
            }
            case 255: {
                return (n & 0xFF) != 0;
            }
        }
        return ((n2 ^ n) & 0xFF) == 0;
    }

    public static final int edgeBitsIntersection(int n, int n2) {
        if (n2 == -1) {
            return n;
        }
        switch (n2 & 0xFF) {
            case 0: 
            case 255: {
                return n & n2;
            }
        }
        return ((n2 ^ n) & 0xFF) == 0 ? n & n2 : n & n2 & 0xFFFFFF00;
    }

    public static final int edgeBitsUnion(int n, int n2) {
        if (((n ^ n2) & 0xFF) == 0) {
            return n | n2;
        }
        if ((n2 & 0xFF) == 0) {
            return n | n2;
        }
        return n & 0xFFFFFF00 | n2;
    }

    public boolean isWrapperFor(Object object, Type type) {
        return false;
    }

    public boolean unwrapBoolean(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public byte unwrapByte(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public short unwrapShort(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public char unwrapChar(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public int unwrapInt(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public long unwrapLong(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public float unwrapFloat(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public double unwrapDouble(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }

    public Object unwrapObject(Object object) {
        throw new AbstractMethodError("Method not implemented");
    }
}

