/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.simple;

import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.simple.Node;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.util.ObjectList;

public class RuntimeModel
extends de.grogra.xl.impl.base.RuntimeModel {
    final ObjectList<Iterator> iterators = new ObjectList();

    public Class getNodeType() {
        return Node.class;
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        ((Node)object).addEdgeBitsTo((Node)object2, n);
    }

    public int getEdgeBits(Object object, Object object2) {
        return ((Node)object).getEdgeBitsTo((Node)object2);
    }

    public EdgeIterator createEdgeIterator(Object object, EdgeDirection edgeDirection) {
        Iterator iterator = this.iterators.isEmpty() ? new Iterator() : (Iterator)this.iterators.pop();
        iterator.set((Node)object, edgeDirection);
        return iterator;
    }

    private final class Iterator
    extends EdgeIterator {
        private Node node;
        private int firstOut;
        private int index;
        private ObjectList<Node> neighbors = new ObjectList();

        private Iterator() {
        }

        void set(Node node, EdgeDirection edgeDirection) {
            this.node = node;
            if (edgeDirection.contains((EdgeDirection)EdgeDirection.BACKWARD)) {
                node.getAdjacentNodes((ObjectConsumer<? super Node>)this.neighbors, false);
            }
            this.firstOut = this.neighbors.size();
            if (edgeDirection.contains((EdgeDirection)EdgeDirection.FORWARD)) {
                node.getAdjacentNodes((ObjectConsumer<? super Node>)this.neighbors, true);
            }
            this.index = -1;
            this.moveToNext();
        }

        public void moveToNext() {
            if (++this.index >= this.neighbors.size()) {
                return;
            }
            Node node = (Node)this.neighbors.get(this.index);
            if (this.index < this.firstOut) {
                this.source = node;
                this.target = this.node;
                this.edgeBits = node.getEdgeBitsTo(this.node);
            } else {
                this.source = this.node;
                this.target = node;
                this.edgeBits = this.node.getEdgeBitsTo(node);
            }
        }

        public boolean hasEdge() {
            if (this.index < this.neighbors.size()) {
                return true;
            }
            this.dispose();
            return false;
        }

        public void dispose() {
            if (this.node != null) {
                RuntimeModel.this.iterators.push((Object)this);
                this.neighbors.clear();
                this.source = null;
                this.target = null;
                this.node = null;
            }
        }
    }
}

