/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab.amapsymbol;

import de.grogra.graph.impl.Node;
import de.grogra.greenlab.amapsymbol.SMBByteReader;
import de.grogra.imp3d.objects.MeshNode;
import de.grogra.imp3d.objects.PolygonMesh;
import de.grogra.imp3d.objects.Polygons;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class SMBReader {
    private PolygonMesh polygonMesh = null;
    private SMBByteReader byteReader = new SMBByteReader();
    private int byteIndex = 0;
    private byte[] fileContent;
    private InputStream istream;
    private long fileLength;
    ArrayList<SMBTriFace> additionalFaces;

    public SMBReader(InputStream inputStream, long l) {
        this.istream = inputStream;
        this.fileLength = l;
        this.additionalFaces = new ArrayList();
        try {
            this.loadPolygonMesh();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public SMBReader(InputStream inputStream) {
        this.fileLength = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) > -1) {
                ++this.fileLength;
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.istream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.additionalFaces = new ArrayList();
        try {
            this.loadPolygonMesh();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private long readUnsignedInt32() {
        long l = 0L;
        l = this.byteReader.readUnsignedInt32(this.fileContent, this.byteIndex);
        this.byteIndex += 4;
        return l;
    }

    private int readUnsignedInt16() {
        int n = 0;
        n = this.byteReader.readUnsignedInt16(this.fileContent, this.byteIndex);
        this.byteIndex += 2;
        return n;
    }

    private float readFloat32() {
        float f = this.byteReader.readFloat32(this.fileContent, this.byteIndex);
        this.byteIndex += 4;
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolygonMesh() throws IOException {
        try {
            long l;
            this.fileContent = new byte[(int)this.fileLength];
            this.istream.read(this.fileContent);
            long l2 = this.readUnsignedInt32();
            long l3 = this.readUnsignedInt32();
            FloatList floatList = new FloatList((int)l3 * 3);
            IntList intList = new IntList((int)l2 * 3);
            float[] fArray = new float[(int)l3 * 3];
            float[] fArray2 = new float[(int)l3 * 2];
            for (long i = 0L; i < l2; ++i) {
                long l4 = this.readUnsignedInt32();
                this.readUnsignedInt16();
                this.readUnsignedInt16();
                long[] lArray = new long[(int)l4];
                long l5 = 0L;
                for (long j = 0L; j < l4; ++j) {
                    this.readUnsignedInt32();
                    l5 = this.readUnsignedInt32();
                    this.readUnsignedInt16();
                    lArray[(int)j] = l5;
                }
                intList.push((int)lArray[0]);
                intList.push((int)lArray[2]);
                intList.push((int)lArray[1]);
                if (l4 < 4L) continue;
                int n = 2;
                int n2 = intList.get(intList.size() - 3);
                l = 0L;
                long l6 = 0L;
                while ((long)(n + 1) <= l4 - 1L) {
                    l = lArray[n];
                    l6 = lArray[n + 1];
                    this.additionalFaces.add(new SMBTriFace(n2, (int)l, (int)l6));
                    ++n;
                }
            }
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            for (l = 0L; l < l3; ++l) {
                f4 = this.readFloat32();
                f5 = this.readFloat32();
                f6 = this.readFloat32();
                f = this.readFloat32();
                f2 = this.readFloat32();
                f3 = this.readFloat32();
                f7 = this.readFloat32();
                f8 = this.readFloat32();
                f9 = this.readFloat32();
                floatList.push(f, f2, f3);
                fArray[(int)l * 3] = f4;
                fArray[(int)l * 3 + 1] = f5;
                fArray[(int)l * 3 + 2] = f6;
                fArray2[(int)l * 2] = f7;
                fArray2[(int)l * 2 + 1] = f8;
            }
            if (this.additionalFaces.size() > 0) {
                int n;
                IntList intList2 = new IntList((int)l2 * 3 * 2);
                for (n = 0; n < intList.size(); ++n) {
                    intList2.push(intList.get(n));
                }
                intList.clear();
                intList = new IntList((int)(l2 * 3L * 2L + (long)this.additionalFaces.size()));
                for (n = 0; n < intList2.size(); ++n) {
                    intList.push(intList2.get(n));
                }
                for (n = 0; n < this.additionalFaces.size(); ++n) {
                    SMBTriFace sMBTriFace = this.additionalFaces.get(n);
                    intList.push(sMBTriFace.pointIndices[0]);
                    intList.push(sMBTriFace.pointIndices[1]);
                    intList.push(sMBTriFace.pointIndices[2]);
                }
            }
            this.polygonMesh = new PolygonMesh();
            this.polygonMesh.setIndexData(intList);
            this.polygonMesh.setNormalData(fArray);
            this.polygonMesh.setTextureData(fArray2);
            this.polygonMesh.setVertexData(floatList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found" + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Exception while reading the file " + iOException);
        }
        finally {
            if (this.istream != null) {
                this.istream.close();
            }
            System.gc();
        }
    }

    public Node getObeject() {
        MeshNode meshNode = new MeshNode((Polygons)this.getPolygonMesh());
        meshNode.setVisibleSides(2);
        return meshNode;
    }

    public PolygonMesh getPolygonMesh() {
        return this.polygonMesh;
    }

    private class SMBTriFace {
        public int[] pointIndices = new int[3];

        SMBTriFace(int n, int n2, int n3) {
            this.pointIndices[0] = n;
            this.pointIndices[1] = n2;
            this.pointIndices[2] = n3;
        }
    }
}

