/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab.ui.elements;

import de.grogra.greenlab.GreenLabGUI;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class GreenLabNumberField
extends JTextField
implements KeyListener,
FocusListener {
    private static final long serialVersionUID = -4166975218962521347L;
    private static final int INT_SIZE = 4;
    private static final int DOUBLE_SIZE = 6;
    private static final double doubleStepSize = 0.1;
    private static final int intStepSize = 1;
    private static final String intStr = "integer";
    private double doubleMin = -1.7976931348623157E308;
    private double doubleMax = Double.MAX_VALUE;
    private int intMin = Integer.MIN_VALUE;
    private int intMax = Integer.MAX_VALUE;
    private boolean isInt = false;
    private boolean checking = false;
    private String keyString = "defaultTooltip";

    public GreenLabNumberField(String string) {
        super(GreenLabGUI.getString(string + ".type").equals(intStr) ? 4 : 6);
        this.init(string);
    }

    public GreenLabNumberField(String string, boolean bl) {
        super(GreenLabGUI.getString(string + ".type").equals(intStr) ? 4 : 6);
        this.init(string);
    }

    private void init(String string) {
        this.keyString = string;
        String string2 = GreenLabGUI.getString(string + ".type");
        this.isInt = string2.equals(intStr);
        String string3 = GreenLabGUI.getString(string + ".range.min");
        String string4 = GreenLabGUI.getString(string + ".range.max");
        if (this.isInt) {
            if (!string3.equals("MIN")) {
                try {
                    this.intMin = (int)NumberFormat.getInstance(Locale.US).parse(string3).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!string4.equals("MAX")) {
                try {
                    this.intMax = (int)NumberFormat.getInstance(Locale.US).parse(string4).doubleValue();
                }
                catch (ParseException parseException) {}
            }
        } else {
            if (!string3.equals("MIN")) {
                try {
                    this.doubleMin = NumberFormat.getInstance(Locale.US).parse(string3).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!string4.equals("MAX")) {
                try {
                    this.doubleMax = NumberFormat.getInstance(Locale.US).parse(string4).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
        final String string5 = this.keyString;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                GreenLabGUI.tooltipPanel.updateValue(string5);
            }
        });
    }

    public String getTextValue() {
        return this.getText();
    }

    public double getValue() {
        double d = 0.0;
        try {
            d = NumberFormat.getInstance(Locale.US).parse(this.getText()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return d;
    }

    public void setText(String string) {
        this.setValue(string);
    }

    public void setTextValue(String string) {
        super.setText(string);
    }

    public void setValue(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        decimalFormat.setMaximumFractionDigits(10);
        decimalFormat.setMinimumFractionDigits(0);
        super.setText(decimalFormat.format(d).toString().replaceAll(",", "."));
    }

    public void setValue(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        decimalFormat.setMaximumFractionDigits(10);
        decimalFormat.setMinimumFractionDigits(0);
        super.setText(decimalFormat.format(n).toString());
    }

    public void setValue(String string) {
        if (this.isInt) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setValue(n);
        } else {
            double d = 0.0;
            try {
                d = NumberFormat.getInstance(Locale.US).parse(string).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.setValue(d);
        }
    }

    private void inc(double d) {
        this.setValue(this.getValue() + d);
    }

    private void dec(double d) {
        this.setValue(this.getValue() - d);
    }

    private void inc(int n) {
        this.setValue(this.getValue() + (double)n);
    }

    private void dec(int n) {
        this.setValue(this.getValue() - (double)n);
    }

    protected Document createDefaultModel() {
        return new DoubleNumberDocument();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isInt) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.inc(1);
                    break;
                }
                case 40: {
                    this.dec(1);
                    break;
                }
                case 33: {
                    this.inc(10);
                    break;
                }
                case 34: {
                    this.dec(10);
                }
            }
        } else {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.inc(0.1);
                    break;
                }
                case 40: {
                    this.dec(0.1);
                    break;
                }
                case 33: {
                    this.inc(1.0);
                    break;
                }
                case 34: {
                    this.dec(1.0);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        GreenLabGUI.tooltipPanel.updateValue(this.keyString);
    }

    public void focusGained(FocusEvent focusEvent) {
        GreenLabGUI.tooltipPanel.updateValue(this.keyString);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected class DoubleNumberDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        protected DoubleNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == '-' && n == 0 && GreenLabNumberField.this.getTextValue().indexOf("-") < 0 || !GreenLabNumberField.this.isInt && cArray[i] == '.' && GreenLabNumberField.this.getTextValue().indexOf(".") < 0) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            if (!GreenLabNumberField.this.checking) {
                this.checkBounds();
            }
        }

        private void checkBounds() {
            GreenLabNumberField.this.checking = true;
            if (GreenLabNumberField.this.isInt) {
                if (GreenLabNumberField.this.getValue() > (double)GreenLabNumberField.this.intMax) {
                    GreenLabNumberField.this.setValue(GreenLabNumberField.this.intMax);
                }
                if (GreenLabNumberField.this.getValue() < (double)GreenLabNumberField.this.intMin) {
                    GreenLabNumberField.this.setValue(GreenLabNumberField.this.intMin);
                }
            } else {
                if (GreenLabNumberField.this.getValue() > GreenLabNumberField.this.doubleMax) {
                    GreenLabNumberField.this.setValue(GreenLabNumberField.this.doubleMax);
                }
                if (GreenLabNumberField.this.getValue() < GreenLabNumberField.this.doubleMin) {
                    GreenLabNumberField.this.setValue(GreenLabNumberField.this.doubleMin);
                }
            }
            GreenLabNumberField.this.checking = false;
        }
    }
}

