/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.dxf;

import de.grogra.ext.dxf.DXFExport;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.SceneTree;
import java.io.IOException;
import java.io.PrintWriter;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple4d;

public abstract class ObjectBase
implements SceneGraphExport.NodeExport {
    Matrix4d transformation;
    PrintWriter out;

    public void export(SceneTree.Leaf leaf, SceneTree.InnerNode innerNode, SceneGraphExport sceneGraphExport) throws IOException {
        DXFExport dXFExport = (DXFExport)sceneGraphExport;
        this.out = dXFExport.out;
        Matrix4d matrix4d = (Matrix4d)dXFExport.matrixStack.peek();
        Matrix4d matrix4d2 = new Matrix4d();
        if (innerNode != null) {
            innerNode.transform(matrix4d, matrix4d2);
        } else {
            matrix4d2.set(matrix4d);
        }
        this.transformation = matrix4d2;
        this.exportImpl(leaf, innerNode, dXFExport);
    }

    abstract void exportImpl(SceneTree.Leaf var1, SceneTree.InnerNode var2, DXFExport var3) throws IOException;

    Matrix4d getTransformation() {
        return this.transformation;
    }

    static double round(double d) {
        return (double)Math.round(d * 100000.0) / 100000.0;
    }

    static void triangle(PrintWriter printWriter, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        printWriter.println("0");
        printWriter.println("3DFACE");
        printWriter.println("10");
        printWriter.println(ObjectBase.round(d));
        printWriter.println("20");
        printWriter.println(ObjectBase.round(d2));
        printWriter.println("30");
        printWriter.println(ObjectBase.round(d3));
        printWriter.println("11");
        printWriter.println(d4);
        printWriter.println("21");
        printWriter.println(d5);
        printWriter.println("31");
        printWriter.println(d6);
        printWriter.println("12");
        printWriter.println(d7);
        printWriter.println("22");
        printWriter.println(d8);
        printWriter.println("32");
        printWriter.println(d9);
    }

    static void quad(PrintWriter printWriter, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        printWriter.println("0");
        printWriter.println("3DFACE");
        printWriter.println("10");
        printWriter.println(ObjectBase.round(d));
        printWriter.println("20");
        printWriter.println(ObjectBase.round(d2));
        printWriter.println("30");
        printWriter.println(ObjectBase.round(d3));
        printWriter.println("11");
        printWriter.println(ObjectBase.round(d4));
        printWriter.println("21");
        printWriter.println(ObjectBase.round(d5));
        printWriter.println("31");
        printWriter.println(ObjectBase.round(d6));
        printWriter.println("12");
        printWriter.println(ObjectBase.round(d7));
        printWriter.println("22");
        printWriter.println(ObjectBase.round(d8));
        printWriter.println("32");
        printWriter.println(ObjectBase.round(d9));
        printWriter.println("13");
        printWriter.println(ObjectBase.round(d10));
        printWriter.println("23");
        printWriter.println(ObjectBase.round(d11));
        printWriter.println("33");
        printWriter.println(ObjectBase.round(d12));
    }

    static void quad(PrintWriter printWriter, Tuple4d tuple4d, Tuple4d tuple4d2, Tuple4d tuple4d3, Tuple4d tuple4d4) {
        ObjectBase.quad(printWriter, tuple4d.x, tuple4d.y, tuple4d.z, tuple4d2.x, tuple4d2.y, tuple4d2.z, tuple4d3.x, tuple4d3.y, tuple4d3.z, tuple4d4.x, tuple4d4.y, tuple4d4.z);
    }

    void beginPolyline(int n, int n2) {
        this.out.println("0");
        this.out.println("POLYLINE");
        this.out.println("70");
        this.out.println("64");
        this.out.println("71");
        this.out.println(n);
        this.out.println("72");
        this.out.println(n2);
    }

    void endPolyline() {
        this.out.println("0");
        this.out.println("SEQEND");
    }

    void mesh(PolygonArray polygonArray) {
        int n;
        if (polygonArray.polygons.size == 0) {
            return;
        }
        this.beginPolyline(polygonArray.vertices.size() / polygonArray.dimension, polygonArray.polygons.size() / polygonArray.edgeCount);
        for (n = 0; n < polygonArray.vertices.size(); n += polygonArray.dimension) {
            this.out.println("0");
            this.out.println("VERTEX");
            this.out.println("10");
            this.out.println(ObjectBase.round(polygonArray.vertices.get(n)));
            this.out.println("20");
            this.out.println(ObjectBase.round(polygonArray.vertices.get(n + 1)));
            this.out.println("30");
            this.out.println(ObjectBase.round(polygonArray.vertices.get(n + 2)));
            this.out.println("70");
            this.out.println("192");
        }
        for (n = 0; n < polygonArray.polygons.size(); n += polygonArray.edgeCount) {
            this.out.println("0");
            this.out.println("VERTEX");
            this.out.println("10");
            this.out.println("0");
            this.out.println("20");
            this.out.println("0");
            this.out.println("30");
            this.out.println("0");
            this.out.println("70");
            this.out.println("128");
            for (int i = 0; i < polygonArray.edgeCount; ++i) {
                this.out.println("7" + (i + 1));
                this.out.println(polygonArray.polygons.get(n + i) + 1);
            }
        }
        this.endPolyline();
    }
}

