/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jagatoo.loaders.models.obj.OBJFace;
import org.jagatoo.loaders.models.obj.OBJMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJFaceList {
    private List<OBJFace> faces = new ArrayList<OBJFace>();
    private List<float[]> verts;
    private List<float[]> normals;
    private List<float[]> texs;
    private boolean texturesUsed = false;
    private boolean normalsUsed = false;
    private boolean supportNormals = true;
    private boolean supportTextures = true;

    public void setFaces(List<OBJFace> list) {
        this.faces = list;
    }

    public List<OBJFace> getFaces() {
        return this.faces;
    }

    public List<float[]> getVertexList() {
        return this.verts;
    }

    public List<float[]> getNormalList() {
        return this.normals;
    }

    public List<float[]> getTexList() {
        return this.texs;
    }

    public void setNormalsUsed(boolean bl) {
        this.normalsUsed = bl;
    }

    public boolean normalsUsed() {
        return this.normalsUsed;
    }

    public boolean normalsSupported() {
        return this.supportNormals;
    }

    public void setTexturesUsed(boolean bl) {
        this.texturesUsed = bl;
    }

    public boolean texturesUsed() {
        return this.texturesUsed;
    }

    public boolean texturesSupported() {
        return this.supportTextures;
    }

    private int parseInt(String string) {
        if (string.length() == 0) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseVertIndex(String string) {
        if (string.indexOf("/") >= 0) {
            return this.parseInt(string.substring(0, string.indexOf("/")));
        }
        return this.parseInt(string);
    }

    private int parseTextureIndex(String string) {
        int n = string.indexOf("/");
        if (n < 0) {
            return -1;
        }
        if ((n = (string = string.substring(n + 1)).indexOf("/")) >= 0) {
            int n2 = this.parseInt(string.substring(0, n));
            if (n2 != -1) {
                this.texturesUsed = true;
            }
            return n2;
        }
        int n3 = this.parseInt(string);
        if (n3 != -1) {
            this.texturesUsed = true;
        }
        return n3;
    }

    private int parseNormalIndex(String string) {
        if (string.indexOf("/") < 0) {
            return -1;
        }
        if ((string = string.substring(string.indexOf("/") + 1)).indexOf("/") < 0) {
            return -1;
        }
        if ((string = string.substring(string.indexOf("/") + 1)).indexOf("/") >= 0) {
            int n = this.parseInt(string.substring(0, string.indexOf("/")));
            if (n != -1) {
                this.normalsUsed = true;
            }
            return n;
        }
        int n = this.parseInt(string);
        if (n != -1) {
            this.normalsUsed = true;
        }
        return n;
    }

    public void add(String string, OBJMaterial oBJMaterial) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        OBJFace oBJFace = new OBJFace(this, stringTokenizer.countTokens() - 1, oBJMaterial);
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = this.parseVertIndex(string2);
            int n2 = this.parseTextureIndex(string2);
            int n3 = this.parseNormalIndex(string2);
            oBJFace.add(n > 0 ? n - 1 : -1, n3 > 0 ? n3 - 1 : -1, n2 > 0 ? n2 - 1 : -1);
        }
        this.faces.add(oBJFace);
    }

    public OBJFaceList(List<float[]> list, List<float[]> list2, List<float[]> list3) {
        this.verts = list;
        this.normals = list2;
        this.texs = list3;
    }
}

