/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux;

import de.grogra.gpuflux.GPUFlux;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.EnumerationType;
import de.grogra.util.Map;
import de.grogra.util.Utils;

public class FluxSettings {
    public static int PERFORMANCE_BUILD = 0;
    public static int PERFORMANCE_TRACE = 1;
    public static final EnumerationType PERFORMANCE_TYPE = new EnumerationType("performance", GPUFlux.I18N, PERFORMANCE_TRACE + 1);
    private static final int DEFAULT_MIN_MEASUREMENTS = 8192;
    private static final int DEFAULT_TRACE_DEPTH = 5;
    private static final int DEFAULT_PREFERRED_DURATION = 500;
    private static final float DEFAULT_MIN_POWER = 0.01f;
    private static final int INITIAL_SAMPLE_COUNT = 10000000;
    private static final int MAXIMUM_SAMPLE_COUNT = 100000000;
    private static final int INITIAL_SPECTRAL_RESOLUTION = 1;
    private static final float DEFAULT_FLATNESS = 10.0f;
    private static final int DEFAULT_SKYRESOLUTION = 512;
    private static final int DEFAULT_CHANNELRESOLUTION = 128;
    private static Item general = null;
    private static Item ocl = null;
    private static Item advanced = null;
    private static Item renderer = null;

    private static void getItems() {
        if (general == null) {
            general = Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/GPUFluxRenderer/general");
        }
        if (ocl == null) {
            ocl = Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/GPUFluxRenderer/opencl");
        }
        if (advanced == null) {
            advanced = Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/GPUFluxRenderer/opencl/advanced");
        }
        if (renderer == null) {
            renderer = Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/GPUFluxRenderer/renderer");
        }
    }

    public static int getModelSpectralLambdaStep() {
        FluxSettings.getItems();
        return Utils.getInt((Map)general, (Object)"rayprocessor.spectralresolution", (int)1);
    }

    public static float getModelFlatness() {
        FluxSettings.getItems();
        return Utils.getFloat((Map)general, (Object)"rayprocessor.flatness", (float)10.0f);
    }

    public static int getSkyResolution() {
        FluxSettings.getItems();
        return Utils.getInt((Map)general, (Object)"rayprocessor.skyresolution", (int)512);
    }

    public static int getChannelResolution() {
        FluxSettings.getItems();
        return Utils.getInt((Map)general, (Object)"rayprocessor.channelresolution", (int)128);
    }

    public static String getLightModelSettingsLog() {
        String string = "";
        string = string + "    <b>LightModel settings</b>\n";
        string = string + "        Spectral Resolution: " + FluxSettings.getModelSpectralLambdaStep() + " nm\n";
        string = string + "        Tessellation flatness: " + FluxSettings.getModelFlatness() + "\n";
        return string;
    }

    public static int getOCLInitialSampleCount() {
        FluxSettings.getItems();
        return Utils.getInt((Map)advanced, (Object)"rayprocessor.initialsamplecount", (int)10000000);
    }

    public static int getOCLMaximumSampleCount() {
        return 100000000;
    }

    public static double getOCLPreferredDuration() {
        FluxSettings.getItems();
        return (double)Utils.getInt((Map)advanced, (Object)"rayprocessor.iterationtime", (int)500) / 1000.0;
    }

    public static int getOCLMinMeasurements() {
        FluxSettings.getItems();
        return Utils.getInt((Map)advanced, (Object)"rayprocessor.minimalmeasurements", (int)8192);
    }

    public static boolean getOCLPrecompile() {
        FluxSettings.getItems();
        return Utils.getBoolean((Map)advanced, (Object)"precompile", (boolean)true);
    }

    public static boolean getOCLGPU() {
        FluxSettings.getItems();
        return Utils.getBoolean((Map)ocl, (Object)"gpu", (boolean)true);
    }

    public static boolean getOCLMultiGPU() {
        FluxSettings.getItems();
        return Utils.getBoolean((Map)ocl, (Object)"multigpu", (boolean)true);
    }

    public static int getOCLPerformance() {
        FluxSettings.getItems();
        return (Integer)Utils.getObject((Map)advanced, (Object)"performance", (Object)new Integer(PERFORMANCE_TRACE));
    }

    public static String getOpenCLSettingsLog() {
        String string = "";
        string = string + "    <b>OpenCL settings</b>\n";
        string = string + "        Minimum batch size: " + FluxSettings.getOCLInitialSampleCount() + "\n";
        string = string + "        Maximum batch size: " + FluxSettings.getOCLMaximumSampleCount() + "\n";
        string = string + "        Prefered iteration duration: " + FluxSettings.getOCLPreferredDuration() + "\n";
        string = string + "        Precompile: " + (FluxSettings.getOCLPrecompile() ? "Enabled" : "Disabled") + "\n";
        string = string + "        GPU: " + (FluxSettings.getOCLGPU() ? "Enabled" : "Disabled") + "\n";
        string = string + "        Multiple Devices: " + (FluxSettings.getOCLMultiGPU() ? "Enabled" : "Disabled") + "\n";
        string = string + "        Performance Devices: " + (FluxSettings.getOCLPerformance() == 0 ? "Fast Build" : "Fast Trace") + "\n";
        return string;
    }

    public static int getRenderDepth() {
        FluxSettings.getItems();
        return Utils.getInt((Map)renderer, (Object)"rayprocessor.depth", (int)5);
    }

    public static float getRenderMinPower() {
        FluxSettings.getItems();
        return Utils.getFloat((Map)renderer, (Object)"rayprocessor.minpower", (float)0.01f);
    }

    public static boolean getRenderSpectral() {
        FluxSettings.getItems();
        return Utils.getBoolean((Map)renderer, (Object)"spectral", (boolean)false);
    }

    public static boolean getRenderDispersion() {
        FluxSettings.getItems();
        return Utils.getBoolean((Map)renderer, (Object)"dispersion", (boolean)false);
    }

    public static String getRenderSettingsLog() {
        String string = "";
        string = string + "    <b>Render settings</b>\n";
        string = string + "        Depth: " + FluxSettings.getRenderDepth() + "\n";
        string = string + "        Minimum Power: " + FluxSettings.getRenderMinPower() + "\n";
        string = string + "        Spectral: " + (FluxSettings.getRenderSpectral() ? "Enabled" : "Disabled") + "\n";
        string = string + "        Dispersian: " + (FluxSettings.getRenderDispersion() ? "Enabled" : "Disabled") + "\n";
        return string;
    }

    public static String getTracerLog() {
        return FluxSettings.getLightModelSettingsLog() + FluxSettings.getOpenCLSettingsLog() + FluxSettings.getRenderSettingsLog();
    }
}

