/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl;

import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLContext;
import de.grogra.gpuflux.jocl.JOCLKernel;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_event;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;

public class JOCLDevice {
    private static final boolean DEBUG = false;
    private String name;
    private String extensions;
    private String[] extensionList;
    private JOCLBuffer defaultDebugBuffer = null;
    private JOCLContext context;
    private cl_command_queue commandQueue;
    private boolean littleEndian;
    private cl_device_id device;

    JOCLDevice(JOCLContext jOCLContext, cl_device_id cl_device_id2) {
        this.device = cl_device_id2;
        this.context = jOCLContext;
        this.commandQueue = CL.clCreateCommandQueue((cl_context)jOCLContext.getClContext(), (cl_device_id)cl_device_id2, (long)2L, null);
        this.littleEndian = JOCLDevice.getBool(cl_device_id2, 4134);
        this.defaultDebugBuffer = jOCLContext.createBuffer(16, 1L);
        this.name = JOCLDevice.getString(cl_device_id2, 4139);
        this.extensions = JOCLDevice.getString(cl_device_id2, 4144);
        this.extensionList = this.extensions.split(" ");
        for (int i = 0; i < this.extensionList.length; ++i) {
            this.extensionList[i] = this.extensionList[i].trim().toUpperCase();
        }
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void readBuffer(JOCLBuffer jOCLBuffer, int[] nArray) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commandQueue, (cl_mem)jOCLBuffer.getBuffer(), (boolean)true, (long)0L, (long)Math.min(nArray.length * 4, jOCLBuffer.getSize()), (Pointer)Pointer.to((int[])nArray), (int)0, null, null);
    }

    public void readBuffer(JOCLBuffer jOCLBuffer, byte[] byArray) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commandQueue, (cl_mem)jOCLBuffer.getBuffer(), (boolean)true, (long)0L, (long)Math.min(byArray.length, jOCLBuffer.getSize()), (Pointer)Pointer.to((byte[])byArray), (int)0, null, null);
    }

    public void finalize() throws Throwable {
        CL.clReleaseCommandQueue((cl_command_queue)this.commandQueue);
        super.finalize();
    }

    public void finish() {
        CL.clFinish((cl_command_queue)this.commandQueue);
    }

    public void executeKernel(JOCLKernel jOCLKernel, int n) {
        this.executeKernel(jOCLKernel, n, null);
    }

    public void executeKernel(JOCLKernel jOCLKernel, int n, cl_event cl_event2) {
        if (n > 0) {
            JOCLBuffer jOCLBuffer = this.defaultDebugBuffer;
            jOCLKernel.setKernelArgMemBuffer(0, jOCLBuffer);
            long l = 64L;
            long[] lArray = new long[]{n};
            if (lArray[0] % l != 0L) {
                lArray[0] = (lArray[0] / l + 1L) * l;
            }
            long[] lArray2 = new long[]{l};
            CL.clEnqueueNDRangeKernel((cl_command_queue)this.commandQueue, (cl_kernel)jOCLKernel.getKernel(), (int)1, null, (long[])lArray, (long[])lArray2, (int)0, null, (cl_event)cl_event2);
        }
    }

    public String getName() {
        return this.name;
    }

    public static boolean isLittleEndian(cl_device_id cl_device_id2) {
        return JOCLDevice.getBool(cl_device_id2, 4134);
    }

    public static long getDeviceType(cl_device_id cl_device_id2) {
        return JOCLDevice.getLong(cl_device_id2, 4096);
    }

    private static boolean getBool(cl_device_id cl_device_id2, int n) {
        return JOCLDevice.getInt(cl_device_id2, n) != 0;
    }

    private static int getInt(cl_device_id cl_device_id2, int n) {
        return JOCLDevice.getInts(cl_device_id2, n, 1)[0];
    }

    private static int[] getInts(cl_device_id cl_device_id2, int n, int n2) {
        int[] nArray = new int[n2];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)(4 * n2), (Pointer)Pointer.to((int[])nArray), null);
        return nArray;
    }

    private static long getLong(cl_device_id cl_device_id2, int n) {
        return JOCLDevice.getLongs(cl_device_id2, n, 1)[0];
    }

    private static long[] getLongs(cl_device_id cl_device_id2, int n, int n2) {
        long[] lArray = new long[n2];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)(8 * n2), (Pointer)Pointer.to((long[])lArray), null);
        return lArray;
    }

    private static String getString(cl_device_id cl_device_id2, int n) {
        long[] lArray = new long[1];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)0L, null, (long[])lArray);
        byte[] byArray = new byte[(int)lArray[0]];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), null);
        return new String(byArray, 0, byArray.length - 1);
    }

    public ByteOrder getByteOrder() {
        if (this.isLittleEndian()) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    private void writeDebugFile(String string, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (this.littleEndian) {
            byteBuffer.order(this.getByteOrder());
        }
        int n = byArray.length / 16;
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        try {
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            for (int i = 0; i < n; ++i) {
                int n2;
                printWriter.println(i);
                printWriter.print("\t");
                for (n2 = 0; n2 < 4; ++n2) {
                    printWriter.print("" + intBuffer.get(i * 4 + n2) + " ");
                }
                printWriter.print("\n\t");
                for (n2 = 0; n2 < 4; ++n2) {
                    printWriter.print("" + floatBuffer.get(i * 4 + n2) + " ");
                }
                printWriter.print("\n\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public cl_device_id getClDevice() {
        return this.device;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String[] getExtensionList() {
        return this.extensionList;
    }

    public String getVendor() {
        return JOCLDevice.getString(this.device, 4140);
    }

    public String getVersion() {
        return JOCLDevice.getString(this.device, 4143);
    }

    public String toString() {
        String string = "";
        string = string + "    Name:       " + this.getName() + "\n";
        string = string + "    Vendor:     " + this.getVendor() + "\n";
        string = string + "    Version:    " + this.getVersion() + "\n";
        string = string + "    Type:       " + this.deviceTypeToString(this.getDeviceType()) + "\n";
        string = string + "    Extensions: " + this.getExtensions() + "\n";
        return string;
    }

    public String deviceTypeToString(long l) {
        if (l == 2L) {
            return "CPU";
        }
        if (l == 4L) {
            return "GPU";
        }
        if (l == 8L) {
            return "ACCELERATOR";
        }
        return "UNKNOWN";
    }

    public long getDeviceType() {
        return JOCLDevice.getDeviceType(this.device);
    }

    public static cl_platform_id getPlatform(cl_device_id cl_device_id2) {
        cl_platform_id[] cl_platform_idArray = new cl_platform_id[1];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)4145, (long)Sizeof.cl_platform_id, (Pointer)Pointer.to((NativePointerObject[])cl_platform_idArray), null);
        return cl_platform_idArray[0];
    }

    public static cl_device_id[] getDevices(cl_platform_id cl_platform_id2) {
        int[] nArray = new int[1];
        CL.clGetDeviceIDs((cl_platform_id)cl_platform_id2, (long)-1L, (int)0, null, (int[])nArray);
        cl_device_id[] cl_device_idArray = new cl_device_id[nArray[0]];
        CL.clGetDeviceIDs((cl_platform_id)cl_platform_id2, (long)-1L, (int)cl_device_idArray.length, (cl_device_id[])cl_device_idArray, null);
        return cl_device_idArray;
    }

    public static boolean supportsExtensions(cl_device_id cl_device_id2, String[] stringArray) {
        String string = " " + JOCLDevice.getString(cl_device_id2, 4144).toUpperCase() + " ";
        for (String string2 : stringArray) {
            if (string.contains(" " + string2 + " ")) continue;
            return false;
        }
        return true;
    }

    public String getIdentifier() {
        String string = this.getVendor() + " " + this.getName() + " " + this.getVersion();
        return string;
    }

    public static String getIdentifier(cl_device_id cl_device_id2) {
        String string = JOCLDevice.getVendor(cl_device_id2) + " " + JOCLDevice.getName(cl_device_id2) + " " + JOCLDevice.getVersion(cl_device_id2);
        return string;
    }

    private static String getVersion(cl_device_id cl_device_id2) {
        return JOCLDevice.getString(cl_device_id2, 4143);
    }

    private static String getName(cl_device_id cl_device_id2) {
        return JOCLDevice.getString(cl_device_id2, 4139);
    }

    private static String getVendor(cl_device_id cl_device_id2) {
        return JOCLDevice.getString(cl_device_id2, 4140);
    }
}

