/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene;

import de.grogra.gpuflux.scene.filter.ObjectFilter;
import de.grogra.gpuflux.scene.light.FluxLightBuilder;
import de.grogra.graph.Graph;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.ray2.ProgressMonitor;
import javax.vecmath.Matrix4d;

public class FluxLightVisitor
extends DisplayVisitor {
    private FluxLightBuilder lightBuilder;

    public void visitScene(Graph graph, ViewConfig3D viewConfig3D, ObjectFilter objectFilter, boolean bl, boolean bl2, ProgressMonitor progressMonitor) {
        this.lightBuilder = new FluxLightBuilder();
        long l = System.currentTimeMillis();
        graph.accept(null, (Visitor)this, null);
        l = System.currentTimeMillis() - l;
    }

    protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
        LightNode lightNode;
        Matrix4d matrix4d;
        Object object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (bl && object instanceof LightNode) {
            matrix4d = this.getCurrentTransformation();
            lightNode = (LightNode)object;
            this.lightBuilder.buildLight(lightNode.getLight(), matrix4d);
        }
        if (object2 instanceof Sky) {
            matrix4d = this.getCurrentTransformation();
            lightNode = new LightNode();
            lightNode.setLight((Light)((Sky)object2));
            lightNode.setTransform(matrix4d);
            this.lightBuilder.buildLight(lightNode.getLight(), matrix4d);
        }
    }

    public FluxLightBuilder getLightBuilder() {
        return this.lightBuilder;
    }
}

