/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.scene.BVH.BVHAnalyzer;
import de.grogra.gpuflux.scene.BVH.BVHTree;
import de.grogra.gpuflux.scene.BVH.ThreadedBVHBuilderMiddle;
import de.grogra.gpuflux.scene.BVH.ThreadedBVHBuilderSAH;
import de.grogra.gpuflux.scene.FluxLightVisitor;
import de.grogra.gpuflux.scene.FluxSceneVisitor;
import de.grogra.gpuflux.scene.filter.ObjectFilter;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.light.FluxLightBuilder;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxSensor;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Variables;
import de.grogra.xl.util.LongToIntHashMap;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxScene {
    private Vector<FluxPrimitive> primitives;
    private Vector<FluxPrimitive> infPrimitives;
    private Vector<FluxSensor> sensors;
    private Vector<FluxChannelMap> channels;
    private Vector<FluxShader> shaders;
    private LongToIntHashMap nodeToGroup;
    private BVHTree bvh;
    private BVHTree sensorBvh;
    private BoundingBox3d bounds;
    private float[] cumulativeLightPower;
    private int sampleCount;
    private FluxLight sky;
    private Vector<FluxLight> lights;
    private Vector<FluxChannelMap> lightChannels;
    private Vector<FluxShader> lightShaders;
    private int groupCount;
    private String log = "";
    private Graph graph;
    private ViewConfig3D view;

    private void setLights(FluxLightBuilder fluxLightBuilder) {
        this.sampleCount = fluxLightBuilder.getSampleCount();
        this.cumulativeLightPower = fluxLightBuilder.getCummulativePowerBuffer(this.getEnvironment());
        this.sky = fluxLightBuilder.getSky();
        this.lights = fluxLightBuilder.getLights();
        this.lightShaders = fluxLightBuilder.getLightShaders();
        this.lightChannels = fluxLightBuilder.getLightChannels();
    }

    public void buildLightsFromGraph(Graph graph, ViewConfig3D viewConfig3D, ObjectFilter objectFilter, boolean bl, ProgressMonitor progressMonitor, boolean bl2) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        FluxLightVisitor fluxLightVisitor = new FluxLightVisitor();
        fluxLightVisitor.init(GraphState.current((Graph)graph), matrix4d, viewConfig3D, viewConfig3D != null);
        fluxLightVisitor.visitScene(graph, viewConfig3D, objectFilter, bl, bl2, progressMonitor);
        this.setLights(fluxLightVisitor.getLightBuilder());
    }

    /*
     * WARNING - void declaration
     */
    public void buildSceneFromGraph(Graph graph, ViewConfig3D viewConfig3D, ObjectFilter objectFilter, boolean bl, ProgressMonitor progressMonitor, boolean bl2, float f) {
        void var16_23;
        this.graph = graph;
        this.view = viewConfig3D;
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        long l = System.currentTimeMillis();
        this.log("<b>Build Profile</b>");
        FluxSceneVisitor fluxSceneVisitor = new FluxSceneVisitor();
        fluxSceneVisitor.init(GraphState.current((Graph)graph), matrix4d, viewConfig3D, viewConfig3D != null);
        fluxSceneVisitor.visitScene(graph, viewConfig3D, objectFilter, bl, bl2, progressMonitor, f, null);
        this.log(fluxSceneVisitor.getLog());
        l = System.currentTimeMillis() - l;
        this.log("    Object gather time:    " + l + " ms");
        this.primitives = fluxSceneVisitor.getPrimitives();
        this.infPrimitives = fluxSceneVisitor.getInfPrimitives();
        this.sensors = fluxSceneVisitor.getSensors();
        this.channels = fluxSceneVisitor.getChannels();
        this.shaders = fluxSceneVisitor.getShaders();
        this.groupCount = fluxSceneVisitor.getGroupCount();
        this.nodeToGroup = fluxSceneVisitor.getNodeToGroup();
        long l2 = System.currentTimeMillis();
        Variables variables = new Variables();
        for (FluxPrimitive object2 : this.primitives) {
            object2.computeExtent(variables);
        }
        for (FluxPrimitive fluxPrimitive : this.infPrimitives) {
            fluxPrimitive.computeExtent(variables);
        }
        for (FluxSensor fluxSensor : this.sensors) {
            fluxSensor.computeExtent(variables);
        }
        l2 = System.currentTimeMillis() - l2;
        this.log("    Extend compute time:   " + l2 + " ms");
        int n = FluxSettings.getOCLPerformance();
        Object var16_20 = null;
        if (n == FluxSettings.PERFORMANCE_TRACE) {
            ThreadedBVHBuilderSAH threadedBVHBuilderSAH = new ThreadedBVHBuilderSAH();
        } else {
            ThreadedBVHBuilderMiddle threadedBVHBuilderMiddle = new ThreadedBVHBuilderMiddle();
        }
        progressMonitor.setProgress("Build BVH", -1.0f);
        long l3 = System.currentTimeMillis();
        this.bvh = var16_23.construct(this.primitives);
        l3 = System.currentTimeMillis() - l3;
        this.log("    BVH build time:        " + l3 + " ms");
        this.log(var16_23.getLog());
        this.bounds = new BoundingBox3d();
        this.bounds.extent(this.bvh.getBounds());
        long l4 = 0L;
        if (bl) {
            progressMonitor.setProgress("Build Sensor BVH", -1.0f);
            l4 = System.currentTimeMillis();
            this.sensorBvh = var16_23.construct(this.sensors);
            l4 = System.currentTimeMillis() - l4;
            this.log("    Sensor BVH build time: " + l4 + " ms");
            this.log(var16_23.getLog());
            this.bounds.extent(this.sensorBvh.getBounds());
        }
        if (this.bounds.isEmpty()) {
            this.bounds.getMin().set(-1.0, -1.0, -1.0);
            this.bounds.getMax().set(1.0, 1.0, 1.0);
        }
        this.setLights(fluxSceneVisitor.getLightBuilder());
    }

    public String getSceneStats() {
        String string = "";
        string = string + "<b>Scene Stats</b>\n";
        string = string + "    <b>Scene</b>\n";
        if (this.primitives != null) {
            string = string + "    Number primitives: " + this.primitives.size() + "\n";
        }
        if (this.infPrimitives != null) {
            string = string + "    Number inf prims:  " + this.infPrimitives.size() + "\n";
        }
        if (this.sensors != null) {
            string = string + "    Number sensors:    " + this.sensors.size() + "\n";
        }
        if (this.channels != null) {
            string = string + "    Number channels:   " + this.channels.size() + "\n";
        }
        if (this.shaders != null) {
            string = string + "    Number shaders:    " + this.shaders.size() + "\n";
        }
        string = string + "    Number Groups:     " + this.groupCount + "\n";
        string = string + "\n";
        BVHAnalyzer bVHAnalyzer = new BVHAnalyzer();
        if (this.bvh != null) {
            string = string + "    <b>BVH</b>\n";
            string = string + bVHAnalyzer.analyzeBVH(this.bvh) + "\n";
            string = string + "\n";
        }
        if (this.sensorBvh != null) {
            string = string + "    <b>Sensor BVH</b>\n";
            string = string + bVHAnalyzer.analyzeBVH(this.sensorBvh) + "\n";
            string = string + "\n";
        }
        string = string + "    <b>Lights</b>\n";
        string = string + "    Number lights:         " + this.lights.size() + "\n";
        string = string + "    Number light samples:  " + this.sampleCount + "\n";
        string = string + "    Number light shaders:  " + this.lightShaders.size() + "\n";
        string = string + "    Number light channels: " + this.lightChannels.size() + "\n";
        string = string + "    Sky: " + (this.sky != null ? "Enabled" : "Disabled") + "\n";
        string = string + "\n";
        return string;
    }

    private void log(String string) {
        this.log = this.log + string + "\n";
    }

    public void cleanLog() {
        this.log = "";
    }

    public String getLog() {
        return this.log;
    }

    public BVHTree getBVH() {
        return this.bvh;
    }

    public BVHTree getSensorBVH() {
        return this.sensorBvh;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public Vector<FluxPrimitive> getPrimitives() {
        return this.primitives;
    }

    public Vector<FluxSensor> getSensors() {
        return this.sensors;
    }

    public Vector<FluxPrimitive> getInfPrimitives() {
        return this.infPrimitives;
    }

    public Vector<FluxShader> getShaders() {
        return this.shaders;
    }

    public Vector<FluxChannelMap> getChannels() {
        return this.channels;
    }

    public BoundingBox3d getBounds() {
        return this.bounds;
    }

    public Environment getEnvironment() {
        BoundingBox boundingBox = new BoundingBox(new Point3d(this.bounds.getMin()), new Point3d(this.bounds.getMax()));
        return new Environment(boundingBox, (Spectrum)new Spectrum3f(), 2);
    }

    public int getSensorCount() {
        return this.sensors.size();
    }

    public int getSensorBVHRoot() {
        return this.sensorBvh.getRootIdx();
    }

    public int getPrimitiveCount() {
        return this.primitives.size();
    }

    public int getInfPrimitiveCount() {
        return this.infPrimitives.size();
    }

    public int getBVHRoot() {
        return this.bvh.getRootIdx();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public ViewConfig3D getView() {
        return this.view;
    }

    public float[] getCumulativeLightPower() {
        return this.cumulativeLightPower;
    }

    public FluxLight getSky() {
        return this.sky;
    }

    public Vector<FluxLight> getLights() {
        return this.lights;
    }

    public Vector<FluxChannelMap> getLightChannels() {
        return this.lightChannels;
    }

    public Vector<FluxShader> getLightShaders() {
        return this.lightShaders;
    }

    public int getLightCount() {
        return this.lights.size();
    }

    public Camera getCamera() {
        return this.view.getCamera();
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public LongToIntHashMap getNodeToGroup() {
        return this.nodeToGroup;
    }
}

