/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.volume;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.volume.FluxFrustumBase;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.Cone;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import java.io.IOException;

public class FluxFrustum
extends FluxFrustumBase {
    private Cone v;

    public FluxFrustum(Cone cone) {
        this.v = cone;
    }

    public void getExtent(BoundingBox3d boundingBox3d, Variables variables) {
        this.v.getExtent(boundingBox3d.getMin(), boundingBox3d.getMax(), variables);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        this.serialize(computeByteBuffer, 131, (TransformableVolume)this.v);
        computeByteBuffer.writeFloat((float)this.v.getBase());
        computeByteBuffer.writeFloat((float)this.v.getTop());
        computeByteBuffer.writeFloat(this.v.scaleV);
        int n = 0;
        if (this.v.isTopOpen()) {
            n |= 2;
        }
        if (this.v.isBaseOpen()) {
            n |= 4;
        }
        if (this.v.isUVRotated()) {
            n |= 8;
        }
        computeByteBuffer.writeInt(n);
    }
}

