/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.tracer;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.GPUFluxInit;
import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLEvent;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.jocl.compute.SharedBuffer;
import de.grogra.gpuflux.scene.FluxJOCLScene;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.FluxSceneSerializer;
import de.grogra.gpuflux.scene.experiment.Experiment;
import de.grogra.gpuflux.scene.experiment.Measurement;
import de.grogra.gpuflux.scene.experiment.MeasuringSetup;
import de.grogra.gpuflux.scene.filter.AllFilter;
import de.grogra.gpuflux.scene.filter.ObjectFilter;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.shading.FluxSpectrum;
import de.grogra.gpuflux.tracer.FluxTracer;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.spectral.ConstantSpectralCurve;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.reflect.ClassAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.AbstractList;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.jocl.CL;
import org.jocl.cl_event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxLightModelTracer
extends ShareableBase
implements ProgressMonitor {
    private transient double preferredDuration;
    private transient int maximumSampleCount;
    private transient ComputeContext computeContext;
    private transient Kernel kernel;
    private transient Experiment irradiance;
    private transient Experiment power;
    private transient boolean justBuildLights = false;
    private transient ConcurrentLinkedQueue<DeviceMonitor> openDeviceList;
    private transient Semaphore available;
    private volatile transient boolean finnished;
    private transient FluxJOCLScene joclScene;
    private transient FluxScene scene;
    private transient boolean useBih;
    private transient FluxSceneSerializer serializer;
    private transient MeasuringSetup measuringSetup;
    private ObjectFilter measureObjectFilter = null;
    private boolean[] visibleLayers;
    private float flatness = 100.0f;
    private double minPower;
    private double targetVariance;
    private double cutoffPower;
    private int depth;
    private int rayCount;
    private boolean enableSensors = true;
    private MeasureMode measureMode = MeasureMode.RGB;
    private int minLambda = 380;
    private int maxLambda = 720;
    private int spectralBuckets = 10;
    private SpectralCurve importanceCurve = null;
    private SpectralCurve[] sensitivityCurves = null;
    private boolean dispersion = false;
    public static final Type $TYPE = new Type(FluxLightModelTracer.class);
    public static final SCOType.Field measureObjectFilter$FIELD = Type._addManagedField($TYPE, "measureObjectFilter", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(ObjectFilter.class), null, 0);
    public static final SCOType.Field visibleLayers$FIELD = Type._addManagedField($TYPE, "visibleLayers", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(boolean[].class), null, 1);
    public static final SCOType.Field flatness$FIELD = Type._addManagedField($TYPE, "flatness", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field minPower$FIELD = Type._addManagedField($TYPE, "minPower", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field targetVariance$FIELD = Type._addManagedField($TYPE, "targetVariance", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 4);
    public static final SCOType.Field cutoffPower$FIELD = Type._addManagedField($TYPE, "cutoffPower", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 5);
    public static final SCOType.Field depth$FIELD = Type._addManagedField($TYPE, "depth", 0x200002, de.grogra.reflect.Type.INT, null, 6);
    public static final SCOType.Field rayCount$FIELD = Type._addManagedField($TYPE, "rayCount", 0x200002, de.grogra.reflect.Type.INT, null, 7);
    public static final SCOType.Field enableSensors$FIELD = Type._addManagedField($TYPE, "enableSensors", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 8);
    public static final SCOType.Field measureMode$FIELD = Type._addManagedField($TYPE, "measureMode", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(MeasureMode.class), null, 9);
    public static final SCOType.Field minLambda$FIELD = Type._addManagedField($TYPE, "minLambda", 0x200002, de.grogra.reflect.Type.INT, null, 10);
    public static final SCOType.Field spectralBuckets$FIELD = Type._addManagedField($TYPE, "spectralBuckets", 0x200002, de.grogra.reflect.Type.INT, null, 11);
    public static final SCOType.Field importanceCurve$FIELD = Type._addManagedField($TYPE, "importanceCurve", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(SpectralCurve.class), null, 12);
    public static final SCOType.Field sensitivityCurves$FIELD = Type._addManagedField($TYPE, "sensitivityCurves", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(SpectralCurve[].class), null, 13);
    public static final SCOType.Field dispersion$FIELD = Type._addManagedField($TYPE, "dispersion", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 14);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isEnableSensors() {
        return this.enableSensors;
    }

    public boolean isDispersion() {
        return this.dispersion;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRayCount() {
        return this.rayCount;
    }

    public int getMinLambda() {
        return this.minLambda;
    }

    public int getSpectralBuckets() {
        return this.spectralBuckets;
    }

    public float getFlatness() {
        return this.flatness;
    }

    public double getMinPower() {
        return this.minPower;
    }

    public double getTargetVariance() {
        return this.targetVariance;
    }

    public double getCutoffPower() {
        return this.cutoffPower;
    }

    public ObjectFilter getMeasureObjectFilter() {
        return this.measureObjectFilter;
    }

    public boolean[] getVisibleLayers() {
        return this.visibleLayers;
    }

    public MeasureMode getMeasureMode() {
        return this.measureMode;
    }

    public SpectralCurve getImportanceCurve() {
        return this.importanceCurve;
    }

    public SpectralCurve[] getSensitivityCurves() {
        return this.sensitivityCurves;
    }

    private int getMeasureDimensions() {
        switch (this.measureMode) {
            case RGB: {
                return 3;
            }
            case FULL_SPECTRUM: {
                return this.spectralBuckets;
            }
            case INTEGRATED_SPECTRUM: {
                return this.sensitivityCurves.length;
            }
        }
        return 0;
    }

    public FluxLightModelTracer() {
        this(30000, 10, 0.001, true);
    }

    public FluxLightModelTracer(int n, int n2, double d, boolean bl) {
        this.setEnableSensors(bl);
        this.setRayCount(n);
        this.setDepth(n2);
        this.setCutoffPower(d);
        this.measureObjectFilter = new AllFilter();
        this.visibleLayers = new boolean[16];
        for (int i = 0; i < 16; ++i) {
            this.visibleLayers[i] = true;
        }
    }

    private void setupJOCL() {
        if (this.computeContext == null) {
            Workbench workbench = Workbench.current();
            workbench.beginStatus((Object)this);
            this.setProgress("Init OpenCL", -1.0f);
            this.computeContext = GPUFluxInit.initComputeContext(true, new String[]{"CL_KHR_GLOBAL_INT32_BASE_ATOMICS"});
            this.setProgress("", 2.0f);
        }
    }

    private void loadKernel(String string) {
        Workbench workbench = Workbench.current();
        workbench.beginStatus((Object)this);
        this.setProgress("Load kernel", -1.0f);
        try {
            boolean bl = false;
            switch (this.measureMode) {
                case RGB: {
                    break;
                }
                case FULL_SPECTRUM: {
                    bl = true;
                    string = string + " -D MEASURE_FULL_SPECTRUM";
                    string = string + " -D MEASURE_MIN_LAMBDA=" + this.minLambda;
                    string = string + " -D MEASURE_MAX_LAMBDA=" + this.maxLambda;
                    string = string + " -D MEASURE_SPECTRUM_BINS=" + this.spectralBuckets;
                    break;
                }
                case INTEGRATED_SPECTRUM: {
                    bl = true;
                    string = string + " -D NUM_SENSITIVITYSPDS=" + this.sensitivityCurves.length;
                }
            }
            if (bl) {
                string = string + " -D SPECTRAL";
                if (this.dispersion) {
                    string = string + " -D SPECTRUM_DISPERSION";
                }
            }
            if (this.enableSensors) {
                string = string + " -D ENABLE_SENSORS";
            }
            FluxSpectrum.SpectralDiscretization spectralDiscretization = FluxSpectrum.getDiscretization();
            string = string + " -D SPECTRAL_WAVELENGTH_MIN=" + spectralDiscretization.getLambdaMin();
            string = string + " -D SPECTRAL_WAVELENGTH_MAX=" + spectralDiscretization.getLambdaMax();
            string = string + " -D SPECTRAL_WAVELENGTH_BINS=" + spectralDiscretization.getLambdaBins();
            this.kernel = this.computeContext.createKernel("kernel/lightmodel_kernel.cl", "compute", string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setProgress("", 2.0f);
    }

    public void setEnableSensors(boolean bl) {
        this.enableSensors = bl;
    }

    public void setCutoffPower(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("cutoffPower must be a positive double but was " + d);
        }
        this.cutoffPower = d;
    }

    public void setDepth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("depth must be a positive integer but was " + n);
        }
        this.depth = n;
    }

    public void setRayCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("rayCount must be a positive integer but was " + n);
        }
        this.rayCount = n;
    }

    public void setSensitivityCurves(SpectralCurve[] spectralCurveArray) {
        this.sensitivityCurves = spectralCurveArray;
    }

    public void setImportanceCurve(SpectralCurve spectralCurve) {
        this.importanceCurve = spectralCurve;
    }

    public void setSpectralBuckets(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of spectral buckets must be strictly positive");
        }
        this.spectralBuckets = n;
    }

    public void setMeasureMode(MeasureMode measureMode) {
        this.measureMode = measureMode;
    }

    public void setSpectralRange(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("range must be non-empty: (" + n + "," + n2 + ")");
        }
        this.minLambda = n;
        this.maxLambda = n2;
    }

    private SharedBuffer serializeSensitivityCurves() {
        ComputeByteBuffer computeByteBuffer = this.computeContext.createByteBuffer();
        try {
            if (this.sensitivityCurves != null) {
                for (SpectralCurve spectralCurve : this.sensitivityCurves) {
                    FluxSpectrum.serialize(computeByteBuffer, spectralCurve);
                }
            }
            computeByteBuffer.writeInt(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        SharedBuffer sharedBuffer = this.computeContext.createSharedBuffer(computeByteBuffer, 36L);
        return sharedBuffer;
    }

    private void buildlights() {
        Workbench workbench = Workbench.current();
        if (workbench == null) {
            return;
        }
        GraphManager graphManager = workbench.getRegistry().getProjectGraph();
        Graph graph = GraphState.current((Graph)graphManager).getGraph();
        this.scene.buildLightsFromGraph(graph, null, this.measureObjectFilter, this.enableSensors, this, false);
        this.justBuildLights = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        Workbench workbench = Workbench.current();
        if (workbench == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("<html><pre>");
        stringBuffer.append("<B>GPUFlux Light Model</B>\n\n");
        workbench.beginStatus((Object)this);
        int n = FluxSettings.getModelSpectralLambdaStep();
        FluxSpectrum.setDiscretization(new FluxSpectrum.SpectralDiscretization(this.minLambda, this.maxLambda, n));
        this.useBih = false;
        if (this.importanceCurve == null) {
            this.importanceCurve = new ConstantSpectralCurve(1.0f);
        }
        switch (this.measureMode) {
            case INTEGRATED_SPECTRUM: {
                FluxSpectrum.setImportance(new SpectralCurve(){

                    public float sample(float f) {
                        float f2 = 0.0f;
                        if (FluxLightModelTracer.this.sensitivityCurves != null) {
                            for (SpectralCurve spectralCurve : FluxLightModelTracer.this.sensitivityCurves) {
                                f2 = Math.max(f2, spectralCurve.sample(f));
                            }
                        }
                        return FluxLightModelTracer.this.importanceCurve.sample(f) * f2;
                    }

                    public ManageableType getManageableType() {
                        return null;
                    }
                });
                break;
            }
            default: {
                FluxSpectrum.setImportance(this.importanceCurve);
            }
        }
        long l = 0L;
        long l2 = 0L;
        try {
            GraphManager graphManager = workbench.getRegistry().getProjectGraph();
            Graph graph = GraphState.current((Graph)graphManager).getGraph();
            this.setProgress("Build scene", -1.0f);
            this.setProgress("Build scene", -1.0f);
            l = System.currentTimeMillis();
            this.scene = new FluxScene();
            this.scene.buildSceneFromGraph(graph, null, this.measureObjectFilter, this.enableSensors, this, false, this.flatness);
            l = System.currentTimeMillis() - l;
            stringBuffer.append(this.scene.getLog());
            this.setupJOCL();
            stringBuffer.append(this.computeContext.getLog());
            if (!this.computeContext.valid()) {
                return;
            }
            this.setProgress("Serialize scene", -1.0f);
            l2 = System.currentTimeMillis();
            this.serializer = new FluxSceneSerializer();
            this.joclScene = new FluxJOCLScene(this.serializer, this.computeContext);
            this.measuringSetup = new MeasuringSetup();
            this.measuringSetup.buildSetup(2 * this.scene.getGroupCount(), this.scene);
            this.serializer.serializeScene(this.scene);
            this.serializer.serializeMeasureSetup(this.measuringSetup);
            this.joclScene.setupOCLBounds();
            this.joclScene.setupOCLScene(this.useBih);
            this.joclScene.setupOCLDetectors();
            this.joclScene.setupOCLSensors();
            l2 = System.currentTimeMillis() - l2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.justBuildLights = true;
            stringBuffer.append("\n<B>Profile Summary</B>\n");
            stringBuffer.append("    Construction time: " + l + " ms\n");
            stringBuffer.append("    Serialize time:    " + l2 + " ms\n");
            stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
            this.setProgress("Done", 2.0f);
            workbench.logGUIInfo(stringBuffer.append("</pre></html>").toString());
        }
    }

    public void compute() {
        this.compute(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compute(boolean bl, boolean bl2) {
        if (bl2 || this.scene == null) {
            this.build();
        } else if (!this.justBuildLights) {
            this.buildlights();
        }
        this.justBuildLights = false;
        if (!this.computeContext.valid()) {
            return;
        }
        Workbench workbench = Workbench.current();
        if (workbench == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("<html><pre>");
        stringBuffer.append("<B>GPUFluxLightModel</B>\n\n");
        workbench.beginStatus((Object)this);
        DeviceMonitor[] deviceMonitorArray = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            try {
                this.setProgress("Build scene", -1.0f);
                l = System.currentTimeMillis();
                this.setProgress("Build scene", -1.0f);
                SharedBuffer sharedBuffer = this.serializeSensitivityCurves();
                l = System.currentTimeMillis() - l;
                stringBuffer.append(this.scene.getSceneStats());
                if (this.scene.getLightCount() == 0) {
                    stringBuffer.append("Scene has no light sources!\n\n");
                } else {
                    int n;
                    java.nio.Buffer buffer;
                    Object object;
                    Object object2;
                    void var19_22;
                    this.irradiance = null;
                    this.power = null;
                    this.setProgress("Serialize scene", -1.0f);
                    this.joclScene.setupOCLLights();
                    this.setProgress("Load kernel", -1.0f);
                    this.loadKernel(this.useBih ? "-D BIH " : "-D BVH ");
                    int n2 = FluxSettings.getOCLInitialSampleCount();
                    this.maximumSampleCount = FluxSettings.getOCLMaximumSampleCount();
                    this.preferredDuration = FluxSettings.getOCLPreferredDuration();
                    AbstractList<Device> abstractList = this.computeContext.getDeviceList();
                    deviceMonitorArray = new DeviceMonitor[abstractList.size()];
                    this.openDeviceList = new ConcurrentLinkedQueue();
                    this.available = new Semaphore(abstractList.size());
                    this.measuringSetup.setDimensions(this.getMeasureDimensions());
                    for (int i = 0; i < abstractList.size(); ++i) {
                        Device device = abstractList.get(i);
                        DeviceMonitor object4 = new DeviceMonitor();
                        object4.smlprun = n2;
                        object4.totalsml = 0L;
                        object4.device = device;
                        object4.total_time = 0.0;
                        object4.powerBuffer = device.createBuffer(4 * this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement(), 1L);
                        object4.powerBuffer.clear();
                        object4.irradianceBuffer = device.createBuffer(4 * this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement(), 1L);
                        object4.irradianceBuffer.clear();
                        deviceMonitorArray[i] = object4;
                        this.openDeviceList.add(object4);
                        object4.start();
                    }
                    this.setProgress("Execute", -1.0f);
                    stringBuffer.append("<B>Settings</B>\n");
                    stringBuffer.append(FluxSettings.getLightModelSettingsLog());
                    stringBuffer.append(FluxSettings.getOpenCLSettingsLog());
                    stringBuffer.append("    <b>LightModel settings</b>\n");
                    Vector<Light> vector = new Vector<Light>();
                    for (FluxLight fluxLight : this.scene.getLights()) {
                        vector.add(fluxLight.getLight());
                    }
                    int n3 = this.varianceToSampleCount(vector, this.minPower, this.targetVariance);
                    stringBuffer.append("        Target sample count: " + n3 + "\n");
                    n3 = Math.min(n3, this.rayCount);
                    stringBuffer.append("        Cutoff sample count: " + n3 + "\n");
                    stringBuffer.append("        Depth: " + this.depth + "\n");
                    stringBuffer.append("        Minimum Power: " + this.minPower + "\n");
                    stringBuffer.append("        Spectral: " + (this.measureMode == MeasureMode.RGB ? "RGB" : (this.measureMode == MeasureMode.INTEGRATED_SPECTRUM ? "INTEGRATED SPECTRUM" : "FULL SPECTRUM")) + "\n");
                    stringBuffer.append("        Dispersian: " + (this.dispersion ? "Enabled" : "Disabled") + "\n");
                    stringBuffer.append("        Lambda range: [" + this.minLambda + "," + this.maxLambda + "]\n");
                    stringBuffer.append("        Spectral buckets: " + this.spectralBuckets + "\n");
                    stringBuffer.append("        Sensors: " + (this.enableSensors ? "Enabled" : "Disabled") + "\n");
                    stringBuffer.append("\n");
                    stringBuffer.append("<B>Render Profile</B>\n");
                    l2 = System.currentTimeMillis();
                    boolean bl3 = false;
                    this.finnished = false;
                    while (var19_22 < n3) {
                        int n4;
                        try {
                            this.available.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            Object var31_35 = null;
                            stringBuffer.append("<B>Profile Summary</B>\n");
                            stringBuffer.append("    Build time: " + l + " ms\n");
                            stringBuffer.append("    Render time:       " + l2 + " ms\n");
                            stringBuffer.append("    Load Result time:  " + l3 + " ms\n");
                            if (l2 > 0L) {
                                stringBuffer.append("    Performance:       " + (double)(l4 / l2) / 1000.0 + " MSmpl/s\n");
                            }
                            if (deviceMonitorArray != null) {
                                DeviceMonitor deviceMonitor2;
                                long l5 = 0L;
                                DeviceMonitor[] deviceMonitorArray2 = deviceMonitorArray;
                                int n5 = deviceMonitorArray2.length;
                                for (int i = 0; i < n5; l5 += deviceMonitor2.totalsml, ++i) {
                                    deviceMonitor2 = deviceMonitorArray2[i];
                                }
                                if (l5 > 0L) {
                                    for (DeviceMonitor deviceMonitor2 : deviceMonitorArray) {
                                        stringBuffer.append("        " + deviceMonitor2.totalsml * 100L / l5 + "%: \t" + deviceMonitor2.device.getName() + "\n");
                                    }
                                }
                            }
                            stringBuffer.append("    Device Memory usage:  " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                            this.setProgress("Done", 2.0f);
                            workbench.logGUIInfo(stringBuffer.append("</pre></html>").toString());
                            this.available = null;
                            this.openDeviceList = null;
                            return;
                        }
                        DeviceMonitor deviceMonitor = (DeviceMonitor)this.openDeviceList.remove();
                        deviceMonitor.smlprun = n4 = Math.min(deviceMonitor.smlprun, n3 - var19_22);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 1, n4);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 2, (int)var19_22);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 3, n3);
                        deviceMonitor.device.setKernelArgMemBuffer(this.kernel, 4, deviceMonitor.powerBuffer);
                        deviceMonitor.device.setKernelArgMemBuffer(this.kernel, 5, deviceMonitor.irradianceBuffer);
                        this.joclScene.setKernelArgDetectors(deviceMonitor.device, this.kernel, 6);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 7, this.measuringSetup.getNumMeasurementBits());
                        this.joclScene.setKernelArgScene(deviceMonitor.device, this.kernel, 8);
                        this.joclScene.setKernelArgSensors(deviceMonitor.device, this.kernel, 21);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 25, this.depth);
                        deviceMonitor.device.setKernelArgFloat(this.kernel, 26, (float)this.cutoffPower);
                        this.joclScene.setKernelArgBounds(deviceMonitor.device, this.kernel, 27);
                        deviceMonitor.device.setKernelArgMemBuffer(this.kernel, 28, sharedBuffer);
                        deviceMonitor.device.setKernelArgInt(this.kernel, 29, 0);
                        deviceMonitor.device.executeKernel(this.kernel, n4, deviceMonitor.event);
                        deviceMonitor.resume.release();
                        this.setProgress("Execute", (float)var19_22 / (float)n3);
                        var19_22 += n4;
                        l4 += (long)n4;
                    }
                    this.finnished = true;
                    DeviceMonitor[] deviceMonitorArray2 = deviceMonitorArray;
                    int n5 = deviceMonitorArray2.length;
                    for (int i = 0; i < n5; ++i) {
                        DeviceMonitor deviceMonitor = deviceMonitorArray2[i];
                        deviceMonitor.resume.release();
                    }
                    this.computeContext.finish();
                    l2 = System.currentTimeMillis() - l2;
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        stringBuffer.append("Device: " + deviceMonitor.device.getName() + "\n");
                        stringBuffer.append("\tTotal samples:     " + deviceMonitor.totalsml + "\n");
                        stringBuffer.append("\tSamples per batch: " + deviceMonitor.smlprun + "\n");
                        stringBuffer.append("\tTotal trace time:  " + (int)(deviceMonitor.total_time * 1000.0) + " ms\n");
                        stringBuffer.append("\tSamples per second: " + (double)deviceMonitor.totalsml / 1000000.0 / deviceMonitor.total_time + " MSmpl/s\n");
                    }
                    this.setProgress("Load results", -1.0f);
                    l3 = System.currentTimeMillis();
                    float[] fArray = new float[this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement()];
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        object2 = new byte[4 * this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement()];
                        deviceMonitor.powerBuffer.readBuffer((byte[])object2);
                        deviceMonitor.powerBuffer = null;
                        object = ByteBuffer.wrap(object2);
                        ((ByteBuffer)object).order(deviceMonitor.device.getByteOrder());
                        buffer = ((ByteBuffer)object).asFloatBuffer();
                        for (int i = 0; i < this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement(); ++i) {
                            int n6 = i;
                            fArray[n6] = fArray[n6] + ((FloatBuffer)buffer).get(i);
                        }
                    }
                    this.power = this.loadMeasuredData(fArray);
                    Object var20_28 = null;
                    float[] fArray2 = new float[this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement()];
                    DeviceMonitor[] deviceMonitorArray3 = deviceMonitorArray;
                    int n7 = deviceMonitorArray3.length;
                    for (n = 0; n < n7; ++n) {
                        object2 = deviceMonitorArray3[n];
                        object = new byte[4 * this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement()];
                        object2.irradianceBuffer.readBuffer((byte[])object);
                        object2.irradianceBuffer = null;
                        buffer = ByteBuffer.wrap((byte[])object);
                        ((ByteBuffer)buffer).order(object2.device.getByteOrder());
                        FloatBuffer floatBuffer = ((ByteBuffer)buffer).asFloatBuffer();
                        for (int i = 0; i < this.measuringSetup.getDimensions() * this.measuringSetup.getNumMeasurement(); ++i) {
                            int n8 = i;
                            fArray2[n8] = fArray2[n8] + floatBuffer.get(i);
                        }
                    }
                    this.irradiance = this.loadMeasuredData(fArray2);
                    Object var21_34 = null;
                    l3 = System.currentTimeMillis() - l3;
                    stringBuffer.append("\n");
                    deviceMonitorArray3 = deviceMonitorArray;
                    n7 = deviceMonitorArray3.length;
                    for (n = 0; n < n7; ++n) {
                        object2 = deviceMonitorArray3[n];
                        stringBuffer.append(object2.log + "\n");
                    }
                }
                Object var31_36 = null;
                stringBuffer.append("<B>Profile Summary</B>\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var31_37 = null;
                stringBuffer.append("<B>Profile Summary</B>\n");
                stringBuffer.append("    Build time: " + l + " ms\n");
                stringBuffer.append("    Render time:       " + l2 + " ms\n");
                stringBuffer.append("    Load Result time:  " + l3 + " ms\n");
                if (l2 > 0L) {
                    stringBuffer.append("    Performance:       " + (double)(l4 / l2) / 1000.0 + " MSmpl/s\n");
                }
                if (deviceMonitorArray != null) {
                    DeviceMonitor deviceMonitor3;
                    long l8 = 0L;
                    DeviceMonitor[] deviceMonitorArray3 = deviceMonitorArray;
                    int n = deviceMonitorArray3.length;
                    for (int i = 0; i < n; l8 += deviceMonitor3.totalsml, ++i) {
                        deviceMonitor3 = deviceMonitorArray3[i];
                    }
                    if (l8 > 0L) {
                        for (DeviceMonitor deviceMonitor3 : deviceMonitorArray) {
                            stringBuffer.append("        " + deviceMonitor3.totalsml * 100L / l8 + "%: \t" + deviceMonitor3.device.getName() + "\n");
                        }
                    }
                }
                stringBuffer.append("    Device Memory usage:  " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                this.setProgress("Done", 2.0f);
                workbench.logGUIInfo(stringBuffer.append("</pre></html>").toString());
                this.available = null;
                this.openDeviceList = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var31_38 = null;
            stringBuffer.append("<B>Profile Summary</B>\n");
            stringBuffer.append("    Build time: " + l + " ms\n");
            stringBuffer.append("    Render time:       " + l2 + " ms\n");
            stringBuffer.append("    Load Result time:  " + l3 + " ms\n");
            if (l2 > 0L) {
                stringBuffer.append("    Performance:       " + (double)(l4 / l2) / 1000.0 + " MSmpl/s\n");
            }
            if (deviceMonitorArray != null) {
                DeviceMonitor deviceMonitor4;
                long l6 = 0L;
                DeviceMonitor[] deviceMonitorArray4 = deviceMonitorArray;
                int n = deviceMonitorArray4.length;
                for (int i = 0; i < n; l6 += deviceMonitor4.totalsml, ++i) {
                    deviceMonitor4 = deviceMonitorArray4[i];
                }
                if (l6 > 0L) {
                    for (DeviceMonitor deviceMonitor4 : deviceMonitorArray) {
                        stringBuffer.append("        " + deviceMonitor4.totalsml * 100L / l6 + "%: \t" + deviceMonitor4.device.getName() + "\n");
                    }
                }
            }
            stringBuffer.append("    Device Memory usage:  " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
            this.setProgress("Done", 2.0f);
            workbench.logGUIInfo(stringBuffer.append("</pre></html>").toString());
            this.available = null;
            this.openDeviceList = null;
            throw throwable;
        }
        stringBuffer.append("    Build time: " + l + " ms\n");
        stringBuffer.append("    Render time:       " + l2 + " ms\n");
        stringBuffer.append("    Load Result time:  " + l3 + " ms\n");
        if (l2 > 0L) {
            stringBuffer.append("    Performance:       " + (double)(l4 / l2) / 1000.0 + " MSmpl/s\n");
        }
        if (deviceMonitorArray != null) {
            DeviceMonitor deviceMonitor5;
            long l7 = 0L;
            DeviceMonitor[] deviceMonitorArray5 = deviceMonitorArray;
            int n = deviceMonitorArray5.length;
            for (int i = 0; i < n; l7 += deviceMonitor5.totalsml, ++i) {
                deviceMonitor5 = deviceMonitorArray5[i];
            }
            if (l7 > 0L) {
                for (DeviceMonitor deviceMonitor5 : deviceMonitorArray) {
                    stringBuffer.append("        " + deviceMonitor5.totalsml * 100L / l7 + "%: \t" + deviceMonitor5.device.getName() + "\n");
                }
            }
        }
        stringBuffer.append("    Device Memory usage:  " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
        this.setProgress("Done", 2.0f);
        workbench.logGUIInfo(stringBuffer.append("</pre></html>").toString());
        this.available = null;
        this.openDeviceList = null;
    }

    private Experiment loadMeasuredData(float[] fArray) {
        double d = 1.0 / (double)this.rayCount;
        return new Experiment(this.scene.getNodeToGroup(), this.measuringSetup.LoadMeasuredData(fArray, d), new Measurement(this.getMeasureDimensions()));
    }

    @Deprecated
    public Spectrum3d getSensedIrradiance(Node node) {
        Measurement measurement = this.getSensedIrradianceMeasurement(node);
        return new Spectrum3d(measurement.data[0], measurement.data[1], measurement.data[2]);
    }

    @Deprecated
    public Spectrum3d getAbsorbedPower(Node node) {
        Measurement measurement = this.getAbsorbedPowerMeasurement(node);
        return new Spectrum3d(measurement.data[0], measurement.data[1], measurement.data[2]);
    }

    public Experiment getSensedIrradiance() {
        return this.irradiance;
    }

    public Experiment getAbsorbedPower() {
        return this.power;
    }

    public Measurement getSensedIrradianceMeasurement(Node node) {
        if (!this.enableSensors) {
            throw new UnsupportedOperationException("Sensors are currently disabled");
        }
        return this.irradiance.getMeasurement(node);
    }

    public Measurement getAbsorbedPowerMeasurement(Node node) {
        if (this.power == null) {
            return new Measurement();
        }
        return this.power.getMeasurement(node);
    }

    public void setProgress(String string, float f) {
        Workbench workbench = Workbench.current();
        workbench.setStatus((Object)this, string);
        if (f < 0.0f) {
            workbench.setIndeterminateProgress((Object)this);
        } else if (f == 2.0f) {
            workbench.clearProgress((Object)this);
        } else {
            workbench.setProgress((Object)this, f);
        }
    }

    public void showMessage(String string) {
        Workbench workbench = Workbench.current();
        workbench.logGUIInfo(string);
    }

    public void setMeasureObjectFilter(ObjectFilter objectFilter) {
        this.measureObjectFilter = objectFilter;
    }

    public int varianceToSampleCount(AbstractList<Light> abstractList, double d, double d2) {
        double d3 = FluxLightModelTracer.estimateTotalPower(abstractList, this.scene.getEnvironment());
        return FluxLightModelTracer.varianceToSampleCount(d3, d, d2);
    }

    public double sampleCountToVariance(AbstractList<Light> abstractList, double d, int n) {
        double d2 = FluxLightModelTracer.estimateTotalPower(abstractList, this.scene.getEnvironment());
        return FluxLightModelTracer.sampleCountToVariance(d2, d, n);
    }

    private static int varianceToSampleCount(double d, double d2, double d3) {
        if (d == 0.0) {
            return 0;
        }
        double d4 = Math.min(1.0, d2 / d);
        if (d3 == 0.0) {
            return Integer.MAX_VALUE;
        }
        int n = (int)Math.ceil(d * d2 * (1.0 - d4) / d3);
        return n;
    }

    private static double sampleCountToVariance(double d, double d2, int n) {
        double d3 = Math.min(1.0, d2 / d);
        double d4 = d / d * (double)(n * n) * (double)n * d3 * (1.0 - d3);
        return d4;
    }

    private static double estimateTotalPower(AbstractList<Light> abstractList, Environment environment) {
        double d = 0.0;
        for (Light light : abstractList) {
            d += light.getTotalPower(environment);
        }
        return d;
    }

    public void setTargetVariance(double d, double d2) {
        this.minPower = d;
        this.targetVariance = d2;
    }

    public void setDispersion(boolean bl) {
        this.dispersion = bl;
    }

    public void setFlatness(float f) {
        this.flatness = f;
    }

    public int getMaxLambda() {
        return this.maxLambda;
    }

    public void setLayerVisible(int n, boolean bl) {
        this.visibleLayers[n] = bl;
    }

    static /* synthetic */ boolean[] access$1102(FluxLightModelTracer fluxLightModelTracer, boolean[] blArray) {
        fluxLightModelTracer.visibleLayers = blArray;
        return blArray;
    }

    static /* synthetic */ SpectralCurve[] access$1402(FluxLightModelTracer fluxLightModelTracer, SpectralCurve[] spectralCurveArray) {
        fluxLightModelTracer.sensitivityCurves = spectralCurveArray;
        return spectralCurveArray;
    }

    static {
        $TYPE.validate();
    }

    class DeviceMonitor
    extends Thread {
        Semaphore resume = new Semaphore(0);
        String log = "";
        Buffer powerBuffer;
        Buffer irradianceBuffer;
        cl_event event = new cl_event();
        int smlprun;
        long totalsml;
        Device device;
        double passed_time;
        double samplesPerSecond;
        double total_time;

        DeviceMonitor() {
        }

        public void run() {
            while (true) {
                try {
                    this.resume.acquire();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (FluxLightModelTracer.this.finnished) break;
                CL.clWaitForEvents((int)1, (cl_event[])new cl_event[]{this.event});
                this.passed_time = JOCLEvent.getEndTime(this.event) - JOCLEvent.getStartTime(this.event);
                this.total_time += this.passed_time;
                this.samplesPerSecond = (double)this.smlprun / this.passed_time;
                if (FluxTracer.BATCH_LOGGING_ENABLED) {
                    this.log = this.log + "<i>";
                    this.log = this.log + "Sample batch\n";
                    this.log = this.log + "    Device:      " + this.device.getName() + "\n";
                    this.log = this.log + "    Batch size: " + this.smlprun + "\n";
                    this.log = this.log + "    Render time: " + this.passed_time * 1000.0 + "ms\n";
                    this.log = this.log + "    Performance: " + this.samplesPerSecond / 1000000.0 + " MSmpl\n";
                    this.log = this.log + "\n</i>";
                }
                this.totalsml += (long)this.smlprun;
                int n = Math.min(FluxLightModelTracer.this.maximumSampleCount, (int)(this.samplesPerSecond * FluxLightModelTracer.this.preferredDuration));
                this.smlprun = (int)(FluxTracer.BATCH_BALANCE_SMOOTH * (double)n + (1.0 - FluxTracer.BATCH_BALANCE_SMOOTH) * (double)this.smlprun);
                FluxLightModelTracer.this.openDeviceList.add(this);
                FluxLightModelTracer.this.available.release();
            }
        }
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 15;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(FluxLightModelTracer fluxLightModelTracer, SCOType sCOType) {
            super((Object)fluxLightModelTracer, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 8: {
                    ((FluxLightModelTracer)((Object)object)).enableSensors = bl;
                    return;
                }
                case 14: {
                    ((FluxLightModelTracer)((Object)object)).dispersion = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 8: {
                    return ((FluxLightModelTracer)((Object)object)).isEnableSensors();
                }
                case 14: {
                    return ((FluxLightModelTracer)((Object)object)).isDispersion();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 6: {
                    ((FluxLightModelTracer)((Object)object)).depth = n2;
                    return;
                }
                case 7: {
                    ((FluxLightModelTracer)((Object)object)).rayCount = n2;
                    return;
                }
                case 10: {
                    ((FluxLightModelTracer)((Object)object)).minLambda = n2;
                    return;
                }
                case 11: {
                    ((FluxLightModelTracer)((Object)object)).spectralBuckets = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 6: {
                    return ((FluxLightModelTracer)((Object)object)).getDepth();
                }
                case 7: {
                    return ((FluxLightModelTracer)((Object)object)).getRayCount();
                }
                case 10: {
                    return ((FluxLightModelTracer)((Object)object)).getMinLambda();
                }
                case 11: {
                    return ((FluxLightModelTracer)((Object)object)).getSpectralBuckets();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((FluxLightModelTracer)((Object)object)).flatness = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((FluxLightModelTracer)((Object)object)).getFlatness();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 3: {
                    ((FluxLightModelTracer)((Object)object)).minPower = d;
                    return;
                }
                case 4: {
                    ((FluxLightModelTracer)((Object)object)).targetVariance = d;
                    return;
                }
                case 5: {
                    ((FluxLightModelTracer)((Object)object)).cutoffPower = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((FluxLightModelTracer)((Object)object)).getMinPower();
                }
                case 4: {
                    return ((FluxLightModelTracer)((Object)object)).getTargetVariance();
                }
                case 5: {
                    return ((FluxLightModelTracer)((Object)object)).getCutoffPower();
                }
            }
            return super.getDouble(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((FluxLightModelTracer)((Object)object)).measureObjectFilter = (ObjectFilter)((Object)object2);
                    return;
                }
                case 1: {
                    FluxLightModelTracer.access$1102((FluxLightModelTracer)((Object)object), (boolean[])object2);
                    return;
                }
                case 9: {
                    ((FluxLightModelTracer)((Object)object)).measureMode = (MeasureMode)((Object)object2);
                    return;
                }
                case 12: {
                    ((FluxLightModelTracer)((Object)object)).importanceCurve = (SpectralCurve)((Object)object2);
                    return;
                }
                case 13: {
                    FluxLightModelTracer.access$1402((FluxLightModelTracer)((Object)object), (SpectralCurve[])object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((FluxLightModelTracer)((Object)object)).getMeasureObjectFilter();
                }
                case 1: {
                    return ((FluxLightModelTracer)((Object)object)).getVisibleLayers();
                }
                case 9: {
                    return ((FluxLightModelTracer)((Object)object)).getMeasureMode();
                }
                case 12: {
                    return ((FluxLightModelTracer)((Object)object)).getImportanceCurve();
                }
                case 13: {
                    return ((FluxLightModelTracer)((Object)object)).getSensitivityCurves();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new FluxLightModelTracer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MeasureMode {
        FULL_SPECTRUM,
        INTEGRATED_SPECTRUM,
        RGB;

    }
}

