/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.tracer;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.GPUFluxInit;
import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.scene.FluxJOCLScene;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.FluxSceneSerializer;
import de.grogra.gpuflux.scene.filter.NoneFilter;
import de.grogra.gpuflux.tracer.FluxTracer;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.ViewConfig3D;
import java.io.IOException;
import java.util.Random;

public class FluxPathTracer
extends FluxTracer {
    boolean terminate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trace() throws IOException {
        long l;
        long l2;
        long l3;
        long l4;
        StringBuffer stringBuffer;
        block12: {
            block11: {
                stringBuffer = new StringBuffer("<html><pre>");
                stringBuffer.append("<B>GPUFlux path Tracer</B>\n\n");
                l4 = 0L;
                l3 = 0L;
                l2 = 0L;
                l = 0L;
                try {
                    this.setProgress("Build scene", -1.0f);
                    l4 = System.currentTimeMillis();
                    FluxScene fluxScene = new FluxScene();
                    fluxScene.buildSceneFromGraph(this.view.getGraph(), (ViewConfig3D)((View3D)this.view), new NoneFilter(), false, this, true, FluxSettings.getModelFlatness());
                    l4 = System.currentTimeMillis() - l4;
                    stringBuffer.append(fluxScene.getLog());
                    stringBuffer.append(fluxScene.getSceneStats());
                    this.setProgress("Init compute context", -1.0f);
                    l3 = System.currentTimeMillis();
                    ComputeContext computeContext = GPUFluxInit.initComputeContext(false, null);
                    stringBuffer.append(computeContext.aquireLog());
                    if (!computeContext.valid()) {
                        Object var46_8 = null;
                        stringBuffer.append("\n<B>Profile Summary</B>\n");
                        break block11;
                    }
                    Device device = computeContext.getPrimaryDevice();
                    stringBuffer.append("Primary Device: \n" + device + "\n");
                    this.setProgress("Serialize scene", -1.0f);
                    FluxSceneSerializer fluxSceneSerializer = new FluxSceneSerializer();
                    FluxJOCLScene fluxJOCLScene = new FluxJOCLScene(fluxSceneSerializer, computeContext);
                    fluxSceneSerializer.serializeScene(fluxScene);
                    fluxJOCLScene.setupOCLScene(this.useBih);
                    fluxJOCLScene.setupOCLCamera(this.width, this.height);
                    fluxJOCLScene.setupOCLLights();
                    l3 = System.currentTimeMillis() - l3;
                    this.setProgress("Load kernel", -1.0f);
                    Kernel kernel = computeContext.createKernel("kernel/pt_kernel.cl", "computeImage", this.getKernelCompilationArguments(true, false));
                    Buffer buffer = device.createBuffer(16 * this.width * this.height, 1L);
                    buffer.clear();
                    stringBuffer.append(computeContext.getLog());
                    stringBuffer.append("<B>Settings</B>\n");
                    stringBuffer.append(FluxSettings.getTracerLog());
                    stringBuffer.append("        Image size:   " + this.width + " x " + this.height + "\n");
                    stringBuffer.append("        Total pixels: " + this.width * this.height + "\n");
                    stringBuffer.append("\n");
                    this.terminate = false;
                    Thread thread = new Thread(){

                        public void run() {
                            new FluxTracer.MsgBox(FluxPathTracer.this, null, "Progressive rendering in progress...");
                            FluxPathTracer.this.terminate = true;
                        }
                    };
                    thread.start();
                    Random random = new Random(0L);
                    int n = FluxSettings.getRenderDepth();
                    double d = FluxSettings.getOCLPreferredDuration();
                    float f = FluxSettings.getRenderMinPower();
                    int n2 = FluxSettings.getOCLInitialSampleCount();
                    int n3 = FluxSettings.getOCLMaximumSampleCount();
                    int n4 = n2 / fluxScene.getSampleCount();
                    long l5 = System.currentTimeMillis();
                    int n5 = n3 / fluxScene.getSampleCount();
                    int n6 = Math.min(n4, this.width * this.height);
                    stringBuffer.append("<B>Render Profile</B>\n");
                    while (!this.terminate) {
                        int n7;
                        int n8 = (int)Math.ceil((double)(this.width * this.height) / (double)n6);
                        if (BATCH_LOGGING_ENABLED) {
                            stringBuffer.append("\n<i>Iteration</i>\n");
                            stringBuffer.append("Samples per execution: " + n6 + "\n\n");
                        }
                        double d2 = Double.MAX_VALUE;
                        int n9 = (int)Math.ceil((double)(this.width * this.height) / (double)n8);
                        int n10 = 0;
                        for (n7 = 0; n7 < n8; ++n7) {
                            this.setProgress("Execute kernel", -1.0f);
                            int n11 = Math.min(n9, this.width * this.height - n10);
                            long l6 = System.currentTimeMillis();
                            device.setKernelArgMemBuffer(kernel, 1, buffer);
                            device.setKernelArgInt(kernel, 2, this.width);
                            device.setKernelArgInt(kernel, 3, this.height);
                            device.setKernelArgInt(kernel, 4, n11);
                            device.setKernelArgInt(kernel, 5, n10);
                            fluxJOCLScene.setKernelArgScene(device, kernel, 6);
                            fluxJOCLScene.setKernelArgCamera(device, kernel, 19);
                            device.setKernelArgInt(kernel, 20, random.nextInt());
                            device.setKernelArgInt(kernel, 21, n);
                            device.setKernelArgFloat(kernel, 22, f);
                            device.finish();
                            l6 = System.currentTimeMillis();
                            device.executeKernel(kernel, n11);
                            n10 += n11;
                            l += (long)n11;
                            device.finish();
                            long l7 = System.currentTimeMillis() - l6;
                            l2 += l7;
                            if (BATCH_LOGGING_ENABLED) {
                                stringBuffer.append("<i>Sample batch</i>\n");
                                stringBuffer.append("    Batch size:  " + n11 + " samples\n");
                                stringBuffer.append("    Render time: " + l7 + " ms\n");
                                if (l7 > 0L) {
                                    stringBuffer.append("    Performance: " + (double)((long)n11 / l7) / 1000.0 + " MSmpl\n");
                                }
                            }
                            double d3 = 1000.0 * (double)n11 / (double)Math.max(l7, 1L);
                            d2 = Math.min(d3, d2);
                            long l8 = System.currentTimeMillis() - l5;
                            if (!((double)l8 / 1000.0 > d)) continue;
                            this.displayImage(buffer, device.getByteOrder());
                            l5 = System.currentTimeMillis();
                        }
                        n7 = Math.min(n5, (int)(d2 * d));
                        n6 = (int)(BATCH_BALANCE_SMOOTH * (double)n7 + (1.0 - BATCH_BALANCE_SMOOTH) * (double)n6);
                    }
                    stringBuffer.append("Device: " + device.getName() + "\n");
                    stringBuffer.append("\tTotal samples:     " + l + "\n");
                    stringBuffer.append("\tSamples per batch: " + n6 + "\n");
                    stringBuffer.append("\tTotal trace time:  " + (int)(l2 * 1000L) + " ms\n");
                    stringBuffer.append("\tSamples per second: " + (double)l / 1000000.0 / (double)l2 + " MSmpl/s\n");
                    this.displayImage(buffer, device.getByteOrder());
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var46_10 = null;
                    stringBuffer.append("\n<B>Profile Summary</B>\n");
                    stringBuffer.append("    Construction time: " + l4 + " ms\n");
                    stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
                    stringBuffer.append("    Render time:       " + l2 + " ms\n");
                    if (l2 > 0L) {
                        stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
                    }
                    stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                    this.setProgress("Done", 2.0f);
                    this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
                    throw throwable;
                }
            }
            stringBuffer.append("    Construction time: " + l4 + " ms\n");
            stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
            stringBuffer.append("    Render time:       " + l2 + " ms\n");
            if (l2 > 0L) {
                stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
            }
            stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
            this.setProgress("Done", 2.0f);
            this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
            return;
        }
        Object var46_9 = null;
        stringBuffer.append("\n<B>Profile Summary</B>\n");
        stringBuffer.append("    Construction time: " + l4 + " ms\n");
        stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
        stringBuffer.append("    Render time:       " + l2 + " ms\n");
        if (l2 > 0L) {
            stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
        }
        stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
        this.setProgress("Done", 2.0f);
        this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
    }
}

