/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SpectralLightMap;
import de.grogra.imp3d.objects.SpectralLightMapNode;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.ClassAdapter;
import de.grogra.util.Quantity;
import java.util.Random;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class SpectralLight
extends ShareableBase
implements Light {
    SpectralLightMap spectrum = new SpectralLightMapNode();
    float power = 100.0f;
    Light light = new PointLight();
    public static final Type $TYPE = new Type(SpectralLight.class);
    public static final SCOType.Field spectrum$FIELD = Type._addManagedField($TYPE, "spectrum", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(SpectralLightMap.class), null, 0);
    public static final SCOType.Field power$FIELD = Type._addManagedField($TYPE, "power", 0x200000, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field light$FIELD = Type._addManagedField($TYPE, "light", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Light.class), null, 2);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        this.power = f;
    }

    public SpectralLightMap getSpectrum() {
        return this.spectrum;
    }

    public void setSpectrum(SpectralLightMap spectralLightMap) {
        spectrum$FIELD.setObject((Object)this, (Object)spectralLightMap);
    }

    public SpectralLight() {
    }

    public SpectralLight(SpectralCurve spectralCurve) {
        this.setSpectrum(spectralCurve);
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public void setSpectrum(SpectralCurve spectralCurve) {
        this.setSpectrum(new SpectralLightMapNode(spectralCurve));
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit((Light)this);
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        this.light.generateRandomRays(environment, vector3f, spectrum, rayList, bl, random);
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        float f = this.light.computeBSDF(environment, vector3f, spectrum, vector3f2, bl, spectrum2);
        return f;
    }

    public int getLightType() {
        return this.light.getLightType();
    }

    public double getTotalPower(Environment environment) {
        int n = this.light.getAverageColor();
        double d = this.light.getTotalPower(environment);
        double d2 = (float)((n >> 0 & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF)) / 256.0f;
        return d / d2 * d;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        this.light.generateRandomOrigins(environment, rayList, random);
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        return this.light.computeExitance(environment, spectrum);
    }

    public int getFlags() {
        return this.light.getFlags();
    }

    public int getAverageColor() {
        return this.light.getAverageColor();
    }

    public boolean isShadowless() {
        return this.light.isShadowless();
    }

    public boolean isIgnoredWhenHit() {
        return this.light.isIgnoredWhenHit();
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        return this.light.completeRay(environment, point3d, ray);
    }

    static {
        power$FIELD.setQuantity(Quantity.POWER);
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 3;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SpectralLight spectralLight, SCOType sCOType) {
            super((Object)spectralLight, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 1: {
                    ((SpectralLight)((Object)object)).power = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((SpectralLight)((Object)object)).getPower();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((SpectralLight)((Object)object)).spectrum = (SpectralLightMap)object2;
                    return;
                }
                case 2: {
                    ((SpectralLight)((Object)object)).light = (Light)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((SpectralLight)((Object)object)).getSpectrum();
                }
                case 2: {
                    return ((SpectralLight)((Object)object)).light;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new SpectralLight();
        }
    }
}

