/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.numeric;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import de.grogra.numeric.Monitor;
import de.grogra.numeric.NumericException;
import de.grogra.numeric.ODE;
import de.grogra.numeric.Solver;
import de.grogra.numeric.cvode.CVODE;
import de.grogra.numeric.cvode.CVRhsFn;
import de.grogra.numeric.cvode.CVRootFn;
import de.grogra.numeric.cvode.N_Vector;
import java.util.Map;

public class CVodeAdapter
implements Solver {
    double absTolDefault = 1.0E-4;
    double relTolDefault = 1.0E-4;
    double[] absTol;
    int nrtfn;
    Monitor monitor;

    public void setMonitor(int n, Monitor monitor) throws NumericException {
        if (n < 0) {
            throw new NumericException("number of monitor functions must be non-negative");
        }
        this.nrtfn = n;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(final ODE oDE, double d, double[] dArray, double d2, double[] dArray2) throws NumericException {
        DoubleByReference doubleByReference;
        assert (dArray.length == dArray2.length);
        N_Vector n_Vector = null;
        Pointer pointer = Pointer.NULL;
        final int n = dArray.length;
        CVRhsFn cVRhsFn = new CVRhsFn(){
            final double[] state;
            final double[] rate;
            {
                this.state = new double[n];
                this.rate = new double[n];
            }

            public int callback(double d, N_Vector n_Vector, N_Vector n_Vector2, Pointer pointer) {
                try {
                    assert (n == n_Vector.getLength());
                    assert (n == n_Vector2.getLength());
                    n_Vector.get(this.state);
                    oDE.getRate(this.rate, d, this.state);
                    n_Vector2.set(this.rate);
                    return 0;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return -1;
                }
            }
        };
        CVRootFn cVRootFn = new CVRootFn(){
            final double[] out;
            final double[] y;
            {
                this.out = new double[CVodeAdapter.this.nrtfn];
                this.y = new double[n];
            }

            public int callback(double d, N_Vector n_Vector, Pointer pointer, Pointer pointer2) {
                try {
                    assert (n == n_Vector.getLength());
                    n_Vector.get(this.y);
                    CVodeAdapter.this.monitor.g(this.out, d, this.y);
                    pointer.write(0L, this.out, 0, CVodeAdapter.this.nrtfn);
                    return 0;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return -1;
                }
            }
        };
        try {
            n_Vector = CVODE.N_VNew_Serial(new NativeLong((long)n));
            pointer = CVODE.CVodeCreate(2, 2);
            if (pointer == Pointer.NULL) {
                throw new NumericException("could not create CVODE solver");
            }
            n_Vector.set(dArray);
            int n2 = CVODE.CVodeInit(pointer, cVRhsFn, d, n_Vector);
            this.checkFlag(n2, "could not init CVODE solver");
            if (this.absTol != null) {
                assert (this.absTolDefault > 0.0);
                assert (this.relTolDefault > 0.0);
                assert (this.absTol.length == n);
                n_Vector.set(this.absTol);
                for (int i = 0; i < n; ++i) {
                    if (this.absTol[i] != 0.0) continue;
                    n_Vector.set(i, this.absTolDefault);
                }
                n2 = CVODE.CVodeSVtolerances(pointer, this.relTolDefault, n_Vector);
            } else {
                n2 = CVODE.CVodeSStolerances(pointer, this.relTolDefault, this.absTolDefault);
            }
            this.checkFlag(n2, "could not set tolerances");
            n2 = CVODE.CVDense(pointer, n);
            this.checkFlag(n2, "could not set linear solver");
            CVODE.CVodeRootInit(pointer, this.nrtfn, cVRootFn);
            while (true) {
                doubleByReference = new DoubleByReference();
                n2 = CVODE.CVode(pointer, d2, n_Vector, doubleByReference, 1);
                n_Vector.get(dArray2);
                if (n2 == 0) {
                    break;
                }
                if (n2 == 2) {
                    int[] nArray = new int[this.nrtfn];
                    n2 = CVODE.CVodeGetRootInfo(pointer, nArray);
                    this.checkFlag(n2, "root was found, but could not determine which");
                    boolean bl = false;
                    for (int i = 0; i < this.nrtfn; ++i) {
                        if (nArray[i] == 0) continue;
                        bl |= this.monitor.handleEvent(i, doubleByReference.getValue(), dArray2);
                    }
                    if (!bl) continue;
                    break;
                }
                this.checkFlag(n2, "error during integration");
            }
        }
        finally {
            if (pointer != Pointer.NULL) {
                doubleByReference = new PointerByReference(pointer);
                CVODE.CVodeFree((PointerByReference)doubleByReference);
            }
            if (n_Vector != null) {
                CVODE.N_VDestroy_Serial(n_Vector);
            }
        }
    }

    private void checkFlag(int n, String string) throws NumericException {
        if (n != 0) {
            throw new NumericException("[" + CVODE.CVodeGetReturnFlagName(n) + "] " + string);
        }
    }

    public void setOptions(Map map) {
    }

    public void setTolerances(double[] dArray, double[] dArray2) {
        assert (dArray == null || dArray2 == null || dArray.length == dArray2.length);
        double[] dArray3 = this.absTol = dArray != null ? (double[])dArray.clone() : null;
        if (dArray2 != null) {
            // empty if block
        }
    }
}

