/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.GraphState;
import de.grogra.reflect.Type;
import de.grogra.util.I18NBundle;
import de.grogra.util.KeyDescription;
import de.grogra.util.Quantity;
import de.grogra.util.Utils;
import de.grogra.xl.util.IntHashMap;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Attribute<T>
implements KeyDescription,
Comparable {
    public static final Attribute[] ATTRIBUTE_0 = new Attribute[0];
    private static final HashMap NAME_TO_ATTR = new HashMap();
    private static int nextId = 0;
    private static int lastDerivedId = 0;
    private String name;
    private String simpleName;
    private String resourceKey;
    private I18NBundle bundle;
    private Attribute[] array;
    protected final Type attrType;
    protected final Quantity quantity;
    final int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Attribute forName(String string) {
        HashMap hashMap = NAME_TO_ATTR;
        synchronized (hashMap) {
            return (Attribute)NAME_TO_ATTR.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Attribute(Type type, Quantity quantity) {
        this.attrType = type;
        this.quantity = quantity;
        HashMap hashMap = NAME_TO_ATTR;
        synchronized (hashMap) {
            int n;
            if (this.isDerived()) {
                n = lastDerivedId = lastDerivedId - 1;
            } else {
                int n2 = nextId;
                n = n2;
                nextId = n2 + 1;
            }
            this.id = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Attribute initializeName(String string) {
        if (this.name != null) {
            throw new IllegalStateException();
        }
        this.name = string;
        int n = string.lastIndexOf(46);
        this.simpleName = n < 0 ? string : string.substring(n + 1);
        HashMap hashMap = NAME_TO_ATTR;
        synchronized (hashMap) {
            NAME_TO_ATTR.put(string, this);
        }
        return this;
    }

    public final Attribute initializeI18N(I18NBundle i18NBundle, String string) {
        if (this.bundle != null) {
            throw new IllegalStateException();
        }
        this.bundle = i18NBundle;
        this.resourceKey = string;
        return this;
    }

    public final synchronized Attribute[] toArray() {
        if (this.array == null) {
            this.array = new Attribute[]{this};
        }
        assert (this.array[0] == this);
        return this.array;
    }

    @Override
    public final Type getType() {
        return this.attrType;
    }

    @Override
    public final String getKey() {
        return this.name;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public final Quantity getQuantity() {
        return this.quantity;
    }

    @Override
    public Object getDescription(String string) {
        return Utils.get(this.bundle, this.resourceKey, string, Utils.isStringDescription(string) ? this.name : null);
    }

    public String toString() {
        return (String)this.getDescription("Name");
    }

    public abstract T get(Object var1, boolean var2, GraphState var3);

    public abstract T set(Object var1, boolean var2, Object var3, GraphState var4);

    public static AttributeAccessor find(AttributeAccessor[] attributeAccessorArray, String string) {
        for (int i = attributeAccessorArray.length - 1; i >= 0; --i) {
            if (attributeAccessorArray[i] == null || !attributeAccessorArray[i].getAttribute().name.equals(string) && !attributeAccessorArray[i].getAttribute().simpleName.equals(string)) continue;
            return attributeAccessorArray[i];
        }
        return null;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isWritable(Object object, boolean bl, GraphState graphState) {
        if (this.isDerived()) {
            return false;
        }
        AttributeAccessor attributeAccessor = graphState.getGraph().getAccessor(object, bl, this);
        return attributeAccessor != null && attributeAccessor.isWritable(object, graphState);
    }

    public final int getId() {
        return this.id;
    }

    public final int hashCode() {
        return this.id;
    }

    public final int compareTo(Object object) {
        return this.id - ((Attribute)object).id;
    }

    public final boolean isContained(Attribute[] attributeArray) {
        return attributeArray != null && Arrays.binarySearch(attributeArray, this) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setAttributeState(GraphState graphState, Object object) {
        IntHashMap intHashMap = graphState.attributeMap;
        synchronized (intHashMap) {
            graphState.attributeMap.put(this.id, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getAttributeState(GraphState graphState) {
        IntHashMap intHashMap = graphState.attributeMap;
        synchronized (intHashMap) {
            return graphState.attributeMap.get(this.id, null);
        }
    }
}

