/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.GraphException;
import de.grogra.graph.SpecialEdgeDescriptor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.GraphTransaction;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Transaction;
import de.grogra.util.Utils;
import java.io.Serializable;
import org.xml.sax.SAXException;

public abstract class Edge
implements Serializable {
    private static final int USED_EDGE_MASK = 131071;
    Edge next = null;
    Edge targetNext = null;
    int edgeBits = 0;
    transient int bitMarks = 0;
    transient Object[] marks = Utils.OBJECT_0;

    Edge() {
    }

    public final int getEdgeBits() {
        return this.edgeBits;
    }

    public final boolean testEdgeBits(int n) {
        return n == -1 ? this.edgeBits != 0 : (n & this.edgeBits & 0xFFFFFF00) != 0 || (n & 0xFF) != 0 && ((n ^ this.edgeBits) & 0xFF) == 0;
    }

    public final void addEdgeBits(int n, Transaction transaction) {
        this.addEdgeBits(n, transaction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addEdgeBits(int n, Transaction transaction, boolean bl) {
        int n2;
        PersistenceManager persistenceManager;
        Node node = this.getSource();
        Node node2 = this.getTarget();
        PersistenceManager persistenceManager2 = node.getPersistenceManager();
        if (persistenceManager2 != (persistenceManager = node2.getPersistenceManager())) {
            if (persistenceManager2 == null) {
                persistenceManager.makePersistent(node, -1L, transaction);
                persistenceManager2 = persistenceManager;
            } else if (persistenceManager == null) {
                persistenceManager2.makePersistent(node2, -1L, transaction);
            } else {
                throw new GraphException("Can't add edges between nodes of different persistence extents.");
            }
        }
        if (node.id < node2.id) {
            Node node3 = node;
            synchronized (node3) {
                Node node4 = node2;
                synchronized (node4) {
                    n2 = this.edgeBits;
                    this.edgeBits = n2 | n;
                }
            }
        }
        if (node2.id < 0L) {
            n2 = this.edgeBits;
            this.edgeBits = n2 | n;
        } else {
            Node node5 = node2;
            synchronized (node5) {
                Node node6 = node;
                synchronized (node6) {
                    n2 = this.edgeBits;
                    this.edgeBits = n2 | n;
                }
            }
        }
        if (persistenceManager2 != null && Transaction.isNotApplying(transaction)) {
            ((GraphTransaction)transaction.makeActive()).logAddEdgeBits(node, node2, n & ~n2, n);
        }
        if (bl) {
            node.edgeChanged(this, n2, transaction);
            node2.edgeChanged(this, n2, transaction);
        }
    }

    public final void setEdgeBits(int n, Transaction transaction) {
        int n2 = this.edgeBits;
        if ((n & ~n2) != 0) {
            this.addEdgeBits(n & ~n2, transaction);
        }
        if ((n2 & ~n) != 0) {
            this.removeEdgeBits(n2 & ~n, transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEdgeBits(int n, Transaction transaction) {
        int n2;
        Object object;
        Node node = this.getSource();
        Node node2 = this.getTarget();
        if (node.id < node2.id) {
            object = node;
            synchronized (object) {
                Node node3 = node2;
                synchronized (node3) {
                    n2 = this.edgeBits;
                    this.edgeBits = n2 & ~n;
                }
            }
        }
        if (node2.id < 0L) {
            n2 = this.edgeBits;
            this.edgeBits = n2 & ~n;
        } else {
            object = node2;
            synchronized (object) {
                Node node4 = node;
                synchronized (node4) {
                    n2 = this.edgeBits;
                    this.edgeBits = n2 & ~n;
                }
            }
        }
        if (transaction != null && (object = node.getPersistenceManager()) != null && node2.getPersistenceManager() == object && Transaction.isNotApplying(transaction)) {
            ((GraphTransaction)transaction.makeActive()).logRemoveEdgeBits(node, node2, n & n2, n);
        }
        if (this.edgeBits == 0) {
            this.remove(null);
        }
        node.edgeChanged(this, n2, transaction);
        node2.edgeChanged(this, n2, transaction);
    }

    public final void remove(Transaction transaction) {
        this.remove(transaction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(Transaction transaction, boolean bl) {
        int n;
        Object object;
        Node node = this.getSource();
        Node node2 = this.getTarget();
        if (node.id < node2.id) {
            object = node;
            synchronized (object) {
                Node node3 = node2;
                synchronized (node3) {
                    node.removeEdge(this);
                    node2.removeEdge(this);
                    n = this.edgeBits;
                    this.edgeBits = 0;
                }
            }
        }
        if (node2.id < 0L) {
            node.removeEdge(this);
            node2.removeEdge(this);
            n = this.edgeBits;
            this.edgeBits = 0;
        } else {
            object = node2;
            synchronized (object) {
                Node node4 = node;
                synchronized (node4) {
                    node.removeEdge(this);
                    node2.removeEdge(this);
                    n = this.edgeBits;
                    this.edgeBits = 0;
                }
            }
        }
        if (n != 0) {
            if (transaction != null && (object = node.getPersistenceManager()) != null && node2.getPersistenceManager() == object && Transaction.isNotApplying(transaction)) {
                ((GraphTransaction)transaction.makeActive()).logRemoveEdgeBits(node, node2, n, -1);
            }
            if (bl) {
                node.edgeChanged(this, n, transaction);
                node2.edgeChanged(this, n, transaction);
            }
        }
    }

    final void setNext(Edge edge, Node node) {
        if (node == this.getSource()) {
            this.next = edge;
        } else {
            this.targetNext = edge;
        }
    }

    void resetMarks() {
        this.bitMarks = 0;
        this.marks = Utils.OBJECT_0;
    }

    final boolean getGCMark() {
        return (this.bitMarks & 1) != 0;
    }

    final synchronized boolean setGCMark(boolean bl) {
        if (bl) {
            if ((this.bitMarks & 1) != 0) {
                return true;
            }
            this.bitMarks |= 1;
            return false;
        }
        if ((this.bitMarks & 1) != 0) {
            this.bitMarks &= 0xFFFFFFFE;
            return true;
        }
        return false;
    }

    public final synchronized boolean setBitMark(int n, boolean bl) {
        byte by;
        if (bl) {
            this.getGraph().bitMarkSet(this, n);
        }
        if (n > 0 || n == Integer.MIN_VALUE) {
            if (bl) {
                if ((this.bitMarks & n) != 0) {
                    return true;
                }
                this.bitMarks |= n;
                return false;
            }
            if ((this.bitMarks & n) != 0) {
                this.bitMarks &= ~n;
                return true;
            }
            return false;
        }
        int n2 = -n >> 3;
        n = 1 << (-n & 7);
        Object[] objectArray = this.marks;
        byte by2 = n2 >= objectArray.length ? (byte)0 : (by = objectArray[n2] == null ? (byte)0 : (Byte)objectArray[n2]);
        if (bl) {
            this.setObjectMark(n2, (byte)(by | n));
        } else {
            byte by3 = (byte)(by & ~n);
            this.setObjectMark(n2, by3 == 0 ? null : Byte.valueOf(by3));
        }
        return (by & n) != 0;
    }

    public final synchronized boolean getBitMark(int n) {
        Byte by;
        if (n > 0 || n == Integer.MIN_VALUE) {
            return (this.bitMarks & n) != 0;
        }
        int n2 = -n >> 3;
        n = 1 << (-n & 7);
        Object[] objectArray = this.marks;
        Byte by2 = by = n2 >= objectArray.length ? null : (Byte)objectArray[n2];
        return by == null ? false : (by & n) != 0;
    }

    public final synchronized Object setObjectMark(int n, Object object) {
        int n2;
        if (object != null) {
            this.getGraph().objectMarkSet(this, n);
        }
        if (n >= (n2 = this.marks.length)) {
            this.marks = new Object[n + 4];
            System.arraycopy(this.marks, 0, this.marks, 0, n2);
        }
        Object object2 = this.marks[n];
        this.marks[n] = object;
        return object2;
    }

    public final synchronized Object getObjectMark(int n) {
        Object[] objectArray = this.marks;
        return n >= objectArray.length ? null : objectArray[n];
    }

    public SpecialEdgeDescriptor getSpecialEdgeDescriptor() {
        if ((this.edgeBits & 0xFF) == 0) {
            throw new RuntimeException();
        }
        return ((this.edgeBits & 0x80) != 0 ? this.getSource() : this.getTarget()).getNType().getSpecialEdgeDescriptor(this.edgeBits & 0xFF);
    }

    public static int parseEdgeKeys(String string, Node node, Node node2) throws SAXException {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 <= n3) {
            int n4;
            block30: {
                block29: {
                    n4 = string.indexOf(44, n2);
                    if (n4 < 0) {
                        n4 = n3;
                    }
                    if (n4 == n2) {
                        throw new SAXException(string);
                    }
                    if (n4 != n2 + 1) break block29;
                    switch (string.charAt(n2)) {
                        case '-': 
                        case '>': {
                            n |= 0x100;
                            break block30;
                        }
                        case '+': {
                            n |= 0x200;
                            break block30;
                        }
                        case '{': {
                            n |= 0x400;
                            break block30;
                        }
                        case '}': {
                            n |= 0x800;
                            break block30;
                        }
                        case '/': {
                            n |= 0x1000;
                            break block30;
                        }
                        case '#': {
                            n |= 0x2000;
                            break block30;
                        }
                        case '@': {
                            n |= 0x4000;
                            break block30;
                        }
                        case 'A': {
                            n |= 0x8000;
                            break block30;
                        }
                        case 'B': {
                            n |= 0x10000;
                            break block30;
                        }
                        case '0': {
                            n |= 0x20000;
                            break block30;
                        }
                        case '1': {
                            n |= 0x40000;
                            break block30;
                        }
                        case '2': {
                            n |= 0x80000;
                            break block30;
                        }
                        case '3': {
                            n |= 0x100000;
                            break block30;
                        }
                        case '4': {
                            n |= 0x200000;
                            break block30;
                        }
                        case '5': {
                            n |= 0x400000;
                            break block30;
                        }
                        case '6': {
                            n |= 0x800000;
                            break block30;
                        }
                        case '7': {
                            n |= 0x1000000;
                            break block30;
                        }
                        case '8': {
                            n |= 0x2000000;
                            break block30;
                        }
                        case '9': {
                            n |= 0x4000000;
                            break block30;
                        }
                        default: {
                            throw new SAXException(string);
                        }
                    }
                }
                char c = string.charAt(n2);
                if (c == '0' && string.charAt(n2 + 1) == 'x') {
                    n = n & 0xFFFFFF00 | Integer.parseInt(string.substring(n2 + 2, n4), 16);
                } else if (c >= '0' && c <= '9') {
                    n |= Integer.parseInt(string.substring(n2, n4)) << 17;
                } else {
                    SpecialEdgeDescriptor specialEdgeDescriptor;
                    SpecialEdgeDescriptor specialEdgeDescriptor2 = specialEdgeDescriptor = c == '*' ? node2.getNType().getSpecialEdgeDescriptor(string.substring(n2 + 1, n4)) : node.getNType().getSpecialEdgeDescriptor(string.substring(n2, n4));
                    if (specialEdgeDescriptor != null) {
                        n = n & 0xFFFFFF00 | specialEdgeDescriptor.getBits();
                    }
                }
            }
            n2 = n4 + 1;
        }
        return n;
    }

    void getEdgeKeys(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        int n = this.edgeBits;
        boolean bl3 = false;
        if ((n & 0xFF) != 0) {
            SpecialEdgeDescriptor specialEdgeDescriptor = this.getSpecialEdgeDescriptor();
            if (specialEdgeDescriptor != null) {
                if (bl2) {
                    stringBuffer.append(specialEdgeDescriptor.getDescription("Name"));
                } else {
                    (specialEdgeDescriptor.isDeclaredBySource() ? stringBuffer : stringBuffer.append('*')).append(specialEdgeDescriptor.getKey());
                }
            } else {
                stringBuffer.append("0x").append(Integer.toHexString(n & 0xFF));
            }
            bl3 = true;
        }
        n &= 0xFFFFFF00;
        block11: for (int i = 8; n != 0 && i < 32; ++i) {
            int n2 = 1 << i;
            if ((n & n2) == 0) continue;
            n &= ~n2;
            if (bl3) {
                stringBuffer.append(',');
            } else {
                bl3 = true;
            }
            switch (n2) {
                case 256: {
                    stringBuffer.append(bl ? (char)'-' : '>');
                    continue block11;
                }
                case 512: {
                    stringBuffer.append('+');
                    continue block11;
                }
                case 1024: {
                    stringBuffer.append('{');
                    continue block11;
                }
                case 2048: {
                    stringBuffer.append('}');
                    continue block11;
                }
                case 4096: {
                    stringBuffer.append('/');
                    continue block11;
                }
                case 8192: {
                    stringBuffer.append('#');
                    continue block11;
                }
                case 16384: {
                    stringBuffer.append('@');
                    continue block11;
                }
                case 32768: {
                    stringBuffer.append('A');
                    continue block11;
                }
                case 65536: {
                    stringBuffer.append('B');
                    continue block11;
                }
                default: {
                    if ((n2 & 0x1FFFF) != 0) {
                        throw new RuntimeException();
                    }
                    stringBuffer.append(i - 17);
                }
            }
        }
    }

    abstract GraphManager getGraph();

    public abstract Node getSource();

    public abstract Node getTarget();

    public abstract boolean isSource(Node var1);

    public abstract boolean isTarget(Node var1);

    public abstract boolean isDirection(Node var1, Node var2);

    public abstract Node getNeighbor(Node var1);

    public abstract Edge getNext(Node var1);
}

