/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.http;

import de.grogra.http.Request;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Server
implements Runnable {
    public static final String CONTENT_LENGTH = "content-length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CRLF = "\r\n";
    private final ServerSocket socket;
    private final Logger logger;
    private final Level infoLevel;
    private final Level warningLevel;
    private volatile boolean running = true;
    private Vector clients = new Vector();

    public Server(ServerSocket serverSocket, Logger logger, Level level, Level level2) {
        this.socket = serverSocket;
        this.logger = logger;
        this.infoLevel = level;
        this.warningLevel = level2;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Level getInfoLevel() {
        return this.infoLevel;
    }

    public Level getWarningLevel() {
        return this.warningLevel;
    }

    public void run() {
        block3: {
            try {
                while (this.running) {
                    this.accept(this.socket.accept());
                }
            }
            catch (IOException iOException) {
                if (!this.running) break block3;
                this.logger.log(this.warningLevel, "Error while waiting for connections", iOException);
            }
        }
    }

    protected void accept(final Socket socket) {
        new Thread(new Runnable(){

            public void run() {
                block7: {
                    block6: {
                        Server.this.clients.add(socket);
                        try {
                            Request request;
                            Server.this.logger.log(Server.this.infoLevel, "Accepting http client " + socket);
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                            while (Server.this.running && (request = Request.parse(bufferedInputStream)) != null) {
                                Server.this.logger.log(Server.this.infoLevel, "Client " + socket + ": Handling request\n" + request);
                                if (Server.this.handleRequest(request, socket)) continue;
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (!Server.this.running) break block6;
                            Server.this.logger.log(Server.this.warningLevel, "Error in communication with http client " + socket, iOException);
                        }
                    }
                    Server.this.logger.log(Level.CONFIG, "Closing http client " + socket);
                    try {
                        Server.this.clients.remove(socket);
                        if (Server.this.running) {
                            socket.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Server.this.running) break block7;
                        Server.this.logger.log(Server.this.warningLevel, "Error while closing " + socket, iOException);
                    }
                }
            }
        }, socket.toString()).start();
    }

    public static void writeResponse(int n, String string, String string2, byte[] byArray, boolean bl, OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print("HTTP/1.1 ");
        printStream.print(n);
        printStream.print(' ');
        printStream.print(string);
        printStream.print(CRLF);
        if (bl) {
            printStream.print("Connection: close\r\n");
        }
        printStream.print("content-length: ");
        printStream.print(byArray.length);
        printStream.print(CRLF);
        printStream.print("content-type: ");
        printStream.print(string2);
        printStream.print(CRLF);
        printStream.print(CRLF);
        printStream.write(byArray);
        printStream.flush();
        outputStream.flush();
    }

    public boolean isClosed() {
        return !this.running;
    }

    public void close() throws IOException {
        this.running = false;
        this.socket.close();
        Socket[] socketArray = this.clients.toArray(new Socket[0]);
        for (int i = 0; i < socketArray.length; ++i) {
            try {
                socketArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected abstract boolean handleRequest(Request var1, Socket var2) throws IOException;
}

