/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAQueue;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.MemberBase;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import java.io.IOException;

public abstract class PersistenceField
extends MemberBase
implements Field,
FieldChain {
    static final int CHAIN_LENGTH_BIT = 24;
    boolean fco;
    int typeId;

    public static PersistenceField get(Field field) {
        if (field instanceof PersistenceField) {
            return (PersistenceField)field;
        }
        Type type = field.getDeclaringType();
        if (!(type instanceof ManageableType)) {
            type = ManageableType.forType(type);
        }
        return type == null ? null : ((ManageableType)type).getManagedField(field.getName());
    }

    PersistenceField(String string, String string2, int n, Type type) {
        super(string, string2, n, type);
    }

    public final Field getField(int n) {
        return this.getSubfield(n);
    }

    public abstract ManageableType.Field getSubfield(int var1);

    public abstract ManageableType.Field getLastField();

    public abstract PersistenceField getShallowSubchain(int var1);

    abstract PersistenceField getShallowSuperchain();

    public abstract Quantity getQuantity();

    public abstract Number getMinValue();

    public abstract Number getMaxValue();

    public boolean isWritable(Object object) {
        return true;
    }

    abstract void write(int[] var1, XAQueue var2);

    abstract void writeObject(Object var1, PersistenceOutput var2) throws IOException;

    public final void set(Object object, int[] nArray, Object object2, Transaction transaction) {
        switch (this.typeId) {
            case 2: {
                this.setBoolean(object, nArray, (Boolean)object2, transaction);
                return;
            }
            case 3: {
                this.setByte(object, nArray, ((Number)object2).byteValue(), transaction);
                return;
            }
            case 4: {
                this.setShort(object, nArray, ((Number)object2).shortValue(), transaction);
                return;
            }
            case 5: {
                this.setChar(object, nArray, ((Character)object2).charValue(), transaction);
                return;
            }
            case 6: {
                this.setInt(object, nArray, ((Number)object2).intValue(), transaction);
                return;
            }
            case 7: {
                this.setLong(object, nArray, ((Number)object2).longValue(), transaction);
                return;
            }
            case 8: {
                this.setFloat(object, nArray, ((Number)object2).floatValue(), transaction);
                return;
            }
            case 9: {
                this.setDouble(object, nArray, ((Number)object2).doubleValue(), transaction);
                return;
            }
            case 0: {
                this.setObject(object, nArray, object2, transaction);
                return;
            }
        }
    }

    public final Object get(Object object, int[] nArray) {
        switch (this.typeId) {
            case 2: {
                return this.getBoolean(object, nArray) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.getByte(object, nArray);
            }
            case 4: {
                return this.getShort(object, nArray);
            }
            case 5: {
                return Character.valueOf(this.getChar(object, nArray));
            }
            case 6: {
                return this.getInt(object, nArray);
            }
            case 7: {
                return this.getLong(object, nArray);
            }
            case 8: {
                return Float.valueOf(this.getFloat(object, nArray));
            }
            case 9: {
                return this.getDouble(object, nArray);
            }
            case 0: {
                return this.getObject(object, nArray);
            }
        }
        throw new AssertionError();
    }

    public abstract void setBoolean(Object var1, int[] var2, boolean var3, Transaction var4);

    public abstract void insertBoolean(Object var1, int[] var2, boolean var3, Transaction var4);

    public abstract void removeBoolean(Object var1, int[] var2, Transaction var3);

    public abstract boolean getBoolean(Object var1, int[] var2);

    abstract boolean readAndSetBoolean(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertBoolean(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setByte(Object var1, int[] var2, byte var3, Transaction var4);

    public abstract void insertByte(Object var1, int[] var2, byte var3, Transaction var4);

    public abstract void removeByte(Object var1, int[] var2, Transaction var3);

    public abstract byte getByte(Object var1, int[] var2);

    abstract byte readAndSetByte(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertByte(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setShort(Object var1, int[] var2, short var3, Transaction var4);

    public abstract void insertShort(Object var1, int[] var2, short var3, Transaction var4);

    public abstract void removeShort(Object var1, int[] var2, Transaction var3);

    public abstract short getShort(Object var1, int[] var2);

    abstract short readAndSetShort(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertShort(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setChar(Object var1, int[] var2, char var3, Transaction var4);

    public abstract void insertChar(Object var1, int[] var2, char var3, Transaction var4);

    public abstract void removeChar(Object var1, int[] var2, Transaction var3);

    public abstract char getChar(Object var1, int[] var2);

    abstract char readAndSetChar(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertChar(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setInt(Object var1, int[] var2, int var3, Transaction var4);

    public abstract void insertInt(Object var1, int[] var2, int var3, Transaction var4);

    public abstract void removeInt(Object var1, int[] var2, Transaction var3);

    public abstract int getInt(Object var1, int[] var2);

    abstract int readAndSetInt(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertInt(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setLong(Object var1, int[] var2, long var3, Transaction var5);

    public abstract void insertLong(Object var1, int[] var2, long var3, Transaction var5);

    public abstract void removeLong(Object var1, int[] var2, Transaction var3);

    public abstract long getLong(Object var1, int[] var2);

    abstract long readAndSetLong(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertLong(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setFloat(Object var1, int[] var2, float var3, Transaction var4);

    public abstract void insertFloat(Object var1, int[] var2, float var3, Transaction var4);

    public abstract void removeFloat(Object var1, int[] var2, Transaction var3);

    public abstract float getFloat(Object var1, int[] var2);

    abstract float readAndSetFloat(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertFloat(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setDouble(Object var1, int[] var2, double var3, Transaction var5);

    public abstract void insertDouble(Object var1, int[] var2, double var3, Transaction var5);

    public abstract void removeDouble(Object var1, int[] var2, Transaction var3);

    public abstract double getDouble(Object var1, int[] var2);

    abstract double readAndSetDouble(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertDouble(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    public abstract void setObject(Object var1, int[] var2, Object var3, Transaction var4);

    public abstract void insertObject(Object var1, int[] var2, Object var3, Transaction var4);

    public abstract void removeObject(Object var1, int[] var2, Transaction var3);

    public abstract Object getObject(Object var1, int[] var2);

    abstract Object readAndSetObject(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);

    abstract void readAndInsertObject(PersistenceCapable var1, int[] var2, XAQueue.Reader var3);
}

