/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Shareable;
import de.grogra.reflect.Type;
import de.grogra.xl.util.ObjectList;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class PersistenceOutputStream
extends OutputStream
implements PersistenceOutput,
DataOutput {
    public static final int MAGIC = -623199554;
    static final int IO_BEGIN = -2042464975;
    static final int IO_END = -19088744;
    static final int IO_PERSISTENT_DATA = 5;
    private final ObjectList writtenHandles = new ObjectList();
    private final BindingsCache cache;
    private final DataOutputStream out;
    private final ObjectOutputStream objectOut;
    private PersistenceManager manager;
    private int writtenMark;

    public PersistenceOutputStream(BindingsCache bindingsCache, DataOutputStream dataOutputStream) throws IOException {
        this.cache = bindingsCache;
        this.out = dataOutputStream;
        dataOutputStream.writeInt(-623199554);
        this.objectOut = new ObjectOutputStream(dataOutputStream);
        this.objectOut.flush();
    }

    int[] getWrittenHandles(short s) {
        int[] nArray = (int[])this.writtenHandles.get(s);
        if (nArray == null) {
            nArray = new int[3];
            this.writtenHandles.set(s, nArray);
        }
        return nArray;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.objectOut.close();
        this.out.flush();
        this.out.close();
    }

    public void write(BindingsCache bindingsCache) throws IOException {
        this.writeShort(bindingsCache.getCacheId());
        bindingsCache.write(this);
    }

    public void beginExtent(PersistenceManager persistenceManager) throws IOException {
        this.writeInt(-2042464975);
        this.write(this.cache);
        this.manager = persistenceManager;
        this.writtenMark = persistenceManager.allocateBitMark(false);
    }

    public void endExtent() throws IOException {
        this.writeInt(-19088744);
        this.manager.disposeBitMark(this.writtenMark, true);
        this.manager = null;
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }

    public void writeName(String string) throws IOException {
        this.out.writeUTF(string);
    }

    public void writeString(String string) throws IOException {
        this.out.writeUTF(string);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.out.writeByte(n);
    }

    public void writeChar(int n) throws IOException {
        this.out.writeChar(n);
    }

    public void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    public void writeInt(int n) throws IOException {
        int n2;
        while (true) {
            n2 = n & 0x7F;
            if ((n >>>= 7) == 0) break;
            this.out.write(n2 | 0x80);
        }
        this.out.write(n2);
    }

    public void writeLong(long l) throws IOException {
        this.writeInt((int)(l >> 32));
        this.writeInt((int)l);
    }

    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public void writeNullObject() throws IOException {
        this.out.writeByte(101);
    }

    public void writeStringObject(String string) throws IOException {
        this.out.writeByte(102);
        this.out.writeUTF(string);
    }

    public void writeObject(Object object, Type type) throws IOException {
        this.out.writeByte(103);
        this.objectOut.writeObject(object);
        this.objectOut.flush();
    }

    public void writeSharedObjectReference(Shareable shareable) throws IOException {
        this.out.writeByte(105);
        this.cache.write(shareable.getProvider(), this);
        shareable.getProvider().writeObject(shareable, this);
    }

    public void writePersistentObjectReference(PersistenceCapable persistenceCapable) throws IOException {
        this.out.writeByte(106);
        this.writeLong(persistenceCapable.getId());
        if (!persistenceCapable.setBitMark(this.writtenMark, true)) {
            this.out.write(5);
            boolean bl = this.beginManaged(persistenceCapable.getManageableType(), true);
            persistenceCapable.getManageableType().write(persistenceCapable, this, bl);
            this.endManaged(persistenceCapable, true);
        }
    }

    public void beginArray(int n, Type type) throws IOException {
        this.out.writeByte(107);
        this.writeInt(n);
    }

    public void endArray() {
    }

    public boolean beginManaged(ManageableType manageableType, boolean bl) throws IOException {
        if (bl) {
            this.out.writeByte(108);
            this.cache.write(manageableType, this);
        } else {
            this.out.writeByte(104);
        }
        return true;
    }

    public void beginFields() {
    }

    public void beginField(ManageableType.Field field) throws IOException {
        this.writeShort(field.getFieldId());
    }

    public void endField(ManageableType.Field field) {
    }

    public void endFields() throws IOException {
        this.writeShort(-1);
    }

    public void endManaged(Object object, boolean bl) {
    }

    public void setNested(boolean bl) {
    }
}

