/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.IndirectField;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.ResolvableReference;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.IOWrapException;
import de.grogra.util.SAXElement;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongHashMap;
import de.grogra.xl.util.ObjectList;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersistenceReader
implements PersistenceInput {
    private static final String NAMESPACE = "http://grogra.de/xmlpersistence";
    private static final int SINGLE_FIELD = 0;
    private static final int BUFFER = 1;
    private static final int ELEMENT_WITH_ELEMENTS = 2;
    private static final int ELEMENT_WITH_ATTRIBUTES = 3;
    private boolean wholeBuffer = false;
    private final LongHashMap<PersistenceCapable> objects;
    private final PersistenceBindings bindings;
    private int pos;
    private String buffer;
    private SAXElement element;
    private int inputType;
    private int attributeIndex;
    private final ObjectList<Object> persistentObjectsToResolve = new ObjectList(50);
    private final ObjectList<Object> sharedObjectsToResolve = new ObjectList(50);
    private final StringBuffer sb = new StringBuffer();
    private boolean wasQuoted;
    private Type fieldType;
    private final ObjectList stack = new ObjectList();
    private final IndirectField totalField = new IndirectField();
    private final IntList totalIndices = new IntList();
    private PersistenceCapable persistentObject;
    private boolean fieldsProvided;
    private final SAXElement attrElement = new SAXElement();
    private static final int SOME_RESOLVED = 1;
    private static final int SOME_UNRESOLVED = 2;

    public XMLPersistenceReader(PersistenceBindings persistenceBindings) {
        this.objects = new LongHashMap();
        this.bindings = persistenceBindings;
    }

    @Override
    public PersistenceBindings getBindings() {
        return this.bindings;
    }

    public PersistenceCapable getObject(long l) {
        return this.objects.get(l);
    }

    public void registerObject(long l, PersistenceCapable persistenceCapable) {
        this.objects.put(l, persistenceCapable);
    }

    private void setBuffer(String string) {
        this.buffer = string;
        this.pos = 0;
        this.inputType = 1;
        this.wholeBuffer = true;
    }

    private int getc() throws IOException {
        if (this.pos < this.buffer.length()) {
            return this.buffer.charAt(this.pos++);
        }
        ++this.pos;
        return -1;
    }

    private char getchar() throws IOException {
        int n = this.getc();
        if (n < 0) {
            throw new EOFException();
        }
        return (char)n;
    }

    private void consume(char c) throws IOException {
        if (c != this.getc()) {
            throw new IOException("Expected " + c);
        }
    }

    private void consumeWS() throws IOException {
        int n;
        while ((n = this.getc()) >= 0 && Character.isWhitespace((char)n)) {
        }
        --this.pos;
    }

    private int nextDelimiter(boolean bl) throws IOException {
        this.consumeWS();
        int n = this.pos;
        block4: while (true) {
            switch (this.getc()) {
                case -1: 
                case 32: 
                case 34: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 58: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    break block4;
                }
                case 61: {
                    if (bl) break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        int n2 = this.pos - 1;
        this.pos = n;
        return n2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.beginRead('\u0000');
        int n = this.nextDelimiter(true);
        boolean bl = this.buffer.regionMatches(this.pos, "true", 0, 4);
        this.pos = n;
        return bl;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readInt();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readInt() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readInt() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.beginRead('\u0000');
        this.consumeWS();
        this.consume('\'');
        char c = this.getchar();
        if (c == '\\') {
            c = this.getchar();
        }
        this.consume('\'');
        return c;
    }

    @Override
    public int readInt() throws IOException {
        try {
            int n;
            this.beginRead('\u0000');
            this.pos = n = this.nextDelimiter(true);
            return Integer.parseInt(this.buffer.substring(this.pos, this.pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOWrapException(numberFormatException);
        }
    }

    private long readLong(char c) throws IOException {
        try {
            int n;
            if (this.inputType == 0) {
                return Long.parseLong(this.element.getValue(NAMESPACE, "value"));
            }
            this.consumeWS();
            if (c > '\u0000') {
                this.consume(c);
            }
            this.pos = n = this.nextDelimiter(true);
            return Long.parseLong(this.buffer.substring(this.pos, this.pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOWrapException(numberFormatException);
        }
    }

    @Override
    public long readLong() throws IOException {
        return this.readLong('\u0000');
    }

    @Override
    public float readFloat() throws IOException {
        try {
            int n;
            this.beginRead('\u0000');
            this.pos = n = this.nextDelimiter(true);
            return Float.parseFloat(this.buffer.substring(this.pos, this.pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOWrapException(numberFormatException);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            int n;
            this.beginRead('\u0000');
            this.pos = n = this.nextDelimiter(true);
            return Double.parseDouble(this.buffer.substring(this.pos, this.pos));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOWrapException(numberFormatException);
        }
    }

    @Override
    public String readName() throws IOException {
        this.pos = this.nextDelimiter(true);
        return this.buffer.substring(this.pos, this.pos);
    }

    public String peekName() throws IOException {
        return this.buffer.substring(this.pos, this.nextDelimiter(true));
    }

    @Override
    public String readString() throws IOException {
        int n;
        this.consumeWS();
        this.wasQuoted = this.getc() == 34;
        if (this.wasQuoted) {
            char c;
            this.sb.setLength(0);
            while ((c = this.getchar()) != '\"') {
                if (c == '\\') {
                    c = this.getchar();
                }
                this.sb.append(c);
            }
            return this.sb.toString();
        }
        --this.pos;
        this.pos = n = this.nextDelimiter(false);
        return this.buffer.substring(this.pos, this.pos);
    }

    @Override
    public int getNextObjectKind() throws IOException {
        switch (this.inputType) {
            case 1: {
                if (!this.wholeBuffer) {
                    this.consumeWS();
                }
                if (Reflection.equal(this.fieldType, Type.STRING)) {
                    return 102;
                }
                int n = this.getc();
                --this.pos;
                switch (n) {
                    case 123: {
                        return 107;
                    }
                    case 35: {
                        return 106;
                    }
                    case 42: {
                        return 105;
                    }
                    case 40: 
                    case 91: {
                        return 104;
                    }
                    case 64: {
                        return 103;
                    }
                }
                return 100;
            }
            case 0: {
                String string = this.element.name;
                if (string.equals("data")) {
                    return 102;
                }
                if (string.equals("object")) {
                    return 104;
                }
                if (string.equals("shared")) {
                    return 105;
                }
                if (string.equals("null")) {
                    return 101;
                }
                if (string.equals("ref")) {
                    return 106;
                }
                if (string.equals("string")) {
                    return 100;
                }
                if (string.equals("array")) {
                    return 107;
                }
                if (string.equals("serialized")) {
                    return 103;
                }
                throw new IOException(string);
            }
            case 2: {
                if (this.element.name.equals("array")) {
                    return 107;
                }
            }
            case 3: {
                return 104;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Object readObject(int n, Type type) throws IOException {
        String string;
        switch (this.inputType) {
            case 1: {
                if (this.wholeBuffer) {
                    this.wasQuoted = this.buffer.startsWith("\"");
                    string = this.wasQuoted ? Utils.unquote(this.buffer) : this.buffer;
                    break;
                }
                string = this.readString();
                break;
            }
            case 0: {
                if (n == 101) {
                    return null;
                }
                string = this.element.getValue(NAMESPACE, "value");
                this.wasQuoted = string.startsWith("\"");
                if (!this.wasQuoted) break;
                string = Utils.unquote(string);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.inputType != 0 && !this.wasQuoted && "null".equals(string)) {
            return null;
        }
        if (type.getImplementationClass() == String.class) {
            return string;
        }
        if (n == 100 && type.isStringSerializable()) {
            return type.valueOf(string);
        }
        if (n == 100 && type.getImplementationClass() == Class.class) {
            try {
                return this.bindings.getTypeLoader().classForName(string);
            }
            catch (Exception exception) {
                throw new IOWrapException(exception);
            }
        }
        if (n == 103) {
            int n2 = 0;
            if (this.inputType != 0) {
                if (string.startsWith("@")) {
                    n2 = 1;
                } else {
                    throw new IOException();
                }
            }
            try {
                return Utils.decodeBase64((CharSequence)string, n2, string.length() - n2, this.bindings.getTypeLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOWrapException(classNotFoundException);
            }
        }
        if (n == 102) {
            System.err.println("Wrong data for type " + type + ": " + string);
            return null;
        }
        throw new AssertionError(n);
    }

    @Override
    public Shareable readSharedObject() throws IOException {
        int n;
        this.beginRead('*');
        this.pos = n = this.nextDelimiter(true);
        String string = this.buffer.substring(this.pos, this.pos);
        this.consume(':');
        SharedObjectProvider sharedObjectProvider = this.bindings.getSOBinding().lookup(string);
        ResolvableReference resolvableReference = sharedObjectProvider.readReference(this);
        if (resolvableReference.isResolvable()) {
            return resolvableReference.resolve();
        }
        this.sharedObjectsToResolve.push(resolvableReference, this.totalField.dup(), this.persistentObject).push(this.totalIndices.isEmpty() ? null : this.totalIndices.toArray());
        return null;
    }

    @Override
    public long readPersistentObjectId() throws IOException {
        return this.readLong('#');
    }

    @Override
    public PersistenceCapable readPersistentObject() throws IOException {
        long l = this.readPersistentObjectId();
        PersistenceCapable persistenceCapable = this.objects.get(l);
        if (persistenceCapable != null) {
            return persistenceCapable;
        }
        this.persistentObjectsToResolve.push(new Long(l), this.totalField.dup(), this.persistentObject).push(this.totalIndices.isEmpty() ? null : this.totalIndices.toArray());
        return null;
    }

    private void beginRead(char c) throws IOException {
        if (this.inputType == 0) {
            this.setBuffer(this.element.getValue(NAMESPACE, "value"));
        } else {
            this.consumeWS();
            if (c > '\u0000') {
                this.consume(c);
            }
        }
    }

    @Override
    public int beginArray() throws IOException {
        switch (this.inputType) {
            case 2: {
                int n = 0;
                SAXElement sAXElement = this.element = this.element.children;
                while (sAXElement != null) {
                    ++n;
                    sAXElement = sAXElement.next;
                }
                return n;
            }
            case 1: {
                this.wholeBuffer = false;
                this.consumeWS();
                this.consume('{');
                return -1;
            }
            case 0: {
                this.setBuffer(this.element.getValue(NAMESPACE, "value"));
                this.wholeBuffer = false;
                return -1;
            }
        }
        throw new AssertionError();
    }

    private void beginFieldImpl() {
        this.stack.push(this.element);
        if (this.element.name.equals("object")) {
            if (this.element.children == null) {
                if (this.element.getIndex(NAMESPACE, "value") >= 0) {
                    this.inputType = 0;
                } else {
                    this.inputType = 3;
                    this.attributeIndex = 0;
                }
            }
        } else if (this.element.name.equals("array")) {
            if (this.element.getIndex(NAMESPACE, "value") >= 0) {
                this.inputType = 0;
            }
        } else {
            this.inputType = 0;
        }
    }

    private void endFieldImpl() {
        Object e = this.stack.pop();
        if (e == this) {
            this.inputType = 3;
        } else if (e != null) {
            this.inputType = 2;
            this.element = (SAXElement)e;
        }
        switch (this.inputType) {
            case 2: {
                this.element = this.element.next;
                break;
            }
            case 3: {
                ++this.attributeIndex;
            }
        }
    }

    @Override
    public boolean beginComponent(ManageableType.ArrayComponent arrayComponent, int n) throws IOException {
        if (this.inputType == 2) {
            this.beginFieldImpl();
        } else {
            this.consumeWS();
            switch (this.getc()) {
                case -1: 
                case 125: {
                    return false;
                }
                case 44: {
                    break;
                }
                default: {
                    --this.pos;
                }
            }
            this.stack.push(null);
        }
        this.fieldType = arrayComponent.getType();
        this.totalField.add(arrayComponent);
        this.totalIndices.add(n);
        return true;
    }

    @Override
    public void endComponent() {
        this.totalField.pop();
        this.totalIndices.pop();
        this.endFieldImpl();
    }

    @Override
    public void endArray() {
    }

    @Override
    public ManageableType beginManaged() throws IOException {
        this.wholeBuffer = false;
        XMLPersistenceReader xMLPersistenceReader = null;
        String string = null;
        switch (this.inputType) {
            case 0: {
                this.setBuffer(this.element.getValue(NAMESPACE, "value"));
            }
            case 3: {
                string = this.element.getValue(NAMESPACE, "type");
                break;
            }
            case 2: {
                string = this.element.getValue(NAMESPACE, "type");
                this.element = this.element.children;
                break;
            }
            case 1: {
                this.consumeWS();
                switch (this.getc()) {
                    case 91: {
                        string = this.readName();
                        break;
                    }
                    case 40: {
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                xMLPersistenceReader = this;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.stack.push(xMLPersistenceReader);
        if (this.inputType == 1) {
            this.consumeWS();
            int n = this.pos;
            int n2 = this.nextDelimiter(true);
            this.fieldsProvided = n2 == n || n2 < this.buffer.length() && this.buffer.charAt(n2) == '=';
        } else {
            this.fieldsProvided = true;
        }
        if (string == null) {
            return null;
        }
        ManageableType manageableType = this.bindings.resolveType(string = this.replaceType(string));
        if (manageableType == null) {
            throw new IOException(string);
        }
        return manageableType;
    }

    protected String replaceType(String string) {
        if ("de.grogra.imp3d.shading.Lambert".equals(string)) {
            return "de.grogra.imp3d.shading.Phong";
        }
        if ("de.grogra.imp3d.shading.MappedShader".equals(string)) {
            return "de.grogra.imp3d.shading.SideSwitchShader";
        }
        if ("de.grogra.imp3d.shading.Graytone".equals(string)) {
            return "de.grogra.math.Graytone";
        }
        if ("de.grogra.imp3d.shading.RGBColor".equals(string)) {
            return "de.grogra.math.RGBColor";
        }
        if ("de.grogra.imp3d.objects.NullWithShader".equals(string)) {
            return "de.grogra.imp3d.objects.ShadedNull";
        }
        if ("de.grogra.rgg.Surface".equals(string)) {
            return "de.grogra.imp3d.objects.NURBSSurface";
        }
        if ("de.grogra.lsystem.DTDShoot".equals(string)) {
            return "de.grogra.grogra.DTGShoot";
        }
        if (string.startsWith("de.grogra.lsystem.")) {
            return "de.grogra.turtle." + string.substring(18);
        }
        return string;
    }

    protected ManageableType.Field getManagedField(ManageableType manageableType, String string) {
        return manageableType.getManagedField(string);
    }

    @Override
    public boolean areFieldsProvided() {
        return this.fieldsProvided;
    }

    @Override
    public ManageableType.Field beginField(ManageableType manageableType, ManageableType.Field field) throws IOException {
        do {
            int n;
            String string;
            switch (this.inputType) {
                case 2: {
                    if (this.element == null) {
                        return null;
                    }
                    string = this.element.getValue(NAMESPACE, "name");
                    this.beginFieldImpl();
                    break;
                }
                case 3: {
                    while (true) {
                        if (this.attributeIndex >= this.element.getLength()) {
                            return null;
                        }
                        if (this.element.getURI(this.attributeIndex).length() == 0) break;
                        ++this.attributeIndex;
                    }
                    this.stack.push(this);
                    string = this.element.getLocalName(this.attributeIndex);
                    this.setBuffer(this.element.getValue(this.attributeIndex));
                    break;
                }
                case 1: {
                    this.consumeWS();
                    if (this.getc() == 44) {
                        this.consumeWS();
                    } else {
                        --this.pos;
                    }
                    if (field != null) {
                        this.stack.push(null);
                        this.fieldType = field.getType();
                        this.totalField.add(field);
                        return null;
                    }
                    n = this.nextDelimiter(true);
                    if (n >= this.buffer.length() || this.buffer.charAt(n) != '=') {
                        return null;
                    }
                    this.stack.push(null);
                    string = this.buffer.substring(this.pos, n);
                    this.pos = n + 1;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (string == null) {
                throw new IOException("Unnamed field");
            }
            field = this.getManagedField(manageableType, string);
            if (field != null) continue;
            System.err.println("Field " + string + " cannot be found in " + manageableType);
            this.endFieldImpl();
            if (this.inputType != 1) continue;
            n = 0;
            this.consumeWS();
            block13: do {
                switch (this.getc()) {
                    case 40: 
                    case 91: 
                    case 123: {
                        ++n;
                        break;
                    }
                    case 41: 
                    case 93: 
                    case 125: {
                        --n;
                        break;
                    }
                    case 39: {
                        --this.pos;
                        this.readChar();
                        break;
                    }
                    case 34: {
                        --this.pos;
                        this.readString();
                        break;
                    }
                    default: {
                        if (n != 0) continue block13;
                        --this.pos;
                        this.readString();
                    }
                }
            } while (n > 0);
        } while (field == null);
        this.fieldType = field.getType();
        this.totalField.add(field);
        return field;
    }

    @Override
    public void endField() {
        this.totalField.pop();
        this.endFieldImpl();
    }

    @Override
    public void endManaged() throws IOException {
        if (this.stack.pop() != null) {
            this.consumeWS();
            int n = this.getc();
            if (n != 41 && n != 93) {
                throw new IOException("Unexpected character " + (char)n);
            }
        }
    }

    @Override
    public void setNested(boolean bl) {
    }

    public final void readElements(PersistenceCapable persistenceCapable, SAXElement sAXElement) throws SAXException {
        this.element = sAXElement.children;
        this.inputType = 2;
        this.readFields(persistenceCapable);
    }

    public final void readAttribute(PersistenceCapable persistenceCapable, String string, String string2, String string3) throws SAXException {
        if ("".equals(string)) {
            this.inputType = 3;
            this.attrElement.clear();
            this.attrElement.addAttribute("", string2, string2, "CDATA", string3);
            this.attributeIndex = 0;
            this.element = this.attrElement;
            this.readFields(persistenceCapable);
            return;
        }
        throw new SAXException(string + ':' + string2);
    }

    private void readFields(PersistenceCapable persistenceCapable) throws SAXException {
        try {
            this.totalField.clear();
            this.persistentObject = persistenceCapable;
            persistenceCapable.getManageableType().readObject(this, persistenceCapable, true);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void valueOf(Manageable manageable, String string) {
        this.setBuffer(string);
        this.wholeBuffer = false;
        this.totalField.clear();
        try {
            manageable.getManageableType().readObject(this, manageable, true);
        }
        catch (IOException iOException) {
            throw new WrapException(iOException);
        }
    }

    public Object valueOf(Type type, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object object;
        if (type.getImplementationClass() == String.class) {
            object = string;
        } else if (type.isStringSerializable()) {
            object = type.valueOf(string);
        } else if (type.getImplementationClass() == Class.class) {
            object = this.bindings.getTypeLoader().classForName(string);
        } else if (string.startsWith("serialized:")) {
            try {
                object = Utils.decodeBase64((CharSequence)string, "serialized:".length(), string.length() - "serialized:".length(), this.bindings.getTypeLoader());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = null;
            }
        } else {
            object = type.newInstance();
            if (object instanceof Manageable) {
                this.valueOf((Manageable)object, string);
            }
        }
        return object;
    }

    private int resolve(ObjectList<Object> objectList) {
        int n = 0;
        for (int i = objectList.size() - 4; i >= 0; i -= 4) {
            boolean bl;
            Object object = objectList.get(i);
            if (object == null) continue;
            if (object instanceof Long) {
                bl = (object = this.objects.get((Long)object)) != null;
            } else {
                bl = ((ResolvableReference)object).isResolvable();
                if (bl) {
                    object = ((ResolvableReference)object).resolve();
                }
            }
            if (bl) {
                n |= 1;
                ((IndirectField)objectList.get(i + 1)).setObject((PersistenceCapable)objectList.get(i + 2), (int[])objectList.get(i + 3), object);
                objectList.set(i, null);
                objectList.set(i + 1, null);
                objectList.set(i + 2, null);
                objectList.set(i + 3, null);
                continue;
            }
            n |= 2;
        }
        return n;
    }

    public void resolve() {
        int n;
        do {
            if (((n = this.resolve(this.persistentObjectsToResolve) | this.resolve(this.sharedObjectsToResolve)) & 2) != 0) continue;
            return;
        } while ((n & 1) != 0);
        System.err.println("unresolvable: " + this.persistentObjectsToResolve + " " + this.sharedObjectsToResolve);
    }

    @Override
    public PersistenceCapable resolveId(long l) {
        return this.objects.get(l);
    }
}

