/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.Filter;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ProgressMonitor;
import de.grogra.pf.registry.Registry;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterSourceBase
implements FilterSource {
    private final IOFlavor flavor;
    private final Registry registry;
    private final ModifiableMap metaData;
    private boolean autoProgress = true;
    private String progressText;
    private float progressValue = -2.0f;
    private float progressResolution = 0.01f;
    private ProgressMonitor monitor;

    public FilterSourceBase(IOFlavor iOFlavor, Registry registry, ModifiableMap modifiableMap) {
        this.flavor = iOFlavor;
        this.registry = registry;
        this.metaData = modifiableMap == null ? new StringMap() : modifiableMap;
    }

    @Override
    public final Filter getFilter() {
        return null;
    }

    @Override
    public final IOFlavor getFlavor() {
        return this.flavor;
    }

    @Override
    public final Registry getRegistry() {
        return this.registry;
    }

    @Override
    public <V> V getMetaData(FilterSource.MetaDataKey<V> metaDataKey, V v) {
        return (V)this.metaData.get(metaDataKey.toString(), v);
    }

    @Override
    public <V> void setMetaData(FilterSource.MetaDataKey<V> metaDataKey, V v) {
        this.metaData.put(metaDataKey.toString(), v);
    }

    @Override
    public void initProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }

    protected final boolean useAutoProgress() {
        return this.autoProgress;
    }

    @Override
    public void setProgress(String string, float f) {
        if (f != -2.0f) {
            this.autoProgress = false;
            this.setProgress0(string, f);
        } else {
            this.setProgress0(string, this.progressValue == -2.0f ? -1.0f : this.progressValue);
        }
    }

    protected void setProgress0(String string, float f) {
        if (string == null) {
            string = this.progressText;
        }
        if (Utils.equal(string, this.progressText) && Math.abs(f - this.progressValue) < this.progressResolution) {
            return;
        }
        this.progressText = string;
        this.progressValue = f;
        this.setProgressImpl(string, f);
    }

    protected void setProgressImpl(String string, float f) {
        if (this.monitor != null) {
            this.monitor.setProgress(string, f);
        }
    }

    public String toString() {
        return super.toString() + '[' + this.getSystemId() + ']';
    }
}

