/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.GSReader;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSource;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.RegistryLoader;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.MemoryFileSystem;
import java.io.IOException;
import java.io.InputStream;

public class GSZReader
extends FilterBase
implements ObjectSource,
ProjectLoader {
    private FileSystem fs;

    public GSZReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.PROJECT_LOADER);
    }

    public Object getObject() throws IOException {
        this.fs = new MemoryFileSystem("pfs");
        InputStream inputStream = ((InputStreamSource)this.source).getInputStream();
        this.fs.readJar(inputStream, false);
        inputStream.close();
        return this;
    }

    public void loadRegistry(Registry registry) throws IOException {
        registry.initFileSystem(this.fs);
        Object object = this.fs.getFile("project.gs");
        if (object == null) {
            throw new IOException(IO.I18N.msg("gsz.file-not-found", "project.gs"));
        }
        FilterSource filterSource = new FileSource(this.fs, object, (RegistryContext)registry, null);
        if (!((filterSource = IO.createPipeline(filterSource, IOFlavor.REGISTRY_LOADER)) instanceof ObjectSource)) {
            throw new AssertionError((Object)("gsz-pipeline = " + filterSource));
        }
        ((RegistryLoader)((ObjectSource)filterSource).getObject()).loadRegistry(registry);
    }

    public void loadGraph(Registry registry) throws IOException {
        GSReader.loadGraph(this.fs, registry);
    }
}

